/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ref.GCWatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    final Path path;
    final Path basePath;
    private final boolean myBundled;
    String myName;
    PluginId myId;
    private volatile String myDescription;
    @Nullable
    private String myProductCode;
    @Nullable
    private Date myReleaseDate;
    private int myReleaseVersion;
    private boolean myIsLicenseOptional;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myCategory;
    String myUrl;
    @Nullable
    List<PluginDependency> pluginDependencies;
    @Nullable
    List<PluginId> incompatibilities;
    transient List<Path> jarFiles;
    @Nullable
    private List<Element> myActionElements;
    @Nullable
    private LinkedHashMap<String, List<Element>> epNameToExtensionElements;
    final ContainerDescriptor appContainerDescriptor;
    final ContainerDescriptor projectContainerDescriptor;
    final ContainerDescriptor moduleContainerDescriptor;
    private List<PluginId> myModules;
    private ClassLoader myLoader;
    private String myDescriptionChildText;
    boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    boolean myAllowBundledUpdate;
    boolean myImplementationDetail;
    boolean myRequireRestart;
    private String mySinceBuild;
    private String myUntilBuild;
    private boolean myEnabled;
    private boolean myDeleted;
    private boolean isExtensionsCleared;
    boolean incomplete;
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    public IdeaPluginDescriptorImpl(@NotNull Path path, @NotNull Path basePath, boolean bundled) {
        if (path == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (basePath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(1);
        }
        this.appContainerDescriptor = new ContainerDescriptor();
        this.projectContainerDescriptor = new ContainerDescriptor();
        this.moduleContainerDescriptor = new ContainerDescriptor();
        this.myEnabled = true;
        this.path = path;
        this.basePath = basePath;
        this.myBundled = bundled;
    }

    @ApiStatus.Internal
    @NotNull
    public ContainerDescriptor getApp() {
        ContainerDescriptor containerDescriptor = this.appContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(2);
        }
        return containerDescriptor;
    }

    @ApiStatus.Internal
    @NotNull
    public ContainerDescriptor getProject() {
        ContainerDescriptor containerDescriptor = this.projectContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(3);
        }
        return containerDescriptor;
    }

    @ApiStatus.Internal
    @NotNull
    public ContainerDescriptor getModule() {
        ContainerDescriptor containerDescriptor = this.moduleContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(4);
        }
        return containerDescriptor;
    }

    @NotNull
    public List<IdeaPluginDependency> getDependencies() {
        List<Object> list2 = this.pluginDependencies == null ? Collections.emptyList() : this.pluginDependencies;
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @ApiStatus.Internal
    @NotNull
    public List<PluginDependency> getPluginDependencies() {
        List<Object> list2 = this.pluginDependencies == null ? Collections.emptyList() : this.pluginDependencies;
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public Path getPluginPath() {
        Path path = this.path;
        if (path == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(7);
        }
        return path;
    }

    boolean readExternal(@NotNull Element element2, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver, @NotNull DescriptorListLoadingContext context, @NotNull IdeaPluginDescriptorImpl mainDescriptor) {
        if (element2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(8);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(9);
        }
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(10);
        }
        if (mainDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(11);
        }
        if (JDOMUtil.isEmpty((Element)element2)) {
            this.markAsIncomplete(context, "Empty plugin descriptor", null);
            return false;
        }
        XmlReader.readIdAndName(this, element2);
        PathBasedJdomXIncluder.resolveNonXIncludeElement(element2, this.basePath, context, pathResolver);
        if (this.myId != null && context.isPluginDisabled(this.myId)) {
            this.markAsIncomplete(context, null, null);
        } else if (this.myId == null || this.myName == null) {
            XmlReader.readIdAndName(this, element2);
            if (this.myId != null && context.isPluginDisabled(this.myId)) {
                this.markAsIncomplete(context, null, null);
            }
        }
        if (this.incomplete) {
            this.myDescriptionChildText = element2.getChildTextTrim("description");
            this.myCategory = element2.getChildTextTrim("category");
            this.myVersion = element2.getChildTextTrim("version");
            if (DescriptorListLoadingContext.LOG.isDebugEnabled()) {
                DescriptorListLoadingContext.LOG.debug("Skipping reading of " + this.myId + " from " + this.basePath + " (reason: disabled)");
            }
            List dependsElements = element2.getChildren("depends");
            for (Element dependsElement : dependsElements) {
                this.readPluginDependency(this.basePath, context, dependsElement);
            }
            Element productElement = element2.getChild("product-descriptor");
            if (productElement != null) {
                this.readProduct(context, productElement);
            }
            List moduleElements = element2.getChildren("module");
            for (Element moduleElement : moduleElements) {
                this.readModule(moduleElement);
            }
            return false;
        }
        XmlReader.readMetaInfo(this, element2);
        this.pluginDependencies = null;
        if (this.doRead(element2, context, mainDescriptor)) {
            return false;
        }
        if (this.myVersion == null) {
            this.myVersion = context.getDefaultVersion();
        }
        if (this.pluginDependencies != null) {
            XmlReader.readDependencies(mainDescriptor, this, context, pathResolver, this.pluginDependencies);
        }
        return true;
    }

    public void readForTest(@NotNull Element element2) {
        if (element2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(12);
        }
        this.doRead(element2, DescriptorListLoadingContext.createSingleDescriptorContext(Collections.emptySet()), this);
    }

    private boolean doRead(@NotNull Element element2, @NotNull DescriptorListLoadingContext context, @NotNull IdeaPluginDescriptorImpl mainDescriptor) {
        if (element2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(13);
        }
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(14);
        }
        if (mainDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(15);
        }
        for (Content content2 : element2.getContent()) {
            if (!(content2 instanceof Element)) continue;
            boolean clearContent = true;
            Element child2 = (Element)content2;
            switch (child2.getName()) {
                case "extensions": {
                    this.epNameToExtensionElements = XmlReader.readExtensions(this, this.epNameToExtensionElements, context, child2);
                    break;
                }
                case "extensionPoints": {
                    XmlReader.readExtensionPoints(mainDescriptor, this, child2);
                    break;
                }
                case "actions": {
                    if (this.myActionElements == null) {
                        this.myActionElements = new ArrayList<Element>(child2.getChildren());
                    } else {
                        this.myActionElements.addAll(child2.getChildren());
                    }
                    clearContent = child2.getAttributeValue("resource-bundle") == null;
                    break;
                }
                case "module": {
                    this.readModule(child2);
                    break;
                }
                case "application-components": {
                    IdeaPluginDescriptorImpl.readComponents(child2, this.appContainerDescriptor);
                    break;
                }
                case "project-components": {
                    IdeaPluginDescriptorImpl.readComponents(child2, this.projectContainerDescriptor);
                    break;
                }
                case "module-components": {
                    IdeaPluginDescriptorImpl.readComponents(child2, this.moduleContainerDescriptor);
                    break;
                }
                case "applicationListeners": {
                    XmlReader.readListeners(child2, this.appContainerDescriptor, mainDescriptor);
                    break;
                }
                case "projectListeners": {
                    XmlReader.readListeners(child2, this.projectContainerDescriptor, mainDescriptor);
                    break;
                }
                case "depends": {
                    if (this.readPluginDependency(this.basePath, context, child2)) break;
                    return true;
                }
                case "incompatible-with": {
                    this.readPluginIncompatibility(child2);
                    break;
                }
                case "category": {
                    this.myCategory = StringUtil.nullize((String)child2.getTextTrim());
                    break;
                }
                case "change-notes": {
                    this.myChangeNotes = StringUtil.nullize((String)child2.getTextTrim());
                    break;
                }
                case "version": {
                    this.myVersion = StringUtil.nullize((String)child2.getTextTrim());
                    break;
                }
                case "description": {
                    this.myDescriptionChildText = StringUtil.nullize((String)child2.getTextTrim());
                    break;
                }
                case "resource-bundle": {
                    String value2 = StringUtil.nullize((String)child2.getTextTrim());
                    if (this.myResourceBundleBaseName != null && !Objects.equals(this.myResourceBundleBaseName, value2)) {
                        DescriptorListLoadingContext.LOG.warn("Resource bundle redefinition for plugin '" + mainDescriptor.getPluginId() + "'. Old value: " + this.myResourceBundleBaseName + ", new value: " + value2);
                    }
                    this.myResourceBundleBaseName = value2;
                    break;
                }
                case "product-descriptor": {
                    this.readProduct(context, child2);
                    break;
                }
                case "vendor": {
                    this.myVendor = StringUtil.nullize((String)child2.getTextTrim());
                    this.myVendorEmail = StringUtil.nullize((String)child2.getAttributeValue("email"));
                    this.myVendorUrl = StringUtil.nullize((String)child2.getAttributeValue("url"));
                    break;
                }
                case "idea-version": {
                    this.mySinceBuild = StringUtil.nullize((String)child2.getAttributeValue("since-build"));
                    this.myUntilBuild = StringUtil.nullize((String)child2.getAttributeValue("until-build"));
                    if (this.checkCompatibility(context)) break;
                    return true;
                }
            }
            if (!clearContent) continue;
            child2.getContent().clear();
        }
        return false;
    }

    private void readModule(Element child2) {
        String moduleName = child2.getAttributeValue("value");
        if (moduleName != null) {
            if (this.myModules == null) {
                this.myModules = Collections.singletonList(PluginId.getId((String)moduleName));
            } else {
                if (this.myModules.size() == 1) {
                    List<PluginId> singleton = this.myModules;
                    this.myModules = new ArrayList<PluginId>(4);
                    this.myModules.addAll(singleton);
                }
                this.myModules.add(PluginId.getId((String)moduleName));
            }
        }
    }

    private void readProduct(@NotNull DescriptorListLoadingContext context, @NotNull Element child2) {
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(16);
        }
        if (child2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(17);
        }
        this.myProductCode = StringUtil.nullize((String)child2.getAttributeValue("code"));
        this.myReleaseDate = this.parseReleaseDate(child2.getAttributeValue("release-date"), context);
        this.myReleaseVersion = StringUtil.parseInt((String)child2.getAttributeValue("release-version"), (int)0);
        this.myIsLicenseOptional = Boolean.parseBoolean(child2.getAttributeValue("optional", "false"));
    }

    private void readPluginIncompatibility(@NotNull Element child2) {
        String pluginId;
        if (child2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(18);
        }
        if ((pluginId = child2.getTextTrim()).isEmpty()) {
            return;
        }
        if (this.incompatibilities == null) {
            this.incompatibilities = new ArrayList<PluginId>();
        }
        this.incompatibilities.add(PluginId.getId((String)pluginId));
    }

    private boolean readPluginDependency(@NotNull Path basePath, @NotNull DescriptorListLoadingContext context, @NotNull Element child2) {
        String dependencyIdString;
        if (basePath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(19);
        }
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(20);
        }
        if (child2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(21);
        }
        if ((dependencyIdString = child2.getTextTrim()).isEmpty()) {
            return true;
        }
        PluginId dependencyId = PluginId.getId((String)dependencyIdString);
        boolean isOptional = Boolean.parseBoolean(child2.getAttributeValue("optional"));
        boolean isDisabledOrBroken = false;
        if (context.isPluginDisabled(dependencyId)) {
            if (!isOptional) {
                this.markAsIncomplete(context, "Non-optional dependency plugin " + dependencyId + " is disabled", dependencyId);
            }
            isDisabledOrBroken = true;
        } else if (context.result.isBroken(dependencyId)) {
            if (!isOptional) {
                DescriptorListLoadingContext.LOG.info("Skipping reading of " + this.myId + " from " + basePath + " (reason: non-optional dependency " + dependencyId + " is broken)");
                this.markAsIncomplete(context, "Non-optional dependency " + dependencyId + " is broken", null);
                return false;
            }
            isDisabledOrBroken = true;
        }
        PluginDependency dependency = new PluginDependency(dependencyId, StringUtil.nullize((String)child2.getAttributeValue("config-file")), isDisabledOrBroken);
        dependency.isOptional = isOptional;
        if (this.pluginDependencies == null) {
            this.pluginDependencies = new ArrayList<PluginDependency>();
        } else {
            for (PluginDependency item : this.pluginDependencies) {
                if (item.id != dependencyId) continue;
                if (item.isOptional) {
                    if (isOptional) continue;
                    item.isOptional = false;
                    continue;
                }
                dependency.isOptional = false;
                if (item.configFile != null) continue;
                item.configFile = dependency.configFile;
                return true;
            }
        }
        this.pluginDependencies.add(dependency);
        return true;
    }

    private boolean checkCompatibility(@NotNull DescriptorListLoadingContext context) {
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(22);
        }
        String since = this.mySinceBuild;
        String until = this.myUntilBuild;
        if (this.isBundled() || since == null && until == null) {
            return true;
        }
        String message = PluginManagerCore.getIncompatibleMessage(context.result.productBuildNumber.get(), since, until);
        if (message == null) {
            return true;
        }
        this.markAsIncomplete(context, null, null);
        context.result.reportIncompatiblePlugin(this, message, since, until);
        return false;
    }

    @NotNull
    String formatErrorMessage(@NotNull String message) {
        if (message == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(23);
        }
        String path = this.path.toString();
        StringBuilder builder2 = new StringBuilder();
        builder2.append("The ").append(this.myName).append(" (id=").append(this.myId).append(", path=");
        builder2.append(FileUtil.getLocationRelativeToUserHome((String)path, (boolean)false));
        if (this.myVersion != null && !this.isBundled() && !this.myVersion.equals(PluginManagerCore.getBuildNumber().asString())) {
            builder2.append(", version=").append(this.myVersion);
        }
        builder2.append(") plugin ").append(message);
        String string = builder2.toString();
        if (string == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(24);
        }
        return string;
    }

    private void markAsIncomplete(@NotNull DescriptorListLoadingContext context, @Nullable String errorMessage, @Nullable PluginId disabledDependency) {
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(25);
        }
        boolean wasIncomplete = this.incomplete;
        this.incomplete = true;
        this.setEnabled(false);
        if (this.myId != null && !wasIncomplete) {
            PluginError pluginError;
            PluginError pluginError2 = pluginError = errorMessage == null ? null : new PluginError(this, errorMessage, null, false);
            if (pluginError != null && disabledDependency != null) {
                pluginError.setDisabledDependency(disabledDependency);
            }
            context.result.addIncompletePlugin(this, pluginError);
        }
    }

    private static void readComponents(@NotNull Element parent, @NotNull ContainerDescriptor containerDescriptor) {
        List content2;
        int contentSize;
        if (parent == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(26);
        }
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(27);
        }
        if ((contentSize = (content2 = parent.getContent()).size()) == 0) {
            return;
        }
        List<ComponentConfig> result2 = containerDescriptor.getComponentListToAdd(contentSize);
        for (Content child2 : content2) {
            Element componentElement;
            if (!(child2 instanceof Element) || !(componentElement = (Element)child2).getName().equals("component")) continue;
            ComponentConfig componentConfig = new ComponentConfig();
            Map<String, String> options2 = null;
            for (Element elementChild : componentElement.getChildren()) {
                switch (elementChild.getName()) {
                    case "skipForDefaultProject": {
                        if (IdeaPluginDescriptorImpl.readBoolValue(elementChild.getTextTrim())) break;
                        componentConfig.setLoadForDefaultProject(true);
                        break;
                    }
                    case "loadForDefaultProject": {
                        componentConfig.setLoadForDefaultProject(IdeaPluginDescriptorImpl.readBoolValue(elementChild.getTextTrim()));
                        break;
                    }
                    case "interface-class": {
                        componentConfig.setInterfaceClass(elementChild.getTextTrim());
                        break;
                    }
                    case "implementation-class": {
                        componentConfig.setImplementationClass(elementChild.getTextTrim());
                        break;
                    }
                    case "headless-implementation-class": {
                        componentConfig.setHeadlessImplementationClass(elementChild.getTextTrim());
                        break;
                    }
                    case "option": {
                        String name = elementChild.getAttributeValue("name");
                        String value2 = elementChild.getAttributeValue("value");
                        if (name == null) break;
                        if (name.equals("os")) {
                            if (value2 == null || XmlReader.isSuitableForOs(value2)) break;
                            break;
                        }
                        if (options2 == null) {
                            options2 = Collections.singletonMap(name, value2);
                            break;
                        }
                        if (options2.size() == 1) {
                            options2 = new HashMap<String, String>(options2);
                        }
                        options2.put(name, value2);
                    }
                }
            }
            if (options2 != null) {
                componentConfig.options = options2;
            }
            result2.add(componentConfig);
        }
    }

    private static boolean readBoolValue(@NotNull String value2) {
        if (value2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(28);
        }
        return value2.isEmpty() || value2.equalsIgnoreCase("true");
    }

    @Nullable
    private Date parseReleaseDate(@Nullable String dateStr, @NotNull DescriptorListLoadingContext context) {
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(29);
        }
        if (StringUtil.isEmpty((String)dateStr)) {
            return null;
        }
        try {
            return context.getDateParser().parse(dateStr);
        }
        catch (ParseException e) {
            DescriptorListLoadingContext.LOG.info("Error parse release date from plugin descriptor for plugin " + this.myName + " {" + this.myId + "}: " + e.getMessage());
            return null;
        }
    }

    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build2) {
        if (build2 == null) {
            return null;
        }
        Matcher matcher = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build2);
        if (matcher.matches()) {
            return matcher.group(1) + ".*";
        }
        return build2;
    }

    @NotNull
    public ContainerDescriptor getAppContainerDescriptor() {
        ContainerDescriptor containerDescriptor = this.appContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(30);
        }
        return containerDescriptor;
    }

    @ApiStatus.Internal
    public void registerExtensions(@NotNull ExtensionsAreaImpl area, @NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull ContainerDescriptor containerDescriptor, @Nullable List<Runnable> listenerCallbacks) {
        Map<String, List<Element>> extensions2;
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(31);
        }
        if (rootDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(32);
        }
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(33);
        }
        if ((extensions2 = containerDescriptor.extensions) != null) {
            area.registerExtensions(extensions2, (PluginDescriptor)rootDescriptor, listenerCallbacks);
            return;
        }
        if (this.epNameToExtensionElements == null) {
            return;
        }
        containerDescriptor.extensions = this.epNameToExtensionElements;
        LinkedHashMap<String, List<Element>> other = null;
        Iterator<Map.Entry<String, List<Element>>> iterator2 = containerDescriptor.extensions.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, List<Element>> entry = iterator2.next();
            if (area.registerExtensions(entry.getKey(), entry.getValue(), (PluginDescriptor)rootDescriptor, listenerCallbacks)) continue;
            iterator2.remove();
            if (other == null) {
                other = new LinkedHashMap<String, List<Element>>();
            }
            IdeaPluginDescriptorImpl.addExtensionList(other, entry.getKey(), entry.getValue());
        }
        this.isExtensionsCleared = true;
        if (containerDescriptor.extensions.isEmpty()) {
            containerDescriptor.extensions = Collections.emptyMap();
        }
        if (containerDescriptor == this.projectContainerDescriptor) {
            this.moduleContainerDescriptor.extensions = other;
            this.epNameToExtensionElements = null;
        } else {
            this.epNameToExtensionElements = other;
        }
    }

    public String getDescription() {
        String result2 = this.myDescription;
        if (result2 != null) {
            return result2;
        }
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = DynamicBundle.INSTANCE.getResourceBundle(this.myResourceBundleBaseName, this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                PluginManagerCore.getLogger().info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        result2 = bundle == null ? this.myDescriptionChildText : AbstractBundle.messageOrDefault((ResourceBundle)bundle, (String)("plugin." + this.myId + ".description"), (String)StringUtil.notNullize((String)this.myDescriptionChildText), (Object[])new Object[0]);
        this.myDescription = result2;
        return result2;
    }

    public String getChangeNotes() {
        return this.myChangeNotes;
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getProductCode() {
        return this.myProductCode;
    }

    @Nullable
    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    public int getReleaseVersion() {
        return this.myReleaseVersion;
    }

    public boolean isLicenseOptional() {
        return this.myIsLicenseOptional;
    }

    public PluginId @NotNull [] getDependentPluginIds() {
        if (this.pluginDependencies == null || this.pluginDependencies.isEmpty()) {
            if (PluginId.EMPTY_ARRAY == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(34);
            }
            return PluginId.EMPTY_ARRAY;
        }
        int size = this.pluginDependencies.size();
        PluginId[] result2 = new PluginId[size];
        for (int i2 = 0; i2 < size; ++i2) {
            result2[i2] = this.pluginDependencies.get((int)i2).id;
        }
        if (result2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(35);
        }
        return result2;
    }

    public PluginId @NotNull [] getOptionalDependentPluginIds() {
        if (this.pluginDependencies == null || this.pluginDependencies.isEmpty()) {
            if (PluginId.EMPTY_ARRAY == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(36);
            }
            return PluginId.EMPTY_ARRAY;
        }
        PluginId[] pluginIdArray = (PluginId[])this.pluginDependencies.stream().filter(it -> it.isOptional).map(it -> it.id).toArray(PluginId[]::new);
        if (pluginIdArray == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(37);
        }
        return pluginIdArray;
    }

    public String getVendor() {
        return this.myVendor;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getResourceBundleBaseName() {
        return this.myResourceBundleBaseName;
    }

    public String getCategory() {
        return this.myCategory;
    }

    public void setCategory(String category) {
        this.myCategory = category;
    }

    @Nullable
    public Map<String, List<Element>> getExtensions() {
        if (this.isExtensionsCleared) {
            throw new IllegalStateException("Trying to retrieve extensions list after extension elements have been cleared");
        }
        if (this.epNameToExtensionElements == null) {
            return null;
        }
        return new LinkedHashMap<String, List<Element>>(this.epNameToExtensionElements);
    }

    @Deprecated
    @NotNull
    public List<File> getClassPath() {
        File[] files2;
        File path = this.path.toFile();
        if (!path.isDirectory()) {
            List<File> list2 = Collections.singletonList(path);
            if (list2 == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(38);
            }
            return list2;
        }
        ArrayList<File> result2 = new ArrayList<File>();
        File classesDir = new File(path, "classes");
        if (classesDir.exists()) {
            result2.add(classesDir);
        }
        if ((files2 = new File(path, "lib").listFiles()) == null || files2.length <= 0) {
            ArrayList<File> arrayList = result2;
            if (arrayList == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(39);
            }
            return arrayList;
        }
        for (File f : files2) {
            if (f.isFile()) {
                String name = f.getName();
                if (!StringUtil.endsWithIgnoreCase((String)name, (String)".jar") && !StringUtil.endsWithIgnoreCase((String)name, (String)".zip")) continue;
                result2.add(f);
                continue;
            }
            result2.add(f);
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    List<Path> collectClassPath(@NotNull Map<String, String[]> additionalLayoutMap) {
        Path productionDirectory;
        if (additionalLayoutMap == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(41);
        }
        if (!Files.isDirectory(this.path, new LinkOption[0])) {
            List<Path> list2 = Collections.singletonList(this.path);
            if (list2 == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(42);
            }
            return list2;
        }
        ArrayList<Path> result2 = new ArrayList<Path>();
        Path classesDir = this.path.resolve("classes");
        if (Files.exists(classesDir, new LinkOption[0])) {
            result2.add(classesDir);
        }
        if (PluginManagerCore.usePluginClassLoader && (productionDirectory = this.path.getParent()).endsWith("production")) {
            result2.add(this.path);
            String moduleName = this.path.getFileName().toString();
            String[] additionalPaths = additionalLayoutMap.get(moduleName);
            if (additionalPaths != null) {
                for (String path : additionalPaths) {
                    result2.add(productionDirectory.resolve(path));
                }
            }
        }
        try (DirectoryStream<Path> childStream2 = Files.newDirectoryStream(this.path.resolve("lib"));){
            for (Path f : childStream2) {
                if (Files.isRegularFile(f, new LinkOption[0])) {
                    String name = f.getFileName().toString();
                    if (!StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".jar") && !StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".zip")) continue;
                    result2.add(f);
                    continue;
                }
                result2.add(f);
            }
        }
        catch (NoSuchFileException childStream2) {
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().debug((Throwable)e);
        }
        ArrayList<Path> arrayList = result2;
        if (arrayList == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @Nullable
    public List<Element> getActionDescriptionElements() {
        return this.myActionElements;
    }

    public String getVendorEmail() {
        return this.myVendorEmail;
    }

    public String getVendorUrl() {
        return this.myVendorUrl;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(String val) {
        this.myUrl = val;
    }

    public boolean isDeleted() {
        return this.myDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.myDeleted = deleted;
    }

    public void setLoader(@Nullable ClassLoader loader) {
        this.myLoader = loader;
    }

    public boolean unloadClassLoader(int timeoutMs) {
        if (timeoutMs == 0) {
            this.myLoader = null;
            return true;
        }
        GCWatcher watcher = GCWatcher.tracking((Object[])new Object[]{this.myLoader});
        this.myLoader = null;
        return watcher.tryCollect(timeoutMs);
    }

    public PluginId getPluginId() {
        return this.myId;
    }

    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    public boolean isUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    void setUseCoreClassLoader() {
        this.myUseCoreClassLoader = true;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    void mergeOptionalConfig(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(44);
        }
        if (this.epNameToExtensionElements == null) {
            this.epNameToExtensionElements = descriptor2.epNameToExtensionElements;
        } else if (descriptor2.epNameToExtensionElements != null) {
            descriptor2.epNameToExtensionElements.forEach((name, list2) -> IdeaPluginDescriptorImpl.addExtensionList(this.epNameToExtensionElements, name, list2));
        }
        if (this.myActionElements == null) {
            this.myActionElements = descriptor2.myActionElements;
        } else if (descriptor2.myActionElements != null) {
            this.myActionElements.addAll(descriptor2.myActionElements);
        }
        this.appContainerDescriptor.merge(descriptor2.appContainerDescriptor);
        this.projectContainerDescriptor.merge(descriptor2.projectContainerDescriptor);
        this.moduleContainerDescriptor.merge(descriptor2.moduleContainerDescriptor);
    }

    private static void addExtensionList(@NotNull Map<String, List<Element>> map2, @NotNull String name, @NotNull List<Element> list2) {
        List mapList;
        if (map2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(45);
        }
        if (name == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(46);
        }
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(47);
        }
        if ((mapList = map2.computeIfAbsent(name, __ -> list2)) != list2) {
            mapList.addAll(list2);
        }
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public boolean allowBundledUpdate() {
        return this.myAllowBundledUpdate;
    }

    public boolean isImplementationDetail() {
        return this.myImplementationDetail;
    }

    public boolean isRequireRestart() {
        return this.myRequireRestart;
    }

    @NotNull
    public List<PluginId> getModules() {
        List<Object> list2 = this.myModules == null ? Collections.emptyList() : this.myModules;
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(48);
        }
        return list2;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof IdeaPluginDescriptorImpl && this.myId == ((IdeaPluginDescriptorImpl)o).myId;
    }

    public int hashCode() {
        return Objects.hashCode(this.myId);
    }

    public String toString() {
        return "PluginDescriptor(name=" + this.myName + ", id=" + this.myId + ", path=" + this.path + ", version=" + this.myVersion + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDescriptor";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerDescriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalLayoutMap";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getApp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "formatErrorMessage";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppContainerDescriptor";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentPluginIds";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalDependentPluginIds";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readForTest";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readProduct";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readPluginIncompatibility";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readPluginDependency";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkCompatibility";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "markAsIncomplete";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readComponents";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readBoolValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseReleaseDate";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPath";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfig";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OS {
        mac,
        linux,
        windows,
        unix,
        freebsd;

    }
}

