/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionTreeElement;
import com.intellij.ide.structureView.impl.StructureViewFactoryImpl;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.newStructureView.TreeActionWrapper;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StructureViewComponent
extends SimpleToolWindowPanel
implements TreeActionsOwner,
DataProvider,
StructureView.Scrollable {
    private static final Logger LOG = Logger.getInstance(StructureViewComponent.class);
    private static final Key<TreeState> STRUCTURE_VIEW_STATE_KEY = Key.create((String)"STRUCTURE_VIEW_STATE");
    private static final Key<Boolean> STRUCTURE_VIEW_STATE_RESTORED_KEY = Key.create((String)"STRUCTURE_VIEW_STATE_RESTORED_KEY");
    private static final AtomicInteger ourSettingsModificationCount = new AtomicInteger();
    private FileEditor myFileEditor;
    private final TreeModelWrapper myTreeModelWrapper;
    private final Project myProject;
    private final StructureViewModel myTreeModel;
    private final Tree myTree;
    private final SmartTreeStructure myTreeStructure;
    private final StructureTreeModel<SmartTreeStructure> myStructureTreeModel;
    private final AsyncTreeModel myAsyncTreeModel;
    private final SingleAlarm myUpdateAlarm;
    private volatile AsyncPromise<TreePath> myCurrentFocusPromise;
    private boolean myAutoscrollFeedback;
    private volatile boolean myDisposed;
    private boolean myStoreStateDisabled;
    private final Alarm myAutoscrollAlarm;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private final MyAutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final AutoScrollFromSourceHandler myAutoScrollFromSourceHandler;
    @Nullable
    private volatile CancellablePromise<?> myLastAutoscrollPromise;

    public StructureViewComponent(@Nullable FileEditor editor, @NotNull StructureViewModel structureViewModel, @NotNull Project project, boolean showRootNode) {
        if (structureViewModel == null) {
            StructureViewComponent.$$$reportNull$$$0(0);
        }
        if (project == null) {
            StructureViewComponent.$$$reportNull$$$0(1);
        }
        super(true, true);
        this.myAutoscrollAlarm = new Alarm((Disposable)this);
        this.myProject = project;
        this.myFileEditor = editor;
        this.myTreeModel = structureViewModel;
        this.myTreeModelWrapper = new TreeModelWrapper(this.myTreeModel, this);
        this.myTreeStructure = new SmartTreeStructure(project, (TreeModel)this.myTreeModelWrapper){

            @Override
            public void rebuildTree() {
                if (StructureViewComponent.this.isDisposed()) {
                    return;
                }
                super.rebuildTree();
            }

            public boolean isToBuildChildrenInBackground(@NotNull Object element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return Registry.is((String)"ide.structureView.StructureViewTreeStructure.BuildChildrenInBackground") || this.getRootElement() == element2;
            }

            @Override
            @NotNull
            protected TreeElementWrapper createTree() {
                return new MyNodeWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
            }

            public String toString() {
                return "structure view tree structure(model=" + StructureViewComponent.this.myTreeModel + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/structureView/newStructureView/StructureViewComponent$1", "isToBuildChildrenInBackground"));
            }
        };
        this.myStructureTreeModel = new StructureTreeModel<SmartTreeStructure>(this.myTreeStructure, (Disposable)this);
        this.myAsyncTreeModel = new AsyncTreeModel((javax.swing.tree.TreeModel)((Object)this.myStructureTreeModel), (Disposable)this);
        this.myAsyncTreeModel.setRootImmediately(this.myStructureTreeModel.getRootImmediately());
        this.myTree = new MyTree((javax.swing.tree.TreeModel)((Object)this.myAsyncTreeModel));
        Disposer.register((Disposable)this, (Disposable)this.myTreeModelWrapper);
        StructureViewComponent.registerAutoExpandListener((JTree)this.myTree, this.myTreeModel);
        this.myUpdateAlarm = new SingleAlarm(this::rebuild, 200, (Disposable)this);
        this.myTree.setRootVisible(showRootNode);
        this.myTree.getEmptyText().setText(LangBundle.message((String)"status.text.structure.empty", (Object[])new Object[0]));
        ModelListener modelListener2 = () -> this.queueUpdate();
        this.myTreeModelWrapper.addModelListener(modelListener2);
        Disposer.register((Disposable)this, () -> {
            this.storeState();
            this.myTreeModelWrapper.removeModelListener(modelListener2);
        });
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        this.myAutoScrollToSourceHandler = new MyAutoScrollToSourceHandler();
        this.myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler(this.myProject, (Disposable)this);
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, (JComponent)this.myTree);
        this.setToolbar(this.createToolbar());
        this.setupTree();
    }

    public static void registerAutoExpandListener(@NotNull JTree tree, @NotNull StructureViewModel structureViewModel) {
        if (tree == null) {
            StructureViewComponent.$$$reportNull$$$0(2);
        }
        if (structureViewModel == null) {
            StructureViewComponent.$$$reportNull$$$0(3);
        }
        tree.getModel().addTreeModelListener((TreeModelListener)((Object)new MyExpandListener(tree, (StructureViewModel.ExpandInfoProvider)ObjectUtils.tryCast((Object)structureViewModel, StructureViewModel.ExpandInfoProvider.class))));
    }

    protected boolean showScrollToFromSourceActions() {
        return true;
    }

    public FileEditor getFileEditor() {
        return this.myFileEditor;
    }

    private StructureViewFactoryImpl.State getSettings() {
        return ((StructureViewFactoryImpl)StructureViewFactory.getInstance((Project)this.myProject)).getState();
    }

    public void showToolbar() {
        this.setToolbar(this.createToolbar());
    }

    @NotNull
    private JComponent createToolbar() {
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("StructureViewToolbar", this.createActionGroup(), true).getComponent();
        if (jComponent == null) {
            StructureViewComponent.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    private void setupTree() {
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.setShowsRootHandles(true);
        StructureViewComponent.registerPsiListener(this.myProject, (Disposable)this, this::queueUpdate);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, o -> this.rebuild());
        if (this.showScrollToFromSourceActions()) {
            this.myAutoScrollToSourceHandler.install((JTree)this.myTree);
            this.myAutoScrollFromSourceHandler.install();
        }
        TreeUtil.installActions((JTree)this.getTree());
        new TreeSpeedSearch(this.getTree(), (Convertor<? super TreePath, String>)((Convertor)treePath -> {
            Object userObject = TreeUtil.getLastUserObject((TreePath)treePath);
            return userObject != null ? FileStructurePopup.getSpeedSearchText(userObject) : null;
        }));
        this.addTreeKeyListener();
        this.addTreeMouseListeners();
        this.restoreState();
    }

    public static void registerPsiListener(@NotNull Project project, @NotNull Disposable disposable2, @NotNull Runnable onChange) {
        if (project == null) {
            StructureViewComponent.$$$reportNull$$$0(5);
        }
        if (disposable2 == null) {
            StructureViewComponent.$$$reportNull$$$0(6);
        }
        if (onChange == null) {
            StructureViewComponent.$$$reportNull$$$0(7);
        }
        MyPsiTreeChangeListener psiListener = new MyPsiTreeChangeListener(PsiManager.getInstance((Project)project).getModificationTracker(), onChange);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)psiListener, disposable2);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            StructureViewComponent.$$$reportNull$$$0(8);
        }
        return project;
    }

    @NotNull
    public JTree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            StructureViewComponent.$$$reportNull$$$0(9);
        }
        return tree;
    }

    public void queueUpdate() {
        this.myUpdateAlarm.cancelAndRequest();
    }

    public void rebuild() {
        this.myStructureTreeModel.getInvoker().invoke(() -> {
            ComponentUtil.putClientProperty((JComponent)this.myTree, STRUCTURE_VIEW_STATE_RESTORED_KEY, null);
            this.myTreeStructure.rebuildTree();
            this.myStructureTreeModel.invalidate();
        });
    }

    @NotNull
    private static JBTreeTraverser<Object> traverser() {
        JBTreeTraverser jBTreeTraverser = JBTreeTraverser.from(o -> o instanceof Group ? ((Group)o).getChildren() : null);
        if (jBTreeTraverser == null) {
            StructureViewComponent.$$$reportNull$$$0(10);
        }
        return jBTreeTraverser;
    }

    private JBIterable<Object> getSelectedValues() {
        return StructureViewComponent.getSelectedValues(this.getTree());
    }

    @NotNull
    public static JBIterable<Object> getSelectedValues(JTree tree) {
        JBIterable jBIterable = ((JBTreeTraverser)StructureViewComponent.traverser().withRoots((Iterable)JBIterable.of((Object[])tree.getSelectionPaths()).map(TreePath::getLastPathComponent).filterMap(StructureViewComponent::unwrapValue))).traverse();
        if (jBIterable == null) {
            StructureViewComponent.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    private void addTreeMouseListeners() {
        EditSourceOnDoubleClickHandler.install((JTree)this.getTree());
        CustomizationUtil.installPopupHandler(this.getTree(), "StructureViewPopupMenu", "StructureViewPopup");
    }

    private void addTreeKeyListener() {
        this.getTree().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)StructureViewComponent.this.getTree());
                    OpenSourceUtil.openSourcesFrom((DataContext)dataContext, (boolean)false);
                } else if (27 == e.getKeyCode()) {
                    boolean[] isCopied;
                    if (e.isConsumed()) {
                        return;
                    }
                    PsiCopyPasteManager copyPasteManager = PsiCopyPasteManager.getInstance();
                    if (copyPasteManager.getElements(isCopied = new boolean[1]) != null && !isCopied[0]) {
                        copyPasteManager.clear();
                        e.consume();
                    }
                }
            }
        });
    }

    public void storeState() {
        if (this.isDisposed() || !this.myProject.isOpen() || this.myStoreStateDisabled) {
            return;
        }
        Object root = this.myTree.getModel().getRoot();
        if (root == null) {
            return;
        }
        TreeState state = TreeState.createOn((JTree)this.myTree, (TreePath)new TreePath(root));
        if (this.myFileEditor != null) {
            this.myFileEditor.putUserData(STRUCTURE_VIEW_STATE_KEY, (Object)state);
        }
        ComponentUtil.putClientProperty((JComponent)this.myTree, STRUCTURE_VIEW_STATE_RESTORED_KEY, null);
    }

    public void disableStoreState() {
        this.myStoreStateDisabled = true;
    }

    public void restoreState() {
        TreeState state;
        TreeState treeState = state = this.myFileEditor == null ? null : (TreeState)this.myFileEditor.getUserData(STRUCTURE_VIEW_STATE_KEY);
        if (state == null) {
            if (!Boolean.TRUE.equals(ComponentUtil.getClientProperty((JComponent)this.myTree, STRUCTURE_VIEW_STATE_RESTORED_KEY))) {
                TreeUtil.expand((JTree)this.getTree(), (int)StructureViewComponent.getMinimumExpandDepth(this.myTreeModel));
            }
        } else {
            ComponentUtil.putClientProperty((JComponent)this.myTree, STRUCTURE_VIEW_STATE_RESTORED_KEY, (Object)true);
            state.applyTo((JTree)this.myTree);
            if (this.myFileEditor != null) {
                this.myFileEditor.putUserData(STRUCTURE_VIEW_STATE_KEY, null);
            }
        }
    }

    @NotNull
    protected ActionGroup createActionGroup() {
        Filter[] filters;
        Sorter[] sorters;
        DefaultActionGroup result2 = new DefaultActionGroup();
        for (Sorter sorter : sorters = this.myTreeModel.getSorters()) {
            if (!sorter.isVisible()) continue;
            result2.add((AnAction)new TreeActionWrapper((TreeAction)sorter, this));
        }
        if (sorters.length > 0) {
            result2.addSeparator();
        }
        this.addGroupByActions(result2);
        for (Filter filter2 : filters = this.myTreeModel.getFilters()) {
            result2.add((AnAction)new TreeActionWrapper((TreeAction)filter2, this));
        }
        if (this.myTreeModel instanceof ProvidingTreeModel) {
            Collection providers = ((ProvidingTreeModel)this.myTreeModel).getNodeProviders();
            for (NodeProvider provider : providers) {
                result2.add((AnAction)new TreeActionWrapper((TreeAction)provider, this));
            }
        }
        if (this.showScrollToFromSourceActions()) {
            result2.addSeparator();
            result2.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
            result2.add((AnAction)this.myAutoScrollFromSourceHandler.createToggleAction());
        }
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            StructureViewComponent.$$$reportNull$$$0(12);
        }
        return defaultActionGroup;
    }

    protected void addGroupByActions(@NotNull DefaultActionGroup result2) {
        Grouper[] groupers;
        if (result2 == null) {
            StructureViewComponent.$$$reportNull$$$0(13);
        }
        for (Grouper grouper : groupers = this.myTreeModel.getGroupers()) {
            result2.add((AnAction)new TreeActionWrapper((TreeAction)grouper, this));
        }
    }

    public Promise<AbstractTreeNode<?>> expandPathToElement(Object element2) {
        return this.expandSelectFocusInner(element2, false, false).then(p -> (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)p));
    }

    @NotNull
    public Promise<TreePath> select(Object element2, boolean requestFocus) {
        return this.expandSelectFocusInner(element2, true, requestFocus);
    }

    @NotNull
    private Promise<TreePath> expandSelectFocusInner(Object element2, boolean select, boolean requestFocus) {
        final AsyncPromise result2 = this.myCurrentFocusPromise = new AsyncPromise();
        final int[] stage = new int[]{1, 0};
        final TreePath[] deepestPath = new TreePath[]{null};
        final TreeVisitor visitor = path -> {
            if (this.myCurrentFocusPromise != result2) {
                result2.setError("rejected");
                return TreeVisitor.Action.INTERRUPT;
            }
            Object last = path.getLastPathComponent();
            Object userObject = StructureViewComponent.unwrapNavigatable(last);
            Object value2 = StructureViewComponent.unwrapValue(last);
            if (Comparing.equal((Object)value2, (Object)element2) || userObject instanceof AbstractTreeNode && ((AbstractTreeNode)userObject).canRepresent(element2)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            if (value2 instanceof PsiElement && element2 instanceof PsiElement) {
                if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)value2), (PsiElement)((PsiElement)element2), (boolean)true)) {
                    int count = path.getPathCount();
                    if (stage[1] == 0 || stage[1] < count) {
                        stage[1] = count;
                        deepestPath[0] = path;
                    }
                } else if (stage[0] != 3) {
                    stage[0] = 2;
                    return TreeVisitor.Action.SKIP_CHILDREN;
                }
            }
            return TreeVisitor.Action.CONTINUE;
        };
        final Function action2 = path -> {
            if (select) {
                TreeUtil.selectPath((JTree)this.myTree, (TreePath)path);
            } else {
                this.myTree.expandPath(path);
            }
            if (requestFocus) {
                IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTree, false);
            }
            return Promises.resolvedPromise((Object)path);
        };
        Function<TreePath, Promise<TreePath>> fallback = new Function<TreePath, Promise<TreePath>>(){

            public Promise<TreePath> fun(TreePath path) {
                if (StructureViewComponent.this.myCurrentFocusPromise != result2) {
                    result2.setError("rejected");
                    return Promises.rejectedPromise();
                }
                if (path == null && stage[0] == 2) {
                    stage[0] = 3;
                    return StructureViewComponent.this.myAsyncTreeModel.accept(visitor).thenAsync((Function)this);
                }
                TreePath adjusted = path == null ? deepestPath[0] : path;
                return adjusted == null ? Promises.rejectedPromise() : (Promise)action2.fun((Object)adjusted);
            }
        };
        this.myAsyncTreeModel.accept(visitor).thenAsync((Function)fallback).processed((Promise)result2);
        AsyncPromise<TreePath> asyncPromise = this.myCurrentFocusPromise;
        if (asyncPromise == null) {
            StructureViewComponent.$$$reportNull$$$0(14);
        }
        return asyncPromise;
    }

    private void scrollToSelectedElement() {
        if (this.myAutoscrollFeedback) {
            this.myAutoscrollFeedback = false;
            return;
        }
        if (!this.getSettings().AUTOSCROLL_FROM_SOURCE) {
            return;
        }
        this.cancelScrollToSelectedElement();
        this.myAutoscrollAlarm.cancelAllRequests();
        this.myAutoscrollAlarm.addRequest(this::scrollToSelectedElementLater, 1000);
    }

    private void cancelScrollToSelectedElement() {
        CancellablePromise<?> lastPromise = this.myLastAutoscrollPromise;
        if (lastPromise != null && !lastPromise.isCancelled()) {
            lastPromise.cancel();
        }
    }

    private void scrollToSelectedElementLater() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.cancelScrollToSelectedElement();
        if (this.isDisposed()) {
            return;
        }
        this.myLastAutoscrollPromise = ReadAction.nonBlocking(this::doFindSelectedElement).withDocumentsCommitted(this.myProject).expireWith((Disposable)this).finishOnUiThread(ModalityState.current(), this::doScrollToSelectedElement).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    private Object doFindSelectedElement() {
        try {
            return this.myTreeModel.getCurrentEditorElement();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            return null;
        }
    }

    private void doScrollToSelectedElement(@Nullable Object currentEditorElement) {
        if (currentEditorElement == null) {
            return;
        }
        if (UIUtil.isFocusAncestor((Component)((Object)this))) {
            return;
        }
        this.select(currentEditorElement, false);
    }

    public void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)Thread.currentThread().getName());
        this.myDisposed = true;
        this.myFileEditor = null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void centerSelectedRow() {
        TreePath path = this.getTree().getSelectionPath();
        if (path == null) {
            return;
        }
        this.myAutoScrollToSourceHandler.setShouldAutoScroll(false);
        TreeUtil.showRowCentered((JTree)this.getTree(), (int)this.getTree().getRowForPath(path), (boolean)false);
        this.myAutoScrollToSourceHandler.setShouldAutoScroll(true);
    }

    @Override
    public void setActionActive(String name, boolean state) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.storeState();
        StructureViewFactoryEx.getInstanceEx(this.myProject).setActiveAction(name, state);
        ourSettingsModificationCount.incrementAndGet();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.waitForRebuildAndExpand();
        } else {
            this.rebuild();
            TreeUtil.expand((JTree)this.getTree(), (int)StructureViewComponent.getMinimumExpandDepth(this.myTreeModel));
        }
    }

    private void waitForRebuildAndExpand() {
        StructureViewComponent.wait(this.rebuildAndUpdate());
        UIUtil.dispatchAllInvocationEvents();
        StructureViewComponent.wait(TreeUtil.promiseExpand((JTree)this.getTree(), (int)StructureViewComponent.getMinimumExpandDepth(this.myTreeModel)));
    }

    private static void wait(Promise<?> originPromise) {
        AtomicBoolean complete = new AtomicBoolean(false);
        Promise promise = originPromise.onProcessed(ignore -> complete.set(true));
        while (!complete.get()) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                promise.blockingGet(10, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isActionActive(String name) {
        return !this.myProject.isDisposed() && StructureViewFactoryEx.getInstanceEx(this.myProject).isActionActive(name);
    }

    public static void clearStructureViewState(Project project) {
        for (FileEditor editor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
            editor.putUserData(STRUCTURE_VIEW_STATE_KEY, null);
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            StructureViewComponent.$$$reportNull$$$0(15);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement element2 = (PsiElement)this.getSelectedValues().filter(PsiElement.class).single();
            return element2 != null && element2.isValid() ? element2 : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return PsiUtilCore.toPsiElementArray((Collection)this.getSelectedValues().filter(PsiElement.class).toList());
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditor;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Object[] selectedElements;
            List list2 = JBIterable.of((Object[])this.getTree().getSelectionPaths()).map(TreePath::getLastPathComponent).map(StructureViewComponent::unwrapNavigatable).toList();
            Object[] objectArray = selectedElements = list2.isEmpty() ? null : ArrayUtil.toObjectArray((Collection)list2);
            if (selectedElements == null || selectedElements.length == 0) {
                return null;
            }
            if (selectedElements[0] instanceof Navigatable) {
                return selectedElements[0];
            }
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.getHelpID();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return super.getData(dataId);
    }

    @NotNull
    public StructureViewModel getTreeModel() {
        StructureViewModel structureViewModel = this.myTreeModel;
        if (structureViewModel == null) {
            StructureViewComponent.$$$reportNull$$$0(16);
        }
        return structureViewModel;
    }

    public boolean navigateToSelectedElement(boolean requestFocus) {
        this.select(this.myTreeModel.getCurrentEditorElement(), requestFocus);
        return true;
    }

    public AsyncPromise<Void> rebuildAndUpdate() {
        AsyncPromise result2 = new AsyncPromise();
        this.rebuild();
        TreeVisitor visitor = path -> {
            AbstractTreeNode node = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)path);
            if (node != null) {
                node.update();
            }
            return TreeVisitor.Action.CONTINUE;
        };
        this.myAsyncTreeModel.accept(visitor).onProcessed(ignore -> result2.setResult(null));
        return result2;
    }

    public String getHelpID() {
        return "viewingStructure.fileStructureView";
    }

    public Dimension getCurrentSize() {
        return this.getTree().getSize();
    }

    public void setReferenceSizeWhileInitializing(Dimension size) {
    }

    private static int getMinimumExpandDepth(@NotNull StructureViewModel structureViewModel) {
        StructureViewModel.ExpandInfoProvider provider;
        if (structureViewModel == null) {
            StructureViewComponent.$$$reportNull$$$0(17);
        }
        return (provider = (StructureViewModel.ExpandInfoProvider)ObjectUtils.tryCast((Object)structureViewModel, StructureViewModel.ExpandInfoProvider.class)) == null ? 2 : provider.getMinimumAutoExpandDepth();
    }

    public static Object unwrapValue(Object o) {
        return StructureViewComponent.unwrapElement(StructureViewComponent.unwrapWrapper(o));
    }

    @Nullable
    public static Object unwrapNavigatable(Object o) {
        Object p = TreeUtil.getUserObject((Object)o);
        return p instanceof FilteringTreeStructure.FilteringNode ? ((FilteringTreeStructure.FilteringNode)p).getDelegate() : p;
    }

    public static Object unwrapWrapper(Object o) {
        Object p = StructureViewComponent.unwrapNavigatable(o);
        return p instanceof MyNodeWrapper ? ((MyNodeWrapper)((Object)p)).getValue() : (p instanceof MyGroupWrapper ? ((MyGroupWrapper)((Object)p)).getValue() : p);
    }

    private static Object unwrapElement(Object o) {
        return o instanceof StructureViewTreeElement ? ((StructureViewTreeElement)o).getValue() : o;
    }

    @NotNull
    public static TreeElementWrapper createWrapper(@NotNull Project project, @NotNull TreeElement value2, TreeModel treeModel) {
        if (project == null) {
            StructureViewComponent.$$$reportNull$$$0(18);
        }
        if (value2 == null) {
            StructureViewComponent.$$$reportNull$$$0(19);
        }
        return new MyNodeWrapper(project, value2, treeModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureViewModel";
                break;
            }
            case 1: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChange";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroup";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "expandSelectFocusInner";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerAutoExpandListener";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerPsiListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addGroupByActions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMinimumExpandDepth";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createWrapper";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyExpandListener
    extends TreeModelAdapter {
        private static final RegistryValue autoExpandDepth = Registry.get((String)"ide.tree.autoExpandMaxDepth");
        private final JTree tree;
        final StructureViewModel.ExpandInfoProvider provider;
        final boolean smartExpand;

        MyExpandListener(@NotNull JTree tree, @Nullable StructureViewModel.ExpandInfoProvider provider) {
            if (tree == null) {
                MyExpandListener.$$$reportNull$$$0(0);
            }
            this.tree = tree;
            this.provider = provider;
            this.smartExpand = provider != null && provider.isSmartExpand();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            TreePath parentPath = e.getTreePath();
            if (Boolean.TRUE.equals(ComponentUtil.getClientProperty((JComponent)this.tree, (Key)STRUCTURE_VIEW_STATE_RESTORED_KEY))) {
                return;
            }
            if (parentPath == null || parentPath.getPathCount() > autoExpandDepth.asInteger() - 1) {
                return;
            }
            Object[] children2 = e.getChildren();
            if (this.smartExpand && children2.length == 1) {
                this.expandLater(parentPath, children2[0]);
            } else {
                for (Object o : children2) {
                    NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getUserObject(NodeDescriptor.class, (Object)o);
                    if (descriptor2 == null || !this.isAutoExpandNode(descriptor2)) continue;
                    this.expandLater(parentPath, o);
                }
            }
        }

        void expandLater(@NotNull TreePath parentPath, @NotNull Object o) {
            if (parentPath == null) {
                MyExpandListener.$$$reportNull$$$0(1);
            }
            if (o == null) {
                MyExpandListener.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.tree.isVisible(parentPath) || !this.tree.isExpanded(parentPath)) {
                    return;
                }
                this.tree.expandPath(parentPath.pathByAddingChild(o));
            });
        }

        boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
            NodeDescriptor parent;
            if (this.provider != null) {
                Object value2 = StructureViewComponent.unwrapWrapper(nodeDescriptor.getElement());
                if (value2 instanceof CustomRegionTreeElement) {
                    return true;
                }
                if (value2 instanceof StructureViewTreeElement) {
                    return this.provider.isAutoExpand((StructureViewTreeElement)value2);
                }
                if (value2 instanceof GroupWrapper) {
                    Group group = Objects.requireNonNull((Group)((GroupWrapper)((Object)value2)).getValue());
                    for (TreeElement treeElement : group.getChildren()) {
                        if (!(treeElement instanceof StructureViewTreeElement) || this.provider.isAutoExpand((StructureViewTreeElement)treeElement)) continue;
                        return false;
                    }
                }
            }
            return (parent = nodeDescriptor.getParentDescriptor()) == null || parent.getParentDescriptor() == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyExpandListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expandLater";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        final PsiModificationTracker modTracker;
        long prevModCount;
        final Runnable onChange;

        private MyPsiTreeChangeListener(PsiModificationTracker modTracker, Runnable onChange) {
            this.modTracker = modTracker;
            this.onChange = onChange;
            this.prevModCount = modTracker.getModificationCount();
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            PsiElement child2;
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(0);
            }
            if ((child2 = event.getOldChild()) instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiElement child2;
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(1);
            }
            if ((child2 = event.getNewChild()) instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(2);
            }
            PsiElement oldChild = event.getOldChild();
            PsiElement newChild = event.getNewChild();
            if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(3);
            }
            this.childrenChanged();
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(4);
            }
            this.childrenChanged();
        }

        private void childrenChanged() {
            long newModificationCount = this.modTracker.getModificationCount();
            if (newModificationCount == this.prevModCount) {
                return;
            }
            this.prevModCount = newModificationCount;
            this.onChange.run();
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(5);
            }
            this.childrenChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyPsiTreeChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTree
    extends DnDAwareTree
    implements PlaceProvider<String> {
        MyTree(javax.swing.tree.TreeModel model) {
            super(model);
            HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
        }

        public String getPlace() {
            return "StructureViewToolbar";
        }

        @Override
        public void processMouseEvent(MouseEvent event) {
            IdeMouseEventDispatcher.requestFocusInNonFocusedWindow(event);
            super.processMouseEvent(event);
        }
    }

    private static class MyGroupWrapper
    extends GroupWrapper {
        MyGroupWrapper(Project project, @NotNull Group group, @NotNull TreeModel treeModel) {
            if (group == null) {
                MyGroupWrapper.$$$reportNull$$$0(0);
            }
            if (treeModel == null) {
                MyGroupWrapper.$$$reportNull$$$0(1);
            }
            super(project, group, treeModel);
        }

        @Override
        @NotNull
        protected TreeElementWrapper createChildNode(@NotNull TreeElement child2) {
            if (child2 == null) {
                MyGroupWrapper.$$$reportNull$$$0(2);
            }
            return new MyNodeWrapper(this.getProject(), child2, this.myTreeModel);
        }

        @Override
        @NotNull
        protected GroupWrapper createGroupWrapper(Project project, @NotNull Group group, @NotNull TreeModel treeModel) {
            if (group == null) {
                MyGroupWrapper.$$$reportNull$$$0(3);
            }
            if (treeModel == null) {
                MyGroupWrapper.$$$reportNull$$$0(4);
            }
            return new MyGroupWrapper(project, group, treeModel);
        }

        public boolean isAlwaysShowPlus() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyGroupWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createChildNode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createGroupWrapper";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyNodeWrapper
    extends TreeElementWrapper
    implements NodeDescriptorProvidingKey,
    ValidateableNode {
        private long childrenStamp;
        private int modificationCountForChildren;

        MyNodeWrapper(Project project, @NotNull TreeElement value2, @NotNull TreeModel treeModel) {
            if (value2 == null) {
                MyNodeWrapper.$$$reportNull$$$0(0);
            }
            if (treeModel == null) {
                MyNodeWrapper.$$$reportNull$$$0(1);
            }
            super(project, value2, treeModel);
            this.childrenStamp = -1L;
            this.modificationCountForChildren = ourSettingsModificationCount.get();
        }

        @NotNull
        public Object getKey() {
            StructureViewTreeElement element2 = (StructureViewTreeElement)this.getValue();
            if (element2 instanceof NodeDescriptorProvidingKey) {
                Object object = ((NodeDescriptorProvidingKey)element2).getKey();
                if (object == null) {
                    MyNodeWrapper.$$$reportNull$$$0(2);
                }
                return object;
            }
            Object value2 = element2 == null ? null : element2.getValue();
            Object object = value2 == null ? this : value2;
            if (object == null) {
                MyNodeWrapper.$$$reportNull$$$0(3);
            }
            return object;
        }

        @Override
        @NotNull
        public Collection<AbstractTreeNode<?>> getChildren() {
            if (ourSettingsModificationCount.get() != this.modificationCountForChildren) {
                this.resetChildren();
                this.modificationCountForChildren = ourSettingsModificationCount.get();
            }
            Object o = StructureViewComponent.unwrapElement(this.getValue());
            long currentStamp = -1L;
            if (o instanceof PsiElement) {
                if (!((PsiElement)o).isValid()) {
                    List<AbstractTreeNode<?>> list2 = Collections.emptyList();
                    if (list2 == null) {
                        MyNodeWrapper.$$$reportNull$$$0(4);
                    }
                    return list2;
                }
                PsiFile file2 = ((PsiElement)o).getContainingFile();
                if (file2 != null) {
                    currentStamp = file2.getModificationStamp();
                }
            } else if (o instanceof ModificationTracker) {
                currentStamp = ((ModificationTracker)o).getModificationCount();
            }
            if (this.childrenStamp != currentStamp) {
                this.resetChildren();
                this.childrenStamp = currentStamp;
            }
            Collection<AbstractTreeNode<?>> collection = super.getChildren();
            if (collection == null) {
                MyNodeWrapper.$$$reportNull$$$0(5);
            }
            return collection;
        }

        public boolean isAlwaysShowPlus() {
            StructureViewModel.ElementInfoProvider elementInfoProvider = this.getElementInfoProvider();
            return elementInfoProvider == null || elementInfoProvider.isAlwaysShowsPlus((StructureViewTreeElement)this.getValue());
        }

        public boolean isAlwaysLeaf() {
            StructureViewModel.ElementInfoProvider elementInfoProvider = this.getElementInfoProvider();
            return elementInfoProvider != null && elementInfoProvider.isAlwaysLeaf((StructureViewTreeElement)this.getValue());
        }

        @Nullable
        private StructureViewModel.ElementInfoProvider getElementInfoProvider() {
            StructureViewModel model;
            if (this.myTreeModel instanceof StructureViewModel.ElementInfoProvider) {
                return (StructureViewModel.ElementInfoProvider)this.myTreeModel;
            }
            if (this.myTreeModel instanceof TreeModelWrapper && (model = ((TreeModelWrapper)this.myTreeModel).getModel()) instanceof StructureViewModel.ElementInfoProvider) {
                return (StructureViewModel.ElementInfoProvider)model;
            }
            return null;
        }

        @Override
        @NotNull
        protected TreeElementWrapper createChildNode(@NotNull TreeElement child2) {
            if (child2 == null) {
                MyNodeWrapper.$$$reportNull$$$0(6);
            }
            return new MyNodeWrapper(this.myProject, child2, this.myTreeModel);
        }

        @Override
        @NotNull
        protected GroupWrapper createGroupWrapper(Project project, @NotNull Group group, @NotNull TreeModel treeModel) {
            if (group == null) {
                MyNodeWrapper.$$$reportNull$$$0(7);
            }
            if (treeModel == null) {
                MyNodeWrapper.$$$reportNull$$$0(8);
            }
            return new MyGroupWrapper(project, group, treeModel);
        }

        public boolean equals(Object o) {
            if (o instanceof MyNodeWrapper) {
                return Comparing.equal((Object)StructureViewComponent.unwrapElement(this.getValue()), (Object)StructureViewComponent.unwrapElement(((MyNodeWrapper)((Object)o)).getValue()));
            }
            if (o instanceof StructureViewTreeElement) {
                return Comparing.equal((Object)StructureViewComponent.unwrapElement(this.getValue()), (Object)((StructureViewTreeElement)o).getValue());
            }
            return false;
        }

        public boolean isValid() {
            TreeElement value2 = (TreeElement)this.getValue();
            PsiTreeElementBase psi = value2 instanceof PsiTreeElementBase ? (PsiTreeElementBase)value2 : null;
            return psi == null || psi.isValid();
        }

        public int hashCode() {
            Object o = StructureViewComponent.unwrapElement(this.getValue());
            return o != null ? o.hashCode() : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeModel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyNodeWrapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyNodeWrapper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildNode";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createGroupWrapper";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler
    implements Disposable {
        private FileEditorPositionListener myFileEditorPositionListener;

        private MyAutoScrollFromSourceHandler(@NotNull Project project, Disposable parentDisposable) {
            if (parentDisposable == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            super(project, (JComponent)StructureViewComponent.this.getTree(), parentDisposable);
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(1);
            }
        }

        public void install() {
            this.addEditorCaretListener();
        }

        public void dispose() {
            if (this.myFileEditorPositionListener != null) {
                StructureViewComponent.this.myTreeModel.removeEditorPositionListener(this.myFileEditorPositionListener);
            }
        }

        private void addEditorCaretListener() {
            this.myFileEditorPositionListener = () -> StructureViewComponent.this.scrollToSelectedElement();
            StructureViewComponent.this.myTreeModel.addEditorPositionListener(this.myFileEditorPositionListener);
            if (this.isAutoScrollEnabled()) {
                StructureViewComponent.this.scrollToSelectedElement();
            }
        }

        protected boolean isAutoScrollEnabled() {
            return ((StructureViewComponent)StructureViewComponent.this).getSettings().AUTOSCROLL_FROM_SOURCE;
        }

        protected void setAutoScrollEnabled(boolean state) {
            ((StructureViewComponent)StructureViewComponent.this).getSettings().AUTOSCROLL_FROM_SOURCE = state;
            FileEditor[] selectedEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors();
            if (selectedEditors.length > 0 && state) {
                StructureViewComponent.this.scrollToSelectedElementLater();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/structureView/newStructureView/StructureViewComponent$MyAutoScrollFromSourceHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectElementFromEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        private boolean myShouldAutoScroll = true;

        private MyAutoScrollToSourceHandler() {
        }

        void setShouldAutoScroll(boolean shouldAutoScroll) {
            this.myShouldAutoScroll = shouldAutoScroll;
        }

        protected boolean isAutoScrollMode() {
            return this.myShouldAutoScroll && !StructureViewComponent.this.myProject.isDisposed() && ((StructureViewComponent)StructureViewComponent.this).getSettings().AUTOSCROLL_MODE;
        }

        protected void setAutoScrollMode(boolean state) {
            ((StructureViewComponent)StructureViewComponent.this).getSettings().AUTOSCROLL_MODE = state;
        }

        protected void scrollToSource(Component tree) {
            if (StructureViewComponent.this.isDisposed()) {
                return;
            }
            StructureViewComponent.this.myAutoscrollFeedback = true;
            Navigatable navigatable = (Navigatable)CommonDataKeys.NAVIGATABLE.getData(DataManager.getInstance().getDataContext((Component)StructureViewComponent.this.getTree()));
            if (StructureViewComponent.this.myFileEditor != null && navigatable != null && navigatable.canNavigateToSource()) {
                navigatable.navigate(false);
            }
        }
    }
}

