/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.openapi.diagnostic.Logger;

public final class PropertiesGetter {
    private static final Logger logger = Logger.getInstance(PropertiesGetter.class);
    private static final String[] PAGE_SIZE_PROPERTY_NAMES = new String[]{"lfe.pageSize", "lfe.ps"};
    private static final String[] MAX_PAGE_BORDER_SHIFT_PROPERTY_NAMES = new String[]{"lfe.maxPageBorderShift", "lfe.mpbs"};
    private static final int DEFAULT_PAGE_SIZE_BYTES = 100000;
    private static final int DEFAULT_MAX_PAGE_BORDER_SHIFT_BYTES = 1000;

    public static int getPageSize() {
        return PropertiesGetter.getPropertyInt(PAGE_SIZE_PROPERTY_NAMES, 100000);
    }

    public static int getMaxPageBorderShiftBytes() {
        return PropertiesGetter.getPropertyInt(MAX_PAGE_BORDER_SHIFT_PROPERTY_NAMES, 1000);
    }

    private static int getPropertyInt(String[] propertyNames, int defaultValue) {
        for (String propertyName : propertyNames) {
            String strValue = System.getProperty(propertyName);
            if (strValue == null) continue;
            try {
                return Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                logger.warn("NumberFormatException: can't parse to int [propertyName=" + propertyName + " stringValue=" + strValue + " defaultValue=" + defaultValue + ")");
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

