/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.idea.ApplicationLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectLoadHelper;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.ExceptionUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectImpl
extends ComponentManagerImpl
implements ProjectEx {
    protected static final Logger LOG = Logger.getInstance(ProjectImpl.class);
    public static final Key<Long> CREATION_TIME = Key.create((String)"ProjectImpl.CREATION_TIME");
    public static final String LIGHT_PROJECT_NAME = "light_temp";
    protected String myName;
    static boolean ourClassesAreLoaded;
    private final String creationTrace;

    protected ProjectImpl(@NotNull ComponentManagerImpl parent) {
        if (parent == null) {
            ProjectImpl.$$$reportNull$$$0(0);
        }
        super(parent);
        this.creationTrace = ApplicationManager.getApplication().isUnitTestMode() ? ExceptionUtil.currentStackTrace() : null;
    }

    @Override
    public void setProjectName(@NotNull String projectName) {
        if (projectName == null) {
            ProjectImpl.$$$reportNull$$$0(1);
        }
        if (projectName.equals(this.myName)) {
            return;
        }
        this.myName = projectName;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance((Project)this).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
                JFrame frame = WindowManager.getInstance().getFrame((Project)this);
                String title = FrameTitleBuilder.getInstance().getProjectTitle(this);
                if (frame != null && title != null) {
                    frame.setTitle(title);
                }
            }, ModalityState.NON_MODAL, this.getDisposed()));
        }
    }

    public boolean isOpen() {
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceExIfCreated();
        return projectManager != null && projectManager.isProjectOpened(this);
    }

    public boolean isInitialized() {
        return this.getComponentCreated() && !this.isDisposed() && this.isOpen() && StartupManagerEx.getInstanceEx(this).startupActivityPassed();
    }

    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        if (pluginDescriptor == null) {
            ProjectImpl.$$$reportNull$$$0(2);
        }
        ContainerDescriptor containerDescriptor = pluginDescriptor.getProject();
        if (containerDescriptor == null) {
            ProjectImpl.$$$reportNull$$$0(3);
        }
        return containerDescriptor;
    }

    @NotNull
    public String getName() {
        if (this.myName == null) {
            String string = this.getStateStore().getProjectName();
            if (string == null) {
                ProjectImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            ProjectImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected abstract IProjectStore getStateStore();

    public void init(@Nullable ProgressIndicator indicator) {
        Application application = ApplicationManager.getApplication();
        List<? extends IdeaPluginDescriptor> plugins = PluginManagerCore.getLoadedPlugins();
        CompletableFuture<Void> servicePreloadingFuture = ApplicationLoader.preloadServices(plugins, this, "project ", this.isLight());
        this.createComponents(indicator);
        servicePreloadingFuture.join();
        if (indicator != null && !application.isHeadlessEnvironment()) {
            this.distributeProgress(indicator);
        }
        if (this.myName == null) {
            this.myName = this.getStateStore().getProjectName();
        }
        ProjectLoadHelper.notifyThatComponentCreated(this);
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProjectImpl.$$$reportNull$$$0(6);
        }
        indicator.setFraction(this.getPercentageOfComponentsLoaded() / (double)(ourClassesAreLoaded ? 10 : 2));
    }

    private void distributeProgress(@NotNull ProgressIndicator indicator) {
        ModuleManager moduleManager;
        if (indicator == null) {
            ProjectImpl.$$$reportNull$$$0(7);
        }
        if (!((moduleManager = ModuleManager.getInstance((Project)this)) instanceof ModuleManagerImpl)) {
            return;
        }
        double toDistribute = 1.0 - indicator.getFraction();
        int modulesCount = ((ModuleManagerImpl)moduleManager).getModulePathsCount();
        if (modulesCount != 0) {
            ((ModuleManagerImpl)moduleManager).setProgressStep(toDistribute / (double)modulesCount);
        }
    }

    public void save() {
        if (!ApplicationManagerEx.getApplicationEx().isSaveAllowed()) {
            return;
        }
        if (!this.isInitialized()) {
            LOG.debug("Skip save for " + this.getName() + ": not initialized");
            return;
        }
        StoreUtil.saveSettings((ComponentManager)this, false);
    }

    @Override
    public String getCreationTrace() {
        return this.creationTrace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/impl/ProjectImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/impl/ProjectImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProjectName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContainerDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setProgressDuringInit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "distributeProgress";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

