/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.diff.DiffApplicationSettings;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.FragmentedEditorHighlighter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusMarkerPopupRenderer
extends LineStatusMarkerRenderer {
    public LineStatusMarkerPopupRenderer(@NotNull LineStatusTrackerBase<?> tracker) {
        if (tracker == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(0);
        }
        super(tracker);
    }

    @Override
    protected boolean canDoAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(1);
        }
        if (ranges == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(2);
        }
        if (e == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(3);
        }
        return LineStatusMarkerPopupRenderer.isInsideMarkerArea(e);
    }

    @Override
    protected void doAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(4);
        }
        if (ranges == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(5);
        }
        if (e == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(6);
        }
        Range range2 = ranges.get(0);
        if (ranges.size() > 1) {
            this.scrollAndShow(editor, range2);
        } else {
            this.showHint(editor, range2, e);
        }
    }

    @NotNull
    protected abstract List<AnAction> createToolbarActions(@NotNull Editor var1, @NotNull Range var2, @Nullable Point var3);

    @NotNull
    protected FileType getFileType() {
        PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(7);
        }
        return plainTextFileType;
    }

    private static boolean isShowInnerDifferences() {
        return DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
    }

    @Nullable
    protected JComponent createAdditionalInfoPanel(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition, @NotNull Disposable disposable2) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(8);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(9);
        }
        if (disposable2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(10);
        }
        return null;
    }

    public void scrollAndShow(@NotNull Editor editor, @NotNull Range range2) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(11);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(12);
        }
        if (!this.myTracker.isValid()) {
            return;
        }
        Document document = this.myTracker.getDocument();
        int line = Math.min(range2.getType() == 3 ? range2.getLine2() : range2.getLine2() - 1, DiffUtil.getLineCount(document) - 1);
        int lastOffset = document.getLineStartOffset(line);
        editor.getCaretModel().moveToOffset(lastOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.showAfterScroll(editor, range2);
    }

    public void showAfterScroll(@NotNull Editor editor, @NotNull Range range2) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(13);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(14);
        }
        editor.getScrollingModel().runActionOnScrollingFinished(() -> {
            Object newRange = this.myTracker.findRange(range2);
            if (newRange != null) {
                this.showHintAt(editor, (Range)newRange, null);
            }
        });
    }

    public void showHint(@NotNull Editor editor, @NotNull Range range2, @NotNull MouseEvent e) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(15);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(16);
        }
        if (e == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(17);
        }
        JComponent comp = (JComponent)e.getComponent();
        JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
        Point point = SwingUtilities.convertPoint(comp, ((EditorEx)editor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
        this.showHintAt(editor, range2, point);
        e.consume();
    }

    public void showHintAt(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(18);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(19);
        }
        if (!this.myTracker.isValid()) {
            return;
        }
        Disposable disposable2 = Disposer.newDisposable();
        List<DiffFragment> wordDiff = this.computeWordDiff(range2);
        this.installMasterEditorHighlighters(editor, range2, wordDiff, disposable2);
        JComponent editorComponent = this.createEditorComponent(editor, range2, wordDiff);
        ActionToolbar toolbar = this.buildToolbar(editor, range2, mousePosition, disposable2);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        JComponent additionalInfoPanel = this.createAdditionalInfoPanel(editor, range2, mousePosition, disposable2);
        PopupPanel popupPanel = new PopupPanel(editor, toolbar, editorComponent, additionalInfoPanel);
        LightweightHint hint = new LightweightHint(popupPanel);
        HintListener closeListener2 = __ -> Disposer.dispose((Disposable)disposable2);
        hint.addHintListener(closeListener2);
        int line = editor.getCaretModel().getLogicalPosition().line;
        Point point = HintManagerImpl.getHintPosition(hint, editor, new LogicalPosition(line, 0), (short)2);
        if (mousePosition != null) {
            int lineHeight = editor.getLineHeight();
            int delta = (point.y - mousePosition.y) % lineHeight;
            if (delta < 0) {
                delta += lineHeight;
            }
            point.y = mousePosition.y + delta;
        }
        point.x -= popupPanel.getEditorTextOffset();
        int flags = 1064;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, flags, -1, false, new HintHint(editor, point));
        ApplicationManager.getApplication().getMessageBus().connect(disposable2).subscribe(EditorHintListener.TOPIC, (project, newHint, newHintFlags) -> {
            PopupPanel newPopupPanel;
            if (newHint.getComponent() instanceof PopupPanel && (newPopupPanel = (PopupPanel)newHint.getComponent()).getEditor().equals(editor)) {
                hint.hide();
            }
        });
        if (!hint.isVisible()) {
            closeListener2.hintHidden(new EventObject(hint));
        }
    }

    @Nullable
    private List<DiffFragment> computeWordDiff(@NotNull Range range2) {
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(20);
        }
        if (!LineStatusMarkerPopupRenderer.isShowInnerDifferences()) {
            return null;
        }
        if (range2.getType() != 1) {
            return null;
        }
        CharSequence vcsContent = this.getVcsContent(range2);
        CharSequence currentContent = this.getCurrentContent(range2);
        return (List)BackgroundTaskUtil.tryComputeFast(indicator -> ByWord.compare(vcsContent, currentContent, ComparisonPolicy.DEFAULT, indicator), 200L);
    }

    private void installMasterEditorHighlighters(@NotNull Editor editor, @NotNull Range range2, @Nullable List<? extends DiffFragment> wordDiff, @NotNull Disposable parentDisposable) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(21);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(22);
        }
        if (parentDisposable == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(23);
        }
        if (wordDiff == null) {
            return;
        }
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        int currentStartShift = this.getCurrentTextRange(range2).getStartOffset();
        for (DiffFragment diffFragment : wordDiff) {
            int currentStart = currentStartShift + diffFragment.getStartOffset2();
            int currentEnd = currentStartShift + diffFragment.getEndOffset2();
            TextDiffType type = DiffUtil.getDiffType(diffFragment);
            highlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, currentStart, currentEnd, type));
        }
        Disposer.register((Disposable)parentDisposable, () -> highlighters.forEach(RangeMarker::dispose));
    }

    @Nullable
    private JComponent createEditorComponent(@NotNull Editor editor, @NotNull Range range2, @Nullable List<? extends DiffFragment> wordDiff) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(24);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(25);
        }
        if (range2.getType() == 2) {
            return null;
        }
        TextRange vcsTextRange = this.getVcsTextRange(range2);
        String content2 = this.getVcsContent(range2).toString();
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        EditorHighlighter highlighter = highlighterFactory.createEditorHighlighter(this.myTracker.getProject(), LineStatusMarkerPopupRenderer.getFileName(this.myTracker.getDocument()));
        highlighter.setText(this.myTracker.getVcsDocument().getImmutableCharSequence());
        FragmentedEditorHighlighter fragmentedHighlighter = new FragmentedEditorHighlighter(highlighter, vcsTextRange);
        Color backgroundColor = EditorFragmentComponent.getBackgroundColor(editor, true);
        EditorTextField field = new EditorTextField(content2);
        field.setBorder(null);
        field.setOneLineMode(false);
        field.ensureWillComputePreferredSize();
        field.setFontInheritedFromLAF(false);
        field.addSettingsProvider(uEditor -> {
            uEditor.setVerticalScrollbarVisible(true);
            uEditor.setHorizontalScrollbarVisible(true);
            uEditor.setRendererMode(true);
            uEditor.setBorder(null);
            uEditor.setColorsScheme(editor.getColorsScheme());
            uEditor.setBackgroundColor(backgroundColor);
            uEditor.getSettings().setCaretRowShown(false);
            uEditor.getSettings().setTabSize(editor.getSettings().getTabSize(editor.getProject()));
            uEditor.getSettings().setUseTabCharacter(editor.getSettings().isUseTabCharacter(editor.getProject()));
            uEditor.setHighlighter((EditorHighlighter)fragmentedHighlighter);
            if (wordDiff != null) {
                for (DiffFragment fragment : wordDiff) {
                    int vcsStart = fragment.getStartOffset1();
                    int vcsEnd = fragment.getEndOffset1();
                    TextDiffType type = DiffUtil.getDiffType(fragment);
                    DiffDrawUtil.createInlineHighlighter(uEditor, vcsStart, vcsEnd, type);
                }
            }
        });
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)((Object)field));
        panel2.setBorder(EditorFragmentComponent.createEditorFragmentBorder(editor));
        panel2.setBackground(backgroundColor);
        DataManager.registerDataProvider((JComponent)panel2, data2 -> {
            if (CommonDataKeys.HOST_EDITOR.is(data2)) {
                return field.getEditor();
            }
            return null;
        });
        return panel2;
    }

    private static String getFileName(@NotNull Document document) {
        VirtualFile file2;
        if (document == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(26);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document)) == null) {
            return "";
        }
        return file2.getName();
    }

    @NotNull
    private ActionToolbar buildToolbar(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition, @NotNull Disposable parentDisposable) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(27);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(28);
        }
        if (parentDisposable == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(29);
        }
        List<AnAction> actions = this.createToolbarActions(editor, range2, mousePosition);
        JComponent editorComponent = editor.getComponent();
        for (AnAction action2 : actions) {
            DiffUtil.registerAction(action2, editorComponent);
        }
        Disposer.register((Disposable)parentDisposable, () -> ActionUtil.getActions((JComponent)editorComponent).removeAll(actions));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup(actions), true);
        if (actionToolbar == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(30);
        }
        return actionToolbar;
    }

    @NotNull
    private CharSequence getCurrentContent(Range range2) {
        CharSequence charSequence = DiffUtil.getLinesContent(this.myTracker.getDocument(), range2.getLine1(), range2.getLine2());
        if (charSequence == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(31);
        }
        return charSequence;
    }

    @NotNull
    private CharSequence getVcsContent(Range range2) {
        CharSequence charSequence = DiffUtil.getLinesContent(this.myTracker.getVcsDocument(), range2.getVcsLine1(), range2.getVcsLine2());
        if (charSequence == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(32);
        }
        return charSequence;
    }

    @NotNull
    private TextRange getCurrentTextRange(@NotNull Range range2) {
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(33);
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myTracker.getDocument(), range2.getLine1(), range2.getLine2());
        if (textRange == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(34);
        }
        return textRange;
    }

    @NotNull
    private TextRange getVcsTextRange(@NotNull Range range2) {
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(35);
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myTracker.getVcsDocument(), range2.getVcsLine1(), range2.getVcsLine2());
        if (textRange == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(36);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 3: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "buildToolbar";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentContent";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsContent";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTextRange";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 7: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalInfoPanel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scrollAndShow";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showAfterScroll";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showHintAt";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computeWordDiff";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "installMasterEditorHighlighters";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildToolbar";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentTextRange";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getVcsTextRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class ToggleByWordDiffAction
    extends ToggleAction
    implements DumbAware,
    LightEditCompatible {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final Range myRange;
        @Nullable
        private final Point myMousePosition;

        public ToggleByWordDiffAction(@NotNull Editor editor, @Nullable Range range2, Point position) {
            if (editor == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(1);
            }
            super(DiffBundle.message((String)"highlight.words", (Object[])new Object[0]), null, AllIcons.Actions.Highlighting);
            this.myEditor = editor;
            this.myRange = range2;
            this.myMousePosition = position;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(2);
            }
            return DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(3);
            }
            if (!LineStatusMarkerPopupRenderer.this.myTracker.isValid()) {
                return;
            }
            DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES = state;
            Object newRange = LineStatusMarkerPopupRenderer.this.myTracker.findRange(this.myRange);
            if (newRange != null) {
                LineStatusMarkerPopupRenderer.this.showHintAt(this.myEditor, (Range)newRange, this.myMousePosition);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ToggleByWordDiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ShowLineStatusRangeDiffAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public ShowLineStatusRangeDiffAction(@NotNull Editor editor, Range range2) {
            if (editor == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(1);
            }
            super(editor, range2, "Diff.ShowDiff");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(5);
            }
            Range ourRange = this.expand(range2, LineStatusMarkerPopupRenderer.this.myTracker.getDocument(), LineStatusMarkerPopupRenderer.this.myTracker.getVcsDocument());
            DiffContent vcsContent = this.createDiffContent(LineStatusMarkerPopupRenderer.this.myTracker.getVcsDocument(), LineStatusMarkerPopupRenderer.this.myTracker.getVirtualFile(), LineStatusMarkerPopupRenderer.this.getVcsTextRange(ourRange));
            DiffContent currentContent = this.createDiffContent(LineStatusMarkerPopupRenderer.this.myTracker.getDocument(), LineStatusMarkerPopupRenderer.this.myTracker.getVirtualFile(), LineStatusMarkerPopupRenderer.this.getCurrentTextRange(ourRange));
            SimpleDiffRequest request2 = new SimpleDiffRequest(DiffBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]), vcsContent, currentContent, DiffBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), DiffBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0]));
            DiffManager.getInstance().showDiff(LineStatusMarkerPopupRenderer.this.myTracker.getProject(), (DiffRequest)request2);
        }

        @NotNull
        private DiffContent createDiffContent(@NotNull Document document, @Nullable VirtualFile highlightFile, @NotNull TextRange textRange) {
            if (document == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(6);
            }
            if (textRange == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(7);
            }
            Project project = LineStatusMarkerPopupRenderer.this.myTracker.getProject();
            DocumentContent content2 = DiffContentFactory.getInstance().create(project, document, highlightFile);
            DocumentContent documentContent = DiffContentFactory.getInstance().createFragment(project, content2, textRange);
            if (documentContent == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(8);
            }
            return documentContent;
        }

        @NotNull
        private Range expand(@NotNull Range range2, @NotNull Document document, @NotNull Document uDocument) {
            if (range2 == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(9);
            }
            if (document == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(10);
            }
            if (uDocument == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(11);
            }
            boolean canExpandBefore = range2.getLine1() != 0 && range2.getVcsLine1() != 0;
            boolean canExpandAfter = range2.getLine2() < DiffUtil.getLineCount(document) && range2.getVcsLine2() < DiffUtil.getLineCount(uDocument);
            int offset1 = range2.getLine1() - (canExpandBefore ? 1 : 0);
            int uOffset1 = range2.getVcsLine1() - (canExpandBefore ? 1 : 0);
            int offset2 = range2.getLine2() + (canExpandAfter ? 1 : 0);
            int uOffset2 = range2.getVcsLine2() + (canExpandAfter ? 1 : 0);
            return new Range(offset1, offset2, uOffset1, uOffset2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ShowLineStatusRangeDiffAction";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ShowLineStatusRangeDiffAction";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDiffContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffContent";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "expand";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class CopyLineStatusRangeAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public CopyLineStatusRangeAction(@NotNull Editor editor, Range range2) {
            if (editor == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(1);
            }
            super(editor, range2, "$Copy");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(3);
            }
            return 3 == range2.getType() || 1 == range2.getType();
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(5);
            }
            String content2 = LineStatusMarkerPopupRenderer.this.getVcsContent(range2) + "\n";
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(content2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$CopyLineStatusRangeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ShowPrevChangeMarkerAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public ShowPrevChangeMarkerAction(@NotNull Editor editor, Range range2) {
            if (editor == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(1);
            }
            super(editor, range2, "VcsShowPrevChangeMarker");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(3);
            }
            return LineStatusMarkerPopupRenderer.this.myTracker.getPrevRange(range2.getLine1()) != null;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            Object targetRange;
            if (editor == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(5);
            }
            if ((targetRange = LineStatusMarkerPopupRenderer.this.myTracker.getPrevRange(range2.getLine1())) != null) {
                LineStatusMarkerPopupRenderer.this.scrollAndShow(editor, (Range)targetRange);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ShowPrevChangeMarkerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ShowNextChangeMarkerAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public ShowNextChangeMarkerAction(@NotNull Editor editor, Range range2) {
            if (editor == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(1);
            }
            super(editor, range2, "VcsShowNextChangeMarker");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(3);
            }
            return LineStatusMarkerPopupRenderer.this.myTracker.getNextRange(range2.getLine1()) != null;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            Object targetRange;
            if (editor == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(5);
            }
            if ((targetRange = LineStatusMarkerPopupRenderer.this.myTracker.getNextRange(range2.getLine1())) != null) {
                LineStatusMarkerPopupRenderer.this.scrollAndShow(editor, (Range)targetRange);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ShowNextChangeMarkerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected abstract class RangeMarkerAction
    extends DumbAwareAction {
        @NotNull
        private final Range myRange;
        @NotNull
        private final Editor myEditor;

        public RangeMarkerAction(@NotNull Editor editor, @Nullable @NonNls Range range2, String actionId) {
            if (editor == null) {
                RangeMarkerAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                RangeMarkerAction.$$$reportNull$$$0(1);
            }
            this.myRange = range2;
            this.myEditor = editor;
            if (actionId != null) {
                ActionUtil.copyFrom((AnAction)this, (String)actionId);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RangeMarkerAction.$$$reportNull$$$0(2);
            }
            Object newRange = LineStatusMarkerPopupRenderer.this.myTracker.findRange(this.myRange);
            e.getPresentation().setEnabled(newRange != null && !this.myEditor.isDisposed() && this.isEnabled(this.myEditor, (Range)newRange));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object newRange;
            if (e == null) {
                RangeMarkerAction.$$$reportNull$$$0(3);
            }
            if ((newRange = LineStatusMarkerPopupRenderer.this.myTracker.findRange(this.myRange)) != null) {
                this.actionPerformed(this.myEditor, (Range)newRange);
            }
        }

        protected abstract boolean isEnabled(@NotNull Editor var1, @NotNull Range var2);

        protected abstract void actionPerformed(@NotNull Editor var1, @NotNull Range var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$RangeMarkerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PopupPanel
    extends JPanel {
        @Nullable
        private final JComponent myEditorComponent;
        @NotNull
        private final Editor myEditor;

        PopupPanel(final @NotNull Editor editor, @NotNull ActionToolbar toolbar, @Nullable JComponent editorComponent, @Nullable JComponent additionalInfo) {
            if (editor == null) {
                PopupPanel.$$$reportNull$$$0(0);
            }
            if (toolbar == null) {
                PopupPanel.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.setOpaque(false);
            this.myEditor = editor;
            this.myEditorComponent = editorComponent;
            boolean isEditorVisible = this.myEditorComponent != null;
            JBColor borderColor = new JBColor((Color)Gray._206, (Color)Gray._75);
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBorder(null);
            BorderLayoutPanel toolbarPanel = JBUI.Panels.simplePanel((Component)toolbarComponent);
            Border outsideToolbarBorder = JBUI.Borders.customLine((Color)borderColor, (int)1, (int)1, (int)(isEditorVisible ? 0 : 1), (int)1);
            JBEmptyBorder insideToolbarBorder = JBUI.Borders.empty((int)1, (int)5);
            toolbarPanel.setBorder(BorderFactory.createCompoundBorder(outsideToolbarBorder, (Border)insideToolbarBorder));
            if (additionalInfo != null) {
                toolbarPanel.add((Component)additionalInfo, "East");
            }
            if (this.myEditorComponent != null) {
                Border outsideEditorBorder = JBUI.Borders.customLine((Color)borderColor, (int)1);
                Border insideEditorBorder = JBUI.Borders.empty((int)2);
                this.myEditorComponent.setBorder(BorderFactory.createCompoundBorder(outsideEditorBorder, insideEditorBorder));
            }
            JPanel emptyPanel = new JPanel();
            emptyPanel.setOpaque(false);
            emptyPanel.setPreferredSize(new Dimension());
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.setOpaque(false);
            topPanel.add((Component)toolbarPanel, "West");
            topPanel.add((Component)emptyPanel, "Center");
            this.add((Component)topPanel, "North");
            if (this.myEditorComponent != null) {
                this.add((Component)this.myEditorComponent, "Center");
            }
            MouseAdapter listener2 = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PopupPanel.transferEvent(e, editor);
                }
            };
            emptyPanel.addMouseListener(listener2);
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = this.myEditor;
            if (editor == null) {
                PopupPanel.$$$reportNull$$$0(2);
            }
            return editor;
        }

        private static void transferEvent(MouseEvent e, Editor editor) {
            editor.getContentComponent().dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, editor.getContentComponent()));
        }

        int getEditorTextOffset() {
            return EditorFragmentComponent.createEditorFragmentBorder((Editor)this.myEditor).getBorderInsets((Component)this.myEditorComponent).left;
        }

        @Override
        public Dimension getPreferredSize() {
            int gap = JBUI.scale((int)10);
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Component)this.myEditor.getComponent());
            Rectangle maxSize2 = new Rectangle(screenRectangle.width - gap, screenRectangle.height - gap);
            Dimension size = super.getPreferredSize();
            if (size.width > maxSize2.width) {
                size.width = maxSize2.width;
                size.height += JBUI.scale((int)20);
            }
            if (size.height > maxSize2.height) {
                size.height = maxSize2.height;
            }
            return size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolbar";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$PopupPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$PopupPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

