/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StubTreeLoaderImpl
extends StubTreeLoader {
    private static final Logger LOG = Logger.getInstance(StubTreeLoaderImpl.class);
    private static volatile boolean ourStubReloadingProhibited;

    StubTreeLoaderImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ObjectStubTree<?> readOrBuild(Project project, VirtualFile vFile, @Nullable PsiFile psiFile) {
        ObjectStubTree<?> fromIndices = this.readFromVFile(project, vFile);
        if (fromIndices != null) {
            return fromIndices;
        }
        try {
            byte[] content2 = vFile.contentsToByteArray();
            vFile.setPreloadedContentHint(content2);
            try {
                Stub element2;
                FileContentImpl content1 = new FileContentImpl(vFile, content2);
                if (project != null) {
                    content1.setProject(project);
                }
                FileContentImpl fc = content1;
                if (psiFile != null && !vFile.getFileType().isBinary()) {
                    fc.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, psiFile.getViewProvider().getContents());
                }
                ObjectStubTree tree = (element2 = (Stub)RecursionManager.doPreventingRecursion((Object)vFile, (boolean)false, () -> StubTreeLoaderImpl.lambda$readOrBuild$0((FileContent)fc))) instanceof PsiFileStub ? new StubTree((PsiFileStub)element2) : (element2 instanceof ObjectStubBase ? new ObjectStubTree((ObjectStubBase)element2, true) : null);
                if (tree == null) return null;
                tree.setDebugInfo("created from file content");
                ObjectStubTree objectStubTree = tree;
                return objectStubTree;
            }
            finally {
                vFile.setPreloadedContentHint(null);
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Throwable)e);
                return null;
            }
            LOG.info("Can't load file content for stub building: " + e.getMessage());
        }
        return null;
    }

    @Override
    @Nullable
    public ObjectStubTree<?> readFromVFile(Project project, VirtualFile vFile) {
        if (DumbService.getInstance((Project)project).isDumb() || NoAccessDuringPsiEvents.isInsideEventProcessing()) {
            return null;
        }
        int id2 = FileBasedIndex.getFileId((VirtualFile)vFile);
        if (id2 == 0) {
            return null;
        }
        boolean wasIndexedAlready = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).isFileUpToDate(vFile);
        Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
        boolean saved = document == null || !FileDocumentManager.getInstance().isDocumentUnsaved(document);
        Map datas = FileBasedIndex.getInstance().getFileData(StubUpdatingIndex.INDEX_ID, vFile, project);
        int size = datas.size();
        if (size == 1) {
            Stub stub;
            SerializedStubTree stubTree = (SerializedStubTree)datas.values().iterator().next();
            if (!this.checkLengthMatch(project, vFile, wasIndexedAlready, document, saved)) {
                return null;
            }
            try {
                stub = stubTree.getStub();
            }
            catch (SerializerNotFoundException e) {
                return StubTreeLoaderImpl.processError(vFile, "No stub serializer: " + vFile.getPresentableUrl() + ": " + e.getMessage(), (Exception)((Object)e));
            }
            if (stub == SerializedStubTree.NO_STUB) {
                return null;
            }
            ObjectStubTree tree = stub instanceof PsiFileStub ? new StubTree((PsiFileStub)stub) : new ObjectStubTree((ObjectStubBase)stub, true);
            tree.setDebugInfo("created from index");
            StubTreeLoaderImpl.checkDeserializationCreatesNoPsi(tree);
            return tree;
        }
        if (size != 0) {
            return StubTreeLoaderImpl.processError(vFile, "Twin stubs: " + vFile.getPresentableUrl() + " has " + size + " stub versions. Should only have one. id=" + id2, null);
        }
        return null;
    }

    private boolean checkLengthMatch(Project project, VirtualFile vFile, boolean wasIndexedAlready, Document document, boolean saved) {
        PsiFile cachedPsi = PsiManagerEx.getInstanceEx(project).getFileManager().getCachedPsiFile(vFile);
        IndexingStampInfo indexingStampInfo = this.getIndexingStampInfo(vFile);
        if (indexingStampInfo != null && !indexingStampInfo.contentLengthMatches(vFile.getLength(), StubTreeLoaderImpl.getCurrentTextContentLength(project, vFile, document, cachedPsi))) {
            this.diagnoseLengthMismatch(vFile, wasIndexedAlready, document, saved, cachedPsi);
            return false;
        }
        return true;
    }

    private void diagnoseLengthMismatch(VirtualFile vFile, boolean wasIndexedAlready, @Nullable Document document, boolean saved, @Nullable PsiFile cachedPsi) {
        String message = "Outdated stub in index: " + vFile + " " + this.getIndexingStampInfo(vFile) + ", doc=" + document + ", docSaved=" + saved + ", wasIndexedAlready=" + wasIndexedAlready + ", queried at " + vFile.getTimeStamp();
        message = message + "\ndoc length=" + (document == null ? -1 : document.getTextLength()) + "\nfile length=" + vFile.getLength();
        if (cachedPsi != null) {
            message = message + "\ncached PSI " + cachedPsi.getClass();
            if (cachedPsi instanceof PsiFileImpl && ((PsiFileImpl)cachedPsi).isContentsLoaded()) {
                message = message + "\nPSI length=" + cachedPsi.getTextLength();
            }
            List projects = ContainerUtil.findAll((Object[])ProjectManager.getInstance().getOpenProjects(), p -> PsiManagerEx.getInstanceEx(p).getFileManager().findCachedViewProvider(vFile) != null);
            message = message + "\nprojects with file: " + (LOG.isDebugEnabled() ? projects.toString() : Integer.valueOf(projects.size()));
        }
        StubTreeLoaderImpl.processError(vFile, message, new Exception());
    }

    private static void checkDeserializationCreatesNoPsi(ObjectStubTree<?> tree) {
        if (ourStubReloadingProhibited || !(tree instanceof StubTree)) {
            return;
        }
        for (PsiFileStub root : ((PsiFileStubImpl)tree.getRoot()).getStubRoots()) {
            if (!(root instanceof StubBase)) continue;
            StubList stubList = ((StubBase)root).myStubList;
            for (int i2 = 0; i2 < stubList.size(); ++i2) {
                PsiElement cachedPsi;
                StubBase each = stubList.getCachedStub(i2);
                PsiElement psiElement = cachedPsi = each == null ? null : each.getCachedPsi();
                if (cachedPsi == null) continue;
                ourStubReloadingProhibited = true;
                throw new AssertionError((Object)("Stub deserialization shouldn't create PSI: " + cachedPsi + "; " + each));
            }
        }
    }

    private static int getCurrentTextContentLength(Project project, VirtualFile vFile, Document document, PsiFile psiFile) {
        if (vFile.getFileType().isBinary()) {
            return -1;
        }
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded()) {
            return psiFile.getTextLength();
        }
        if (document != null) {
            return PsiDocumentManager.getInstance((Project)project).getLastCommittedText(document).length();
        }
        return -1;
    }

    private static ObjectStubTree<?> processError(VirtualFile vFile, String message, @Nullable Exception e) {
        LOG.error(message, (Throwable)e);
        AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().submit(() -> {
            Document doc = FileDocumentManager.getInstance().getCachedDocument(vFile);
            if (doc != null) {
                FileDocumentManager.getInstance().saveDocument(doc);
            }
            FileBasedIndex.getInstance().requestReindex(vFile);
        });
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile) {
        FileBasedIndex.getInstance().requestReindex(virtualFile);
    }

    @Override
    public boolean canHaveStub(VirtualFile file2) {
        return StubUpdatingIndex.canHaveStub(file2);
    }

    @Override
    protected boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(0);
        }
        int count = 0;
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (PsiManagerEx.getInstanceEx(project).getFileManager().findCachedViewProvider(virtualFile) == null) continue;
            ++count;
        }
        return count > 1;
    }

    @Override
    protected IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(1);
        }
        return StubUpdatingIndex.getIndexingStampInfo(file2);
    }

    @Override
    protected boolean isPrebuilt(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            StubTreeLoaderImpl.$$$reportNull$$$0(2);
        }
        try {
            FileContent fileContent = FileContentImpl.createByFile(virtualFile);
            SerializedStubTree prebuiltStub = StubUpdatingIndex.findPrebuiltSerializedStubTree(fileContent);
            return prebuiltStub != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static /* synthetic */ Stub lambda$readOrBuild$0(FileContent fc) {
        return StubTreeBuilder.buildStubTree(fc);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/StubTreeLoaderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPsiInManyProjects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexingStampInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrebuilt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

