/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import com.intellij.util.io.NettyKt;
import com.intellij.util.text.CharArrayCharSequence;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.ByteBufUtilEx;
import java.io.InputStream;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\"\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tJ\b\u0010\u000f\u001a\u00020\fH\u0016J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ \u0010\u0010\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/netty/buffer/ByteBufUtf8Writer;", "Ljava/io/Writer;", "buffer", "Lio/netty/buffer/ByteBuf;", "(Lio/netty/buffer/ByteBuf;)V", "append", "csq", "", "start", "", "end", "close", "", "ensureWritable", "minWritableBytes", "flush", "write", "inputStream", "Ljava/io/InputStream;", "length", "chars", "", "off", "len", "str", "", "intellij.platform.ide.impl"})
public final class ByteBufUtf8Writer
extends Writer {
    private final ByteBuf buffer;

    public final void write(@NotNull InputStream inputStream, int length) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        this.buffer.writeBytes(inputStream, length);
    }

    public final void ensureWritable(int minWritableBytes) {
        this.buffer.ensureWritable(minWritableBytes);
    }

    @Override
    public void write(@NotNull char[] chars, int off, int len) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        NettyKt.writeUtf8((ByteBuf)this.buffer, (CharSequence)((CharSequence)new CharArrayCharSequence(chars, off, off + len)));
    }

    @Override
    public void write(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        NettyKt.writeUtf8((ByteBuf)this.buffer, (CharSequence)str);
    }

    @Override
    public void write(@NotNull String str, int off, int len) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        ByteBufUtilEx.writeUtf8(this.buffer, str, off, off + len);
    }

    @Override
    @NotNull
    public Writer append(@Nullable CharSequence csq) {
        if (csq == null) {
            ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)"null");
        } else {
            NettyKt.writeUtf8((ByteBuf)this.buffer, (CharSequence)csq);
        }
        return this;
    }

    @Override
    @NotNull
    public Writer append(@Nullable CharSequence csq, int start2, int end) {
        ByteBufUtilEx.writeUtf8(this.buffer, csq, start2, end);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public ByteBufUtf8Writer(@NotNull ByteBuf buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        this.buffer = buffer;
    }
}

