/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitStashDialog;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitStash
extends GitRepositoryAction {
    @Override
    protected void perform(final @NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        if (project == null) {
            GitStash.$$$reportNull$$$0(0);
        }
        if (gitRoots == null) {
            GitStash.$$$reportNull$$$0(1);
        }
        if (defaultRoot == null) {
            GitStash.$$$reportNull$$$0(2);
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(GitBundle.message("stash.error.can.not.stash.changes.now", new Object[0]))) {
            return;
        }
        final GitStashDialog d = new GitStashDialog(project, gitRoots, defaultRoot);
        if (!d.showAndGet()) {
            return;
        }
        new Task.Backgroundable(project, GitBundle.getString("stashing.title"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try (AccessToken ignored = DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitStash.this.getActionName());){
                    GitCommandResult result2 = Git.getInstance().runCommand(d.handler());
                    if (result2.success()) {
                        GitUtil.refreshVfsInRoot(d.getGitRoot());
                    } else {
                        VcsNotifier.getInstance((Project)project).notifyError("Stash Failed", result2.getErrorOutputAsHtmlString(), true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitStash$1", "run"));
            }
        }.queue();
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("stash.action.name");
        if (string == null) {
            GitStash.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitStash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitStash";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

