/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state;

import de.rub.nds.tlsattacker.core.connection.Aliasable;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.exceptions.ContextHandlingException;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContextContainer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<String> knownAliases = new HashSet<String>();
    private final Map<String, TlsContext> tlsContexts = new HashMap<String, TlsContext>();
    private final List<TlsContext> inboundTlsContexts = new ArrayList<TlsContext>();
    private final List<TlsContext> outboundTlsContexts = new ArrayList<TlsContext>();

    public TlsContext getTlsContext() {
        if (this.tlsContexts.isEmpty()) {
            throw new ConfigurationException("No context defined.");
        }
        if (this.tlsContexts.size() > 1) {
            throw new ConfigurationException("getTlsContext requires an alias if multiple contexts are defined");
        }
        return this.tlsContexts.entrySet().iterator().next().getValue();
    }

    public TlsContext getTlsContext(String alias) {
        TlsContext ctx = this.tlsContexts.get(alias);
        if (ctx == null) {
            throw new ConfigurationException("No context defined with alias '" + alias + "'.");
        }
        return ctx;
    }

    public void addTlsContext(TlsContext context) {
        AliasedConnection con = context.getConnection();
        String alias = con.getAlias();
        if (alias == null) {
            throw new ContextHandlingException("Connection end alias not set (null). Can't add the TLS context.");
        }
        if (this.containsAlias(alias)) {
            throw new ConfigurationException("Connection end alias already in use: " + alias);
        }
        this.tlsContexts.put(alias, context);
        this.knownAliases.add(alias);
        if (con.getLocalConnectionEndType() == ConnectionEndType.SERVER) {
            LOGGER.debug("Adding context " + alias + " to inboundTlsContexts");
            this.inboundTlsContexts.add(context);
        } else {
            LOGGER.debug("Adding context " + alias + " to outboundTlsContexts");
            this.outboundTlsContexts.add(context);
        }
    }

    public List<TlsContext> getAllContexts() {
        return new ArrayList<TlsContext>(this.tlsContexts.values());
    }

    public List<TlsContext> getInboundTlsContexts() {
        return this.inboundTlsContexts;
    }

    public List<TlsContext> getOutboundTlsContexts() {
        return this.outboundTlsContexts;
    }

    public boolean containsAlias(String alias) {
        return this.knownAliases.contains(alias);
    }

    public boolean containsAllAliases(Collection<? extends String> aliases) {
        return this.knownAliases.containsAll(aliases);
    }

    public boolean containsAllAliases(Aliasable aliasable) {
        return this.knownAliases.containsAll(aliasable.getAllAliases());
    }

    public boolean isEmpty() {
        return this.tlsContexts.isEmpty();
    }

    public void clear() {
        this.tlsContexts.clear();
        this.knownAliases.clear();
        this.inboundTlsContexts.clear();
        this.outboundTlsContexts.clear();
    }

    public void removeTlsContext(String alias) {
        if (this.containsAlias(alias)) {
            TlsContext removeMe = this.tlsContexts.get(alias);
            this.inboundTlsContexts.remove(removeMe);
            this.outboundTlsContexts.remove(removeMe);
            this.tlsContexts.remove(alias);
            this.knownAliases.remove(alias);
        } else {
            LOGGER.debug("No context with alias " + alias + " found, nothing to remove");
        }
    }

    public void replaceTlsContext(TlsContext newTlsContext) {
        String alias = newTlsContext.getConnection().getAlias();
        if (!this.containsAlias(alias)) {
            throw new ConfigurationException("No TlsContext to replace for alias " + alias);
        }
        TlsContext replaceMe = this.tlsContexts.get(alias);
        if (!replaceMe.getConnection().equals(newTlsContext.getConnection())) {
            throw new ContextHandlingException("Cannot replace TlsContext because the new TlsContext defines another connection.");
        }
        this.removeTlsContext(alias);
        this.addTlsContext(newTlsContext);
    }
}

