/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.database.ConnectionManager;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;

public class AsyncSocket
extends WebSocketAdapter
implements ConnectionManager.UpdateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncSocket.class);
    private static final String KEY_DEVICES = "devices";
    private static final String KEY_POSITIONS = "positions";
    private static final String KEY_EVENTS = "events";
    private long userId;

    public AsyncSocket(long userId) {
        this.userId = userId;
    }

    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        HashMap data = new HashMap();
        data.put(KEY_POSITIONS, Context.getDeviceManager().getInitialState(this.userId));
        this.sendData(data);
        Context.getConnectionManager().addListener(this.userId, this);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        super.onWebSocketClose(statusCode, reason);
        Context.getConnectionManager().removeListener(this.userId, this);
    }

    @Override
    public void onUpdateDevice(Device device) {
        HashMap data = new HashMap();
        data.put(KEY_DEVICES, Collections.singletonList(device));
        this.sendData(data);
    }

    @Override
    public void onUpdatePosition(Position position) {
        HashMap data = new HashMap();
        data.put(KEY_POSITIONS, Collections.singletonList(position));
        this.sendData(data);
    }

    @Override
    public void onUpdateEvent(Event event) {
        HashMap data = new HashMap();
        data.put(KEY_EVENTS, Collections.singletonList(event));
        this.sendData(data);
    }

    private void sendData(Map<String, Collection<?>> data) {
        if (!data.isEmpty() && this.isConnected()) {
            try {
                this.getRemote().sendString(Context.getObjectMapper().writeValueAsString(data), null);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Socket JSON formatting error", (Throwable)e);
            }
        }
    }
}

