/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class Tk103ProtocolDecoder
extends BaseProtocolDecoder {
    private final boolean decodeLow = Context.getConfig().getBoolean(this.getProtocolName() + ".decodeLow");
    private static final Pattern PATTERN = new PatternBuilder().text("(").optional().groupBegin().expression("(.{12})").or().expression("([^,]+),").groupEnd().expression("(.{4}),?").groupBegin().number("(d*)").or().text(",ALARM,").number("(d),").number("d+,").groupEnd().number("(dd)(dd)(dd),?").expression("([AV]),?").number(" *(d+)(dd.d+)").expression("([NS]),?").number(" *(d+)(dd.d+)").expression("([EW]),?").number(" *(d+.d)(?:d*,)?").number("(dd)(dd)(dd),?").groupBegin().number("(?:([ d.]{6})|(dd)),?").number("([01])").number("([01])").number("(x)").number("(x)").number("(x)").number("(xxx)").number("L(x+)").or().number("(d+.d+)").groupEnd().any().number("([+-]ddd.d)?").text(")").optional().compile();
    private static final Pattern PATTERN_BATTERY = new PatternBuilder().text("(").optional().number("(d+),").text("ZC20,").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(d+),").number("(d+),").number("(d+),").number("d+").any().compile();
    private static final Pattern PATTERN_NETWORK = new PatternBuilder().text("(").optional().number("(d{12})").text("BZ00,").number("(d+),").number("(d+),").number("(x+),").number("(x+),").any().compile();
    private static final Pattern PATTERN_LBSWIFI = new PatternBuilder().text("(").optional().number("(d+),").expression("(.{4}),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("((?:(?:xx:){5}(?:xx)\\*[-+]?d+\\*d+,)*)").number("(dd)(dd)(dd),").number("(dd)(dd)(dd)").any().compile();
    private static final Pattern PATTERN_COMMAND_RESULT = new PatternBuilder().text("(").optional().number("(d+),").expression(".{4},").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("\\$([\\s\\S]*?)(?:\\$|$)").any().compile();
    private static final Pattern PATTERN_VIN = new PatternBuilder().text("(").number("(d+)").expression("BV00").expression("(.{17})").text(")").compile();

    public Tk103ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int value) {
        switch (value) {
            case 1: {
                return "accident";
            }
            case 2: {
                return "sos";
            }
            case 3: {
                return "vibration";
            }
            case 4: {
                return "lowspeed";
            }
            case 5: {
                return "overspeed";
            }
            case 6: {
                return "geofenceExit";
            }
        }
        return null;
    }

    private void decodeType(Position position, String type, String data) {
        block34 : switch (type) {
            case "BQ81": {
                switch (Integer.parseInt(data)) {
                    case 0: {
                        position.set("alarm", "lowBattery");
                        break block34;
                    }
                    case 1: {
                        position.set("alarm", "overspeed");
                        break block34;
                    }
                    case 2: {
                        position.set("alarm", "idle");
                        break block34;
                    }
                    case 3: {
                        position.set("alarm", "hardAcceleration");
                        break block34;
                    }
                    case 4: {
                        position.set("alarm", "hardBraking");
                        break block34;
                    }
                    case 5: {
                        position.set("alarm", "temperature");
                        break block34;
                    }
                }
                break;
            }
            case "BO01": {
                position.set("alarm", this.decodeAlarm(data.charAt(0) - 48));
                break;
            }
            case "ZC11": 
            case "DW31": 
            case "DW51": {
                position.set("alarm", "movement");
                break;
            }
            case "ZC12": 
            case "DW32": 
            case "DW52": {
                position.set("alarm", "lowBattery");
                break;
            }
            case "ZC13": 
            case "DW33": 
            case "DW53": {
                position.set("alarm", "powerCut");
                break;
            }
            case "ZC15": 
            case "DW35": 
            case "DW55": {
                position.set("ignition", true);
                break;
            }
            case "ZC16": 
            case "DW36": 
            case "DW56": {
                position.set("ignition", false);
                break;
            }
            case "ZC29": 
            case "DW42": 
            case "DW62": {
                position.set("ignition", true);
                break;
            }
            case "ZC17": 
            case "DW37": 
            case "DW57": {
                position.set("alarm", "removing");
                break;
            }
            case "ZC25": 
            case "DW3E": 
            case "DW5E": {
                position.set("alarm", "sos");
                break;
            }
            case "ZC26": 
            case "DW3F": 
            case "DW5F": {
                position.set("alarm", "tampering");
                break;
            }
            case "ZC27": 
            case "DW40": 
            case "DW60": {
                position.set("alarm", "lowPower");
                break;
            }
        }
    }

    private Integer decodeBattery(int value) {
        switch (value) {
            case 6: {
                return 100;
            }
            case 5: {
                return 80;
            }
            case 4: {
                return 50;
            }
            case 3: {
                return 20;
            }
            case 2: {
                return 10;
            }
        }
        return null;
    }

    private Position decodeBattery(Channel channel, SocketAddress remoteAddress, String sentence) {
        int power;
        int battery;
        Parser parser = new Parser(PATTERN_BATTERY, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        int batteryLevel = parser.nextInt(0);
        if (batteryLevel != 255) {
            position.set("batteryLevel", this.decodeBattery(batteryLevel));
        }
        if ((battery = parser.nextInt(0)) != 65535) {
            position.set("battery", (double)battery * 0.01);
        }
        if ((power = parser.nextInt(0)) != 65535) {
            position.set("power", (double)power * 0.1);
        }
        return position;
    }

    private Position decodeNetwork(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_NETWORK, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.setNetwork(new Network(CellTower.from(parser.nextInt(0), parser.nextInt(0), parser.nextHexInt(0), parser.nextHexInt(0))));
        return position;
    }

    private Position decodeLbsWifi(Channel channel, SocketAddress remoteAddress, String sentence) {
        String[] wifimacs;
        Parser parser = new Parser(PATTERN_LBSWIFI, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.decodeType(position, parser.next(), "0");
        this.getLastLocation(position, null);
        Network network = new Network();
        network.addCellTower(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextInt(), parser.nextInt().intValue()));
        int wifiCount = parser.nextInt();
        if (parser.hasNext() && (wifimacs = parser.next().split(",")).length == wifiCount) {
            for (int i = 0; i < wifiCount; ++i) {
                String[] wifiinfo = wifimacs[i].split("\\*");
                network.addWifiAccessPoint(WifiAccessPoint.from(wifiinfo[0], Integer.parseInt(wifiinfo[1]), Integer.parseInt(wifiinfo[2])));
            }
        }
        if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
            position.setNetwork(network);
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        return position;
    }

    private Position decodeCommandResult(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_COMMAND_RESULT, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.set("result", parser.next());
        return position;
    }

    private Position decodeVin(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_VIN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("vin", parser.next());
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        String sentence = (String)msg;
        if (channel != null) {
            String id = sentence.substring(1, 13);
            String type = sentence.substring(13, 17);
            if (type.equals("BP00")) {
                channel.writeAndFlush((Object)new NetworkMessage("(" + id + "AP01HSO)", remoteAddress));
                return null;
            }
            if (type.equals("BP05")) {
                channel.writeAndFlush((Object)new NetworkMessage("(" + id + "AP05)", remoteAddress));
            }
        }
        if (sentence.contains("ZC20")) {
            return this.decodeBattery(channel, remoteAddress, sentence);
        }
        if (sentence.contains("BZ00")) {
            return this.decodeNetwork(channel, remoteAddress, sentence);
        }
        if (sentence.contains("ZC03")) {
            return this.decodeCommandResult(channel, remoteAddress, sentence);
        }
        if (sentence.contains("DW5")) {
            return this.decodeLbsWifi(channel, remoteAddress, sentence);
        }
        if (sentence.contains("BV00")) {
            return this.decodeVin(channel, remoteAddress, sentence);
        }
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        String id = null;
        boolean alternative = false;
        if (parser.hasNext()) {
            id = parser.next();
        }
        if (parser.hasNext()) {
            id = parser.next();
            alternative = true;
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, id)) == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String type = parser.next();
        String data = null;
        if (parser.hasNext()) {
            data = parser.next();
        }
        if (parser.hasNext()) {
            data = parser.next();
        }
        this.decodeType(position, type, data);
        DateBuilder dateBuilder = new DateBuilder();
        if (alternative) {
            dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        } else {
            dateBuilder.setDate(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        }
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(this.convertSpeed(parser.nextDouble(0.0), "kmh"));
        dateBuilder.setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        if (parser.hasNext()) {
            position.setCourse(parser.nextDouble());
        }
        if (parser.hasNext()) {
            position.setCourse(parser.nextDouble());
        }
        if (parser.hasNext(7)) {
            position.set("charge", parser.nextInt() == 0);
            position.set("ignition", parser.nextInt() == 1);
            int mask1 = parser.nextHexInt();
            position.set("in2", BitUtil.check(mask1, 0) ? 1 : 0);
            position.set("panic", BitUtil.check(mask1, 1) ? 1 : 0);
            position.set("out2", BitUtil.check(mask1, 2) ? 1 : 0);
            if (this.decodeLow || BitUtil.check(mask1, 3)) {
                position.set("blocked", BitUtil.check(mask1, 3) ? 1 : 0);
            }
            int mask2 = parser.nextHexInt();
            for (int i = 0; i < 3; ++i) {
                if (!this.decodeLow && !BitUtil.check(mask2, i)) continue;
                position.set("hs" + (3 - i), BitUtil.check(mask2, i) ? 1 : 0);
            }
            if (this.decodeLow || BitUtil.check(mask2, 3)) {
                position.set("door", BitUtil.check(mask2, 3) ? 1 : 0);
            }
            int mask3 = parser.nextHexInt();
            for (int i = 1; i <= 3; ++i) {
                if (!this.decodeLow && !BitUtil.check(mask3, i)) continue;
                position.set("ls" + (3 - i + 1), BitUtil.check(mask3, i) ? 1 : 0);
            }
            position.set("fuel", parser.nextHexInt());
            position.set("odometer", parser.nextLong(16, 0L));
        }
        if (parser.hasNext()) {
            position.setCourse(parser.nextDouble());
        }
        if (parser.hasNext()) {
            position.set("temp1", parser.nextDouble(0.0));
        }
        return position;
    }
}

