/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class Xrb28ProtocolDecoder
extends BaseProtocolDecoder {
    private String pendingCommand;
    private static final Pattern PATTERN = new PatternBuilder().text("*").expression("....,").expression("..,").number("d{15},").expression("..,").number("[01],").number("(dd)(dd)(dd).d+,").expression("([AV]),").number("(dd)(dd.d+),").expression("([NS]),").number("(d{2,3})(dd.d+),").expression("([EW]),").number("(d+),").number("(d+.d+),").number("(dd)(dd)(dd),").number("(-?d+.?d*),").expression(".,").expression(".#").compile();

    public void setPendingCommand(String pendingCommand) {
        this.pendingCommand = pendingCommand;
    }

    public Xrb28ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, sentence.substring(9, 24));
        if (deviceSession == null) {
            return null;
        }
        String type = sentence.substring(25, 27);
        if (channel != null) {
            if (type.matches("L0|L1|W0|E1")) {
                channel.write((Object)new NetworkMessage("\u00ff\u00ff*SCOS" + sentence.substring(5, 27) + "#\n", remoteAddress));
            } else if (type.equals("R0") && this.pendingCommand != null) {
                String command = this.pendingCommand.equals("alarmArm") ? "L1," : "L0,";
                channel.write((Object)new NetworkMessage("\u00ff\u00ff*SCOS" + sentence.substring(5, 25) + command + sentence.substring(30) + "\n", remoteAddress));
                this.pendingCommand = null;
            }
        }
        if (!type.startsWith("D")) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            String payload = sentence.substring(25, sentence.length() - 1);
            int index = 0;
            String[] values = payload.substring(3).split(",");
            block19 : switch (type) {
                case "Q0": {
                    position.set("battery", (double)Integer.parseInt(values[index++]) * 0.01);
                    position.set("batteryLevel", Integer.parseInt(values[index++]));
                    position.set("rssi", Integer.parseInt(values[index++]));
                    break;
                }
                case "H0": {
                    position.set("blocked", Integer.parseInt(values[index++]) > 0);
                    position.set("battery", (double)Integer.parseInt(values[index++]) * 0.01);
                    position.set("rssi", Integer.parseInt(values[index++]));
                    position.set("batteryLevel", Integer.parseInt(values[index++]));
                    break;
                }
                case "W0": {
                    switch (Integer.parseInt(values[index++])) {
                        case 1: {
                            position.set("alarm", "movement");
                            break block19;
                        }
                        case 2: {
                            position.set("alarm", "fallDown");
                            break block19;
                        }
                        case 3: {
                            position.set("alarm", "lowBattery");
                            break block19;
                        }
                    }
                    break;
                }
                case "E0": {
                    position.set("alarm", "fault");
                    position.set("error", Integer.parseInt(values[index++]));
                    break;
                }
                case "S1": {
                    position.set("event", Integer.parseInt(values[index++]));
                    break;
                }
                case "R0": 
                case "L0": 
                case "L1": 
                case "S4": 
                case "S5": 
                case "S6": 
                case "S7": 
                case "V0": 
                case "G0": 
                case "K0": 
                case "I0": 
                case "M0": {
                    position.set("result", payload);
                    break;
                }
            }
            return !position.getAttributes().isEmpty() ? position : null;
        }
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.set("sat", parser.nextInt());
        position.set("hdop", parser.nextDouble());
        dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
        position.setTime(dateBuilder.getDate());
        position.setAltitude(parser.nextDouble());
        return position;
    }
}

