/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.impl;

import com.cloudhopper.smpp.PduAsyncResponse;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class PollableSmppSessionHandler
implements SmppSessionHandler {
    private final BlockingQueue<PduRequest> receivedPduRequests = new LinkedBlockingQueue<PduRequest>();
    private final BlockingQueue<PduAsyncResponse> receivedExpectedPduResponses = new LinkedBlockingQueue<PduAsyncResponse>();
    private final BlockingQueue<PduResponse> receivedUnexpectedPduResponses = new LinkedBlockingQueue<PduResponse>();
    private final BlockingQueue<Throwable> throwables = new LinkedBlockingQueue<Throwable>();
    private final AtomicInteger closedCount = new AtomicInteger();

    public BlockingQueue<PduRequest> getReceivedPduRequests() {
        return this.receivedPduRequests;
    }

    public BlockingQueue<PduAsyncResponse> getReceivedExpectedPduResponses() {
        return this.receivedExpectedPduResponses;
    }

    public BlockingQueue<PduResponse> getReceivedUnexpectedPduResponses() {
        return this.receivedUnexpectedPduResponses;
    }

    public BlockingQueue<Throwable> getThrowables() {
        return this.throwables;
    }

    public int getClosedCount() {
        return this.closedCount.get();
    }

    @Override
    public String lookupResultMessage(int commandStatus) {
        return null;
    }

    @Override
    public String lookupTlvTagName(short tag) {
        return null;
    }

    @Override
    public PduResponse firePduRequestReceived(PduRequest pduRequest) {
        this.receivedPduRequests.add(pduRequest);
        return null;
    }

    @Override
    public void fireExpectedPduResponseReceived(PduAsyncResponse pduAsyncResponse) {
        this.receivedExpectedPduResponses.add(pduAsyncResponse);
    }

    @Override
    public void fireUnexpectedPduResponseReceived(PduResponse pduResponse) {
        this.receivedUnexpectedPduResponses.add(pduResponse);
    }

    @Override
    public void fireUnrecoverablePduException(UnrecoverablePduException e) {
        this.throwables.add(e);
    }

    @Override
    public void fireRecoverablePduException(RecoverablePduException e) {
        this.throwables.add(e);
    }

    @Override
    public void fireUnknownThrowable(Throwable t) {
        this.throwables.add(t);
    }

    @Override
    public void fireChannelUnexpectedlyClosed() {
        this.closedCount.incrementAndGet();
    }

    @Override
    public void firePduRequestExpired(PduRequest pduRequest) {
    }
}

