/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

import com.cloudhopper.commons.charset.GSMCharset;
import java.util.Arrays;

public class VFTRGSMCharset
extends GSMCharset {
    private static final int GSM_COL = 0;
    private static final int VFTR_COL = 1;
    private static final byte[][] VFTR_OVERRIDE_TABLE = new byte[][]{{2, 36}, {0, 64}, {17, 95}, {64, -95}, {1, -93}, {36, -92}, {3, -91}, {95, -89}, {96, -65}, {91, -60}, {14, -59}, {28, -58}, {9, -57}, {31, -55}, {93, -47}, {92, -42}, {11, -40}, {94, -36}, {30, -33}, {127, -32}, {123, -28}, {15, -27}, {29, -26}, {4, -24}, {5, -23}, {7, -20}, {125, -15}, {8, -14}, {124, -10}, {12, -8}, {6, -7}, {126, -4}, {16, 127}};

    @Override
    public byte[] encode(CharSequence str0) {
        byte[] gsmBytes = super.encode(str0);
        block0: for (int i = 0; i < gsmBytes.length; ++i) {
            for (int j = 0; j < VFTR_OVERRIDE_TABLE.length; ++j) {
                if (gsmBytes[i] != VFTR_OVERRIDE_TABLE[j][0]) continue;
                gsmBytes[i] = VFTR_OVERRIDE_TABLE[j][1];
                continue block0;
            }
        }
        return gsmBytes;
    }

    @Override
    public void decode(byte[] bytes, StringBuilder buffer) {
        int length = bytes == null ? 0 : bytes.length;
        byte[] bytes2 = null;
        block0: for (int i = 0; i < length; ++i) {
            for (int j = 0; j < VFTR_OVERRIDE_TABLE.length; ++j) {
                if (bytes[i] != VFTR_OVERRIDE_TABLE[j][1]) continue;
                if (bytes2 == null) {
                    bytes2 = Arrays.copyOf(bytes, bytes.length);
                }
                bytes2[i] = VFTR_OVERRIDE_TABLE[j][0];
                continue block0;
            }
        }
        super.decode(bytes2 == null ? bytes : bytes2, buffer);
    }
}

