/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.builder.xml;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import java.util.ArrayList;
import java.util.List;
import org.jxls.area.Area;
import org.jxls.area.XlsArea;
import org.jxls.command.Command;
import org.jxls.transform.Transformer;
import org.xml.sax.Attributes;

class AreaAction
extends Action {
    private static final String REF_ATTR = "ref";
    private List<Area> areaList = new ArrayList<Area>();
    private Transformer transformer;

    AreaAction(Transformer transformer) {
        this.transformer = transformer;
    }

    public void begin(InterpretationContext ic, String name, Attributes attributes) throws ActionException {
        String ref = attributes.getValue(REF_ATTR);
        XlsArea area = new XlsArea(ref, this.transformer);
        if (!ic.isEmpty()) {
            Object object = ic.peekObject();
            if (object instanceof Command) {
                Command command = (Command)object;
                command.addArea(area);
            } else {
                String errMsg = "Object [" + object + "] currently at the top of the stack is not a Command";
                ic.addError(errMsg);
                throw new IllegalArgumentException(errMsg);
            }
        }
        ic.pushObject((Object)area);
    }

    public void end(InterpretationContext ic, String name) throws ActionException {
        Area area = (Area)ic.popObject();
        if (ic.isEmpty()) {
            this.areaList.add(area);
        }
    }

    public List<Area> getAreaList() {
        return this.areaList;
    }
}

