/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.ZapResourceBundleControl;

public class I18N {
    private ResourceBundle stdMessages = null;
    private ResourceBundle fallbackStdMessages;
    private Locale locale = null;
    private Map<String, ResourceBundle> addonMessages = new HashMap<String, ResourceBundle>();
    private Set<String> missingKeys = Collections.synchronizedSet(new HashSet());
    private URLClassLoader langClassLoader = I18N.createLangClassLoader();
    private static final Logger logger = Logger.getLogger(I18N.class);

    public I18N(Locale locale) {
        this.setLocale(locale);
    }

    private static URLClassLoader createLangClassLoader() {
        Path langDir = Paths.get(Constant.getZapInstall(), "lang");
        if (Files.exists(langDir, new LinkOption[0])) {
            try {
                return new URLClassLoader(new URL[]{langDir.toUri().toURL()});
            }
            catch (MalformedURLException e) {
                logger.warn((Object)("Failed to convert path " + langDir), (Throwable)e);
            }
        }
        return null;
    }

    public ResourceBundle getCoreResourceBundle() {
        return this.stdMessages;
    }

    public void addMessageBundle(String prefix, ResourceBundle bundle) {
        logger.debug((Object)("Adding message bundle with prefix: " + prefix));
        if (this.addonMessages.containsKey(prefix)) {
            logger.error((Object)("Adding message bundle with duplicate prefix: " + prefix));
        }
        this.addonMessages.put(prefix, bundle);
    }

    public void removeMessageBundle(String prefix) {
        this.missingKeys.removeIf(k -> k.startsWith(prefix));
        logger.debug((Object)("Removing message bundle with prefix: " + prefix));
        if (this.addonMessages.containsKey(prefix)) {
            this.addonMessages.remove(prefix);
        } else {
            logger.debug((Object)("Message bundle not found, prefix: " + prefix));
        }
    }

    public ResourceBundle getMessageBundle(String prefix) {
        return this.addonMessages.get(prefix);
    }

    public String getString(String key) {
        try {
            return this.getStringImpl(key);
        }
        catch (MissingResourceException e) {
            return this.handleMissingResourceException(e);
        }
    }

    private String handleMissingResourceException(MissingResourceException e) {
        logger.error((Object)"Failed to load a message:", (Throwable)e);
        String key = e.getKey();
        this.missingKeys.add(key);
        return I18N.missingKeyReplacement(key);
    }

    private static String missingKeyReplacement(String key) {
        return '!' + key + '!';
    }

    private String getStringImpl(String key) {
        String prefix;
        ResourceBundle bundle;
        if (this.missingKeys.contains(key)) {
            if (!this.containsKey(key)) {
                return I18N.missingKeyReplacement(key);
            }
            this.missingKeys.remove(key);
        }
        if (key.indexOf(".") > 0 && (bundle = this.addonMessages.get(prefix = key.substring(0, key.indexOf(".")))) != null && bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        try {
            return this.stdMessages.getString(key);
        }
        catch (MissingResourceException e) {
            if (this.fallbackStdMessages != null) {
                return this.fallbackStdMessages.getString(key);
            }
            throw e;
        }
    }

    public String getHtmlWrappedString(String key) {
        String values = this.getStringImpl(key);
        if (values == null) {
            return null;
        }
        return "<html><p>" + values + "</p></html>";
    }

    public char getChar(String key) {
        try {
            String str = this.getStringImpl(key);
            if (str.length() > 0) {
                return str.charAt(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return '\u0000';
    }

    public void setLocale(Locale locale) {
        if (locale.equals(this.locale)) {
            return;
        }
        this.locale = locale;
        ZapResourceBundleControl rbc = new ZapResourceBundleControl();
        ResourceBundle fsRb = this.loadFsResourceBundle(rbc);
        if (fsRb != null) {
            this.stdMessages = fsRb;
            logger.debug((Object)"Using file system Messages resource bundle.");
            try {
                this.fallbackStdMessages = this.loadBundledResourceBundle(rbc);
            }
            catch (MissingResourceException e) {
                logger.warn((Object)"Failed to find bundled Messages resource bundle.");
            }
        } else {
            this.stdMessages = this.loadBundledResourceBundle(rbc);
            logger.debug((Object)"Using bundled Messages resource bundle.");
        }
    }

    private ResourceBundle loadFsResourceBundle(ZapResourceBundleControl rbc) {
        if (this.langClassLoader == null) {
            return null;
        }
        ResourceBundle.clearCache(this.langClassLoader);
        try {
            return this.loadResourceBundle("Messages", this.langClassLoader, rbc);
        }
        catch (MissingResourceException e) {
            logger.debug((Object)"Failed to load file system Messages resource bundle.", (Throwable)e);
            return null;
        }
    }

    private ResourceBundle loadBundledResourceBundle(ZapResourceBundleControl rbc) {
        return this.loadResourceBundle("org.zaproxy.zap.resources.Messages", rbc);
    }

    private ResourceBundle loadResourceBundle(String path, ZapResourceBundleControl rbc) {
        return this.loadResourceBundle(path, this.getClass().getClassLoader(), rbc);
    }

    private ResourceBundle loadResourceBundle(String path, ClassLoader classLoader, ZapResourceBundleControl rbc) {
        return ResourceBundle.getBundle(path, this.locale, classLoader, rbc);
    }

    public Locale getLocal() {
        return this.locale;
    }

    public boolean containsKey(String key) {
        String prefix;
        ResourceBundle bundle;
        if (key.indexOf(".") > 0 && (bundle = this.addonMessages.get(prefix = key.substring(0, key.indexOf(".")))) != null && bundle.containsKey(key)) {
            return true;
        }
        return this.stdMessages.containsKey(key);
    }

    public String getString(String key, Object ... params) {
        try {
            return MessageFormat.format(this.getStringImpl(key), params);
        }
        catch (MissingResourceException e) {
            return this.handleMissingResourceException(e);
        }
    }
}

