/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducer;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusEvent;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;

public class MessageLocationProducerFocusListenerAdapter
implements FocusListener {
    private final List<MessageLocationProducerFocusListener> focusListeners;
    private final MessageLocationProducer source;

    public MessageLocationProducerFocusListenerAdapter(MessageLocationProducer source) {
        this.source = source;
        this.focusListeners = new ArrayList<MessageLocationProducerFocusListener>(5);
    }

    public boolean hasFocusListeners() {
        return !this.focusListeners.isEmpty();
    }

    public void addFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.focusListeners.add(focusListener);
    }

    public void removeFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.focusListeners.remove(focusListener);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.focusListeners.isEmpty()) {
            return;
        }
        MessageLocationProducerFocusEvent event = new MessageLocationProducerFocusEvent(this.source, e);
        for (MessageLocationProducerFocusListener focusListener : this.focusListeners) {
            focusListener.focusGained(event);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.focusListeners.isEmpty()) {
            return;
        }
        MessageLocationProducerFocusEvent event = new MessageLocationProducerFocusEvent(this.source, e);
        for (MessageLocationProducerFocusListener focusListener : this.focusListeners) {
            focusListener.focusLost(event);
        }
    }
}

