/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ml extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "\u00a5" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\u0d05\u0d7b\u0d21\u0d4b\u0d31\u0d7b \u0d2a\u0d46\u0d38\u0d46\u0d2f\u0d4d\u0d31\u0d4d\u0d31" },
            { "aed", "\u0d2f\u0d41\u0d23\u0d48\u0d31\u0d4d\u0d31\u0d21\u0d4d \u0d05\u0d31\u0d2c\u0d4d \u0d0e\u0d2e\u0d3f\u0d31\u0d47\u0d31\u0d4d\u0d31\u0d4d\u0d38\u0d4d \u0d26\u0d3f\u0d7c\u0d39\u0d02" },
            { "afa", "\u0d05\u0d2b\u0d4d\u0d18\u0d3e\u0d28\u0d3f (1927\u20132002)" },
            { "afn", "\u0d05\u0d2b\u0d4d\u200c\u0d17\u0d3e\u0d7b \u0d05\u0d2b\u0d4d\u200c\u200c\u0d17\u0d3e\u0d28\u0d3f" },
            { "all", "\u0d05\u0d7d\u0d2c\u0d47\u0d28\u0d3f\u0d2f\u0d7b \u0d32\u0d46\u0d15\u0d4d" },
            { "amd", "\u0d05\u0d7c\u0d2e\u0d47\u0d28\u0d3f\u0d2f\u0d7b \u0d21\u0d4d\u0d30\u0d3e\u0d02" },
            { "ang", "\u0d28\u0d46\u0d24\u0d7c\u0d32\u0d3e\u0d7b\u0d21\u0d4d\u200c\u0d38\u0d4d \u0d06\u0d28\u0d4d\u0d31\u0d3f\u0d32\u0d7b \u0d17\u0d3f\u0d7d\u0d21\u0d7c" },
            { "aoa", "\u0d05\u0d02\u0d17\u0d4b\u0d33\u0d7b \u200d\u0d15\u0d4d\u0d35\u0d3e\u0d7b\u0d38" },
            { "aok", "\u0d05\u0d02\u0d17\u0d4b\u0d33\u0d7b \u200d\u0d15\u0d4d\u0d35\u0d3e\u0d7b\u0d38 (1977\u20131990)" },
            { "aon", "\u0d05\u0d02\u0d17\u0d4b\u0d33\u0d7b \u200d\u0d28\u0d4d\u0d2f\u0d42 \u0d15\u0d4d\u0d35\u0d3e\u0d7b\u0d38 (1990\u20132000)" },
            { "aor", "\u0d05\u0d02\u0d17\u0d4b\u0d33\u0d7b \u200d\u0d15\u0d4d\u0d35\u0d3e\u0d7b\u0d38 \u0d31\u0d3f\u0d2f\u0d3e\u0d1c\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d3e\u0d21\u0d4b (1995\u20131999)" },
            { "ara", "\u0d05\u0d7c\u0d1c\u0d7b\u0d31\u0d40\u0d7b \u0d13\u0d38\u0d4d\u0d1f\u0d4d\u0d30\u0d7d" },
            { "arp", "\u0d05\u0d7c\u0d1c\u0d7b\u0d31\u0d40\u0d7b \u0d2a\u0d46\u0d2f\u0d4d\u0d38\u0d4b (1983\u20131985)" },
            { "ars", "\u0d05\u0d7c\u0d1c\u0d7b\u0d31\u0d40\u0d7b \u0d2a\u0d46\u0d38\u0d4b" },
            { "ats", "\u0d13\u0d38\u0d4d\u0d1f\u0d4d\u0d30\u0d47\u0d32\u0d3f\u0d2f\u0d7b \u0d37\u0d3f\u0d32\u0d4d\u0d32\u0d3f\u0d02\u0d17\u0d4d" },
            { "aud", "\u0d13\u0d38\u0d4d\u0d1f\u0d4d\u0d30\u0d47\u0d32\u0d3f\u0d2f\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "awg", "\u0d05\u0d31\u0d42\u0d2c\u0d7b \u0d2b\u0d4d\u0d32\u0d4b\u0d31\u0d3f\u0d7b" },
            { "azm", "\u0d05\u0d38\u0d7c\u0d2c\u0d2f\u0d4d\u0d1c\u0d3e\u0d28\u0d3f\u0d2f\u0d7b \u0d2e\u0d28\u0d24\u0d4d (1993\u20132006)" },
            { "azn", "\u0d05\u0d38\u0d7c\u0d2c\u0d48\u0d1c\u0d3e\u0d28\u0d3f \u0d2e\u0d28\u0d24\u0d4d" },
            { "bad", "\u0d2c\u0d4b\u0d38\u0d4d\u0d28\u0d3f\u0d2f-\u0d39\u0d46\u0d7c\u0d38\u0d17\u0d4b\u0d35\u0d3f\u0d28 \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "bam", "\u0d2c\u0d4b\u0d38\u0d4d\u200c\u0d28\u0d3f\u0d2f-\u0d39\u0d46\u0d7c\u0d38\u0d17\u0d4b\u0d35\u0d3f\u0d28 \u0d15\u0d7a\u0d35\u0d47\u0d7c\u0d1f\u0d4d\u0d1f\u0d2c\u0d3f\u0d7e \u0d2e\u0d3e\u0d7c\u0d15\u0d4d\u0d15\u0d4d" },
            { "bbd", "\u0d2c\u0d3e\u0d7c\u0d2c\u0d47\u0d21\u0d3f\u0d2f\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "bdt", "\u0d2c\u0d02\u0d17\u0d4d\u0d32\u0d3e\u0d26\u0d47\u0d36\u0d3f \u0d1f\u0d3e\u0d15\u0d4d\u0d15" },
            { "bec", "\u0d2c\u0d46\u0d7d\u0d1c\u0d3f\u0d2f\u0d7b \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d (\u0d15\u0d48\u0d2e\u0d3e\u0d31\u0d4d\u0d31\u0d02 \u0d1a\u0d46\u0d2f\u0d4d\u0d2f\u0d3e\u0d35\u0d41\u0d28\u0d4d\u0d28\u0d24\u0d4d)" },
            { "bef", "\u0d2c\u0d46\u0d7d\u0d1c\u0d3f\u0d2f\u0d7b \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "bel", "\u0d2c\u0d7d\u0d1c\u0d3f\u0d2f\u0d7b \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "bgl", "\u0d2c\u0d7e\u0d17\u0d47\u0d31\u0d3f\u0d2f\u0d7b \u0d39\u0d3e\u0d7c\u0d21\u0d4d \u0d32\u0d46\u0d35\u0d4d" },
            { "bgn", "\u0d2c\u0d7e\u0d17\u0d47\u0d31\u0d3f\u0d2f\u0d7b \u0d32\u0d46\u0d35\u0d4d" },
            { "bhd", "\u0d2c\u0d39\u0d4d\u0d31\u0d48\u0d28\u0d3f \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "bif", "\u0d2c\u0d31\u0d41\u0d23\u0d4d\u0d1f\u0d3f\u0d2f\u0d7b \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "bmd", "\u0d2c\u0d46\u0d7c\u0d2e\u0d41\u0d21\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "bnd", "\u0d2c\u0d4d\u0d30\u0d42\u0d23\u0d48 \u0d21\u0d4b\u0d33\u0d7c" },
            { "bob", "\u0d2c\u0d4a\u0d33\u0d40\u0d35\u0d3f\u0d2f\u0d7b \u0d2c\u0d4a\u0d33\u0d3f\u0d35\u0d3f\u0d2f\u0d3e\u0d28\u0d4b" },
            { "bop", "\u0d2c\u0d4a\u0d33\u0d40\u0d35\u0d3f\u0d2f\u0d7b \u0d2a\u0d46\u0d2f\u0d4d\u0d38\u0d4b" },
            { "bov", "\u0d2c\u0d4a\u0d33\u0d40\u0d35\u0d3f\u0d2f\u0d7b \u0d0e\u0d02\u0d35\u0d3f\u0d21\u0d4b\u0d7e" },
            { "brb", "\u0d2c\u0d4d\u0d30\u0d38\u0d40\u0d32\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d30\u0d41\u0d38\u0d46\u0d2f\u0d4d\u0d31\u0d4b \u0d28\u0d4b\u0d35\u0d4b (1967\u20131986)" },
            { "brc", "\u0d2c\u0d4d\u0d30\u0d38\u0d40\u0d32\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d30\u0d41\u0d38\u0d3e\u0d21\u0d4b" },
            { "bre", "\u0d2c\u0d4d\u0d30\u0d38\u0d40\u0d32\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d30\u0d41\u0d38\u0d46\u0d2f\u0d4d\u0d31\u0d4b (1990\u20131993)" },
            { "brl", "\u0d2c\u0d4d\u0d30\u0d38\u0d40\u0d32\u0d3f\u0d2f\u0d7b \u0d31\u0d3f\u0d2f\u0d3e\u0d7d" },
            { "brn", "\u0d2c\u0d4d\u0d30\u0d38\u0d40\u0d32\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d30\u0d41\u0d38\u0d3e\u0d21\u0d4b \u0d28\u0d4b\u0d35\u0d4b" },
            { "brr", "\u0d2c\u0d4d\u0d30\u0d38\u0d40\u0d32\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d30\u0d41\u0d38\u0d46\u0d2f\u0d4d\u0d31\u0d4b" },
            { "bsd", "\u0d2c\u0d39\u0d3e\u0d2e\u0d3f\u0d2f\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "btn", "\u0d2d\u0d42\u0d1f\u0d4d\u0d1f\u0d3e\u0d28\u0d40\u0d38\u0d4d \u0d17\u0d7e\u0d1f\u0d4d\u0d30\u0d02" },
            { "buk", "\u0d2c\u0d7c\u0d2e\u0d40\u0d38\u0d4d \u0d1a\u0d3e\u0d31\u0d4d\u0d31\u0d4d" },
            { "bwp", "\u0d2c\u0d4b\u0d1f\u0d4d\u200c\u0d38\u0d4d\u0d35\u0d3e\u0d28\u0d7b \u0d2a\u0d4d\u0d2f\u0d41\u0d32" },
            { "byb", "\u0d2c\u0d46\u0d32\u0d3e\u0d31\u0d37\u0d4d\u0d2f\u0d7b \u0d28\u0d4d\u0d2f\u0d42 \u0d31\u0d42\u0d2c\u0d3f\u0d7e (1994\u20131999)" },
            { "byn", "\u0d2c\u0d46\u0d32\u0d3e\u0d31\u0d41\u0d37\u0d4d\u0d2f\u0d7b \u0d31\u0d42\u0d2c\u0d3f\u0d7e" },
            { "byr", "\u0d2c\u0d46\u0d32\u0d3e\u0d31\u0d41\u0d37\u0d4d\u0d2f\u0d7b \u0d31\u0d42\u0d2c\u0d3f\u0d7e (2000\u20132016)" },
            { "bzd", "\u0d2c\u0d46\u0d32\u0d40\u0d38\u0d4d \u0d21\u0d4b\u0d33\u0d7c" },
            { "cad", "\u0d15\u0d28\u0d47\u0d21\u0d3f\u0d2f\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "cdf", "\u0d15\u0d4b\u0d19\u0d4d\u0d15\u0d33\u0d40\u0d38\u0d4d \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "che", "WIR \u0d2f\u0d42\u0d31\u0d4b" },
            { "chf", "\u0d38\u0d4d\u0d35\u0d3f\u0d38\u0d4d \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "chw", "WIR \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "clf", "\u0d1a\u0d3f\u0d32\u0d3f\u0d2f\u0d7b \u0d2f\u0d42\u0d23\u0d3f\u0d21\u0d3e\u0d21\u0d4d\u0d38\u0d4d \u0d21\u0d3f \u0d2b\u0d4b\u0d2e\u0d46\u0d7b\u0d31\u0d4b" },
            { "clp", "\u0d1a\u0d3f\u0d32\u0d3f\u0d2f\u0d7b \u0d2a\u0d46\u0d38\u0d4b" },
            { "cnh", "\u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d2f\u0d41\u0d35\u0d3e\u0d7b (\u0d13\u0d2b\u0d4d\u200c\u0d37\u0d4b\u0d7c)" },
            { "cny", "\u0d1a\u0d48\u0d28\u0d40\u0d38\u0d4d \u0d2f\u0d41\u0d35\u0d3e\u0d7b" },
            { "cop", "\u0d15\u0d4a\u0d33\u0d02\u0d2c\u0d3f\u0d2f\u0d7b \u0d2a\u0d46\u0d38\u0d4b" },
            { "cou", "\u0d2f\u0d42\u0d23\u0d3f\u0d21\u0d3e\u0d21\u0d4d \u0d21\u0d3f \u0d35\u0d3e\u0d32\u0d7c \u0d31\u0d3f\u0d2f\u0d7d" },
            { "crc", "\u0d15\u0d4b\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d3e \u0d31\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d15\u0d4b\u0d33\u0d7b" },
            { "csd", "\u0d2a\u0d4d\u0d30\u0d3e\u0d1a\u0d40\u0d28 \u0d38\u0d46\u0d7c\u0d2c\u0d3f\u0d2f\u0d7b \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "csk", "\u0d1a\u0d46\u0d15\u0d4d\u0d15\u0d4b\u0d38\u0d4d\u0d32\u0d4a\u0d35\u0d3e\u0d15\u0d4d\u0d15\u0d4d \u0d39\u0d3e\u0d7c\u0d21\u0d4d \u0d15\u0d4a\u0d30\u0d42\u0d28" },
            { "cuc", "\u0d15\u0d4d\u0d2f\u0d42\u0d2c\u0d7b \u0d15\u0d7a\u0d35\u0d47\u0d7c\u0d1f\u0d4d\u0d1f\u0d2c\u0d3f\u0d7e \u0d2a\u0d46\u0d38\u0d4b" },
            { "cup", "\u0d15\u0d4d\u0d2f\u0d42\u0d2c\u0d7b \u0d2a\u0d46\u0d38\u0d4b" },
            { "cve", "\u0d15\u0d47\u0d2a\u0d4d \u0d35\u0d46\u0d7c\u0d26\u0d3f\u0d2f\u0d7b \u0d0e\u0d38\u0d4d\u200c\u0d15\u0d4d\u0d2f\u0d41\u0d21\u0d4b" },
            { "cyp", "\u0d38\u0d48\u0d2a\u0d4d\u0d30\u0d38\u0d4d \u0d2a\u0d4c\u0d23\u0d4d\u0d1f\u0d4d" },
            { "czk", "\u0d1a\u0d46\u0d15\u0d4d\u0d15\u0d4d \u0d31\u0d3f\u0d2a\u0d4d\u0d2a\u0d2c\u0d4d\u0d32\u0d3f\u0d15\u0d4d \u0d15\u0d4a\u0d30\u0d41\u0d23" },
            { "ddm", "\u0d15\u0d3f\u0d34\u0d15\u0d4d\u0d15\u0d7b \u0d1c\u0d7c\u0d2e\u0d7b \u0d13\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4d\u0d2e\u0d3e\u0d7c\u0d15\u0d4d\u0d15\u0d4d" },
            { "dem", "\u0d1c\u0d7c\u0d2e\u0d7b \u0d2e\u0d3e\u0d7c\u0d15\u0d4d\u0d15\u0d4d" },
            { "djf", "\u0d26\u0d3f\u0d1c\u0d3f\u0d2c\u0d57\u0d1f\u0d4d\u0d1f\u0d3f\u0d2f\u0d7b \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "dkk", "\u0d21\u0d3e\u0d28\u0d3f\u0d37\u0d4d \u0d15\u0d4d\u0d30\u0d4b\u0d23\u0d46" },
            { "dop", "\u0d21\u0d4a\u0d2e\u0d3f\u0d28\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d2a\u0d46\u0d38\u0d4b" },
            { "dzd", "\u0d05\u0d7e\u0d1c\u0d40\u0d30\u0d3f\u0d2f\u0d7b \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "ecs", "\u0d07\u0d15\u0d4d\u0d35\u0d21\u0d4b\u0d7c \u0d38\u0d42\u0d15\u0d4d\u0d30\u0d47" },
            { "ecv", "\u0d07\u0d15\u0d4d\u0d35\u0d21\u0d4b\u0d7c \u0d2f\u0d42\u0d23\u0d3f\u0d21\u0d3e\u0d21\u0d4d \u0d35\u0d3e\u0d32\u0d7c \u0d15\u0d4b\u0d7a\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d7b\u0d31\u0d46 (UVC)" },
            { "eek", "\u0d0e\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4c\u0d28\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d30\u0d42\u0d7a" },
            { "egp", "\u0d08\u0d1c\u0d3f\u0d2a\u0d4d\u200c\u0d37\u0d4d\u0d2f\u0d7b \u0d2a\u0d57\u0d23\u0d4d\u0d1f\u0d4d" },
            { "ern", "\u0d0e\u0d31\u0d3f\u0d24\u0d4d\u0d30\u0d3f\u0d2f\u0d7b \u0d28\u0d15\u0d4d\u0d2b" },
            { "esa", "\u0d38\u0d4d\u0d2a\u0d3e\u0d28\u0d3f\u0d37\u0d4d \u0d2a\u0d38\u0d46\u0d2f\u0d4d\u0d31\u0d4d\u0d31 (A \u0d05\u0d15\u0d4d\u0d15\u0d4c\u0d23\u0d4d\u0d1f\u0d4d)" },
            { "esb", "\u0d38\u0d4d\u0d2a\u0d3e\u0d28\u0d3f\u0d37\u0d4d \u0d2a\u0d38\u0d46\u0d2f\u0d4d\u0d31\u0d4d\u0d31 (\u0d15\u0d48\u0d2e\u0d3e\u0d31\u0d4d\u0d31\u0d02 \u0d1a\u0d46\u0d2f\u0d4d\u0d2f\u0d3e\u0d35\u0d41\u0d28\u0d4d\u0d28 \u0d05\u0d15\u0d4d\u0d15\u0d4c\u0d23\u0d4d\u0d1f\u0d4d)" },
            { "esp", "\u0d38\u0d4d\u0d2a\u0d3e\u0d28\u0d3f\u0d37\u0d4d \u0d2a\u0d38\u0d46\u0d2f\u0d4d\u0d31\u0d4d\u0d31" },
            { "etb", "\u0d0e\u0d24\u0d4d\u0d2f\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d2c\u0d3f\u0d7c" },
            { "eur", "\u0d2f\u0d42\u0d31\u0d4b" },
            { "fim", "\u0d2b\u0d3f\u0d28\u0d4d\u0d28\u0d3f\u0d37\u0d4d \u0d2e\u0d3e\u0d7c\u0d15\u0d4d\u0d15" },
            { "fjd", "\u0d2b\u0d3f\u0d1c\u0d3f\u0d2f\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "fkp", "\u0d2b\u0d3e\u0d15\u0d4d\u0d15\u0d4d\u200c\u0d32\u0d3e\u0d28\u0d4d\u0d31\u0d4d \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d33\u0d41\u0d1f\u0d46 \u0d2a\u0d57\u0d23\u0d4d\u0d1f\u0d4d" },
            { "frf", "\u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "gbp", "\u0d2c\u0d4d\u0d30\u0d3f\u0d1f\u0d4d\u0d1f\u0d40\u0d37\u0d4d \u0d2a\u0d57\u0d23\u0d4d\u0d1f\u0d4d" },
            { "gek", "\u0d1c\u0d4b\u0d7c\u200d\u0d1c\u0d4d\u0d1c\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d2f\u0d42\u0d2a\u0d4b\u0d7a \u0d32\u0d3e\u0d30\u0d3f\u0d31\u0d4d\u0d31\u0d4d" },
            { "gel", "\u0d1c\u0d4b\u0d7c\u0d1c\u0d4d\u0d1c\u0d3f\u0d2f\u0d7b \u0d32\u0d3e\u0d31\u0d3f" },
            { "ghc", "\u0d18\u0d3e\u0d28 \u0d15\u0d46\u0d21\u0d3f (1979\u20132007)" },
            { "ghs", "\u0d18\u0d3e\u0d28\u0d2f\u0d7b \u0d15\u0d46\u0d21\u0d3f" },
            { "gip", "\u0d1c\u0d3f\u0d2c\u0d4d\u0d30\u0d3e\u0d7e\u0d1f\u0d4d\u0d1f\u0d7c \u0d2a\u0d57\u0d23\u0d4d\u0d1f\u0d4d" },
            { "gmd", "\u0d17\u0d3e\u0d02\u0d2c\u0d3f\u0d2f\u0d7b \u0d26\u0d32\u0d3e\u0d38\u0d3f" },
            { "gnf", "\u0d17\u0d3f\u0d28\u0d3f\u0d2f\u0d7b \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "gns", "\u0d17\u0d3f\u0d28\u0d3f\u0d2f \u0d38\u0d48\u0d32\u0d3f" },
            { "gqe", "\u0d07\u0d15\u0d4d\u0d35\u0d3f\u0d31\u0d4d\u0d31\u0d4b\u0d31\u0d3f\u0d2f\u0d7d \u0d17\u0d3f\u0d28\u0d3f\u0d2f \u0d0e\u0d15\u0d4d\u0d35\u0d40\u0d32\u0d46 \u0d17\u0d3f\u0d28\u0d3f\u0d2f\u0d3e\u0d28" },
            { "grd", "\u0d17\u0d4d\u0d30\u0d40\u0d15\u0d4d\u0d15\u0d4d \u0d21\u0d4d\u0d30\u0d3e\u0d15\u0d4d\u0d15\u0d4d\u0d2e" },
            { "gtq", "\u0d17\u0d4d\u0d35\u0d3e\u0d1f\u0d4d\u0d1f\u0d3f\u0d2e\u0d3e\u0d32\u0d7b \u0d15\u0d4d\u0d35\u0d46\u0d31\u0d4d\u0d31\u0d4d\u200c\u0d38\u0d7d" },
            { "gwe", "\u0d2a\u0d4b\u0d7c\u0d1a\u0d4d\u0d1a\u0d41\u0d17\u0d40\u0d38\u0d4d \u0d17\u0d3f\u0d28\u0d3f \u0d0e\u0d38\u0d4d\u0d15\u0d4d\u0d2f\u0d42\u0d21\u0d4b" },
            { "gwp", "\u0d17\u0d3f\u0d28\u0d3f\u0d2f-\u0d2c\u0d3f\u0d38\u0d3e\u0d35\u0d41 \u0d2a\u0d46\u0d2f\u0d4d\u0d38\u0d4b" },
            { "gyd", "\u0d17\u0d2f\u0d3e\u0d28\u0d40\u0d38\u0d4d \u0d21\u0d4b\u0d33\u0d7c" },
            { "hkd", "\u0d39\u0d4b\u0d19\u0d4d\u0d15\u0d4b\u0d19\u0d4d\u0d19\u0d4d \u0d21\u0d4b\u0d33\u0d7c" },
            { "hnl", "\u0d39\u0d4b\u0d23\u0d4d\u0d1f\u0d41\u0d31\u0d7b \u0d32\u0d46\u0d02\u0d2a\u0d3f\u0d31" },
            { "hrd", "\u0d15\u0d4d\u0d30\u0d4a\u0d2f\u0d47\u0d37\u0d4d\u0d2f\u0d7b \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "hrk", "\u0d15\u0d4d\u0d30\u0d4a\u0d2f\u0d47\u0d37\u0d7b \u0d15\u0d4d\u0d2f\u0d41\u0d28" },
            { "htg", "\u0d39\u0d46\u0d2f\u0d4d\u200c\u0d24\u0d3f\u0d2f\u0d7b \u0d17\u0d42\u0d7c\u0d21\u0d4d" },
            { "huf", "\u0d39\u0d02\u0d17\u0d47\u0d31\u0d3f\u0d2f\u0d7b \u0d2b\u0d4b\u0d31\u0d3f\u0d28\u0d4d\u0d31\u0d4d" },
            { "idr", "\u0d07\u0d28\u0d4d\u0d24\u0d4b\u0d28\u0d47\u0d37\u0d4d\u0d2f\u0d7b \u0d31\u0d41\u0d2a\u0d3f\u0d2f" },
            { "iep", "\u0d10\u0d31\u0d3f\u0d37\u0d4d \u0d2a\u0d4c\u0d23\u0d4d\u0d1f\u0d4d" },
            { "ilp", "\u0d07\u0d38\u0d4d\u0d30\u0d2f\u0d47\u0d32\u0d3f \u0d2a\u0d4c\u0d23\u0d4d\u0d1f\u0d4d" },
            { "ils", "\u0d07\u0d38\u0d4d\u0d30\u0d3e\u0d2f\u0d47\u0d32\u0d3f \u0d28\u0d4d\u0d2f\u0d42 \u0d37\u0d46\u0d15\u0d4d\u0d15\u0d46\u0d7d" },
            { "inr", "\u0d07\u0d28\u0d4d\u0d24\u0d4d\u0d2f\u0d7b \u0d30\u0d42\u0d2a" },
            { "iqd", "\u0d07\u0d31\u0d3e\u0d16\u0d3f \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "irr", "\u0d07\u0d31\u0d3e\u0d28\u0d3f\u0d2f\u0d7b \u0d31\u0d3f\u0d2f\u0d3e\u0d7d" },
            { "isk", "\u0d10\u0d38\u0d4d\u200c\u0d32\u0d3e\u0d7b\u0d21\u0d3f\u0d15\u0d4d \u0d15\u0d4d\u0d30\u0d4b\u0d23" },
            { "itl", "\u0d07\u0d31\u0d4d\u0d31\u0d3e\u0d32\u0d3f\u0d2f\u0d7b \u0d32\u0d3f\u0d31" },
            { "jmd", "\u0d1c\u0d2e\u0d48\u0d15\u0d4d\u0d15\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "jod", "\u0d1c\u0d4b\u0d7c\u0d26\u0d4d\u0d26\u0d3e\u0d28\u0d3f\u0d2f\u0d7b \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "jpy", "\u0d1c\u0d3e\u0d2a\u0d4d\u0d2a\u0d28\u0d40\u0d38\u0d4d \u0d2f\u0d46\u0d7b" },
            { "kes", "\u0d15\u0d46\u0d28\u0d3f\u0d2f\u0d7b \u0d37\u0d3f\u0d32\u0d4d\u0d32\u0d3f\u0d02\u0d17\u0d4d" },
            { "kgs", "\u0d15\u0d3f\u0d7c\u0d17\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d28\u0d3f \u0d38\u0d4b\u0d02" },
            { "khr", "\u0d15\u0d02\u0d2c\u0d4b\u0d21\u0d3f\u0d2f\u0d7b \u0d31\u0d40\u0d7d" },
            { "kmf", "\u0d15\u0d4a\u0d2e\u0d4b\u0d31\u0d3f\u0d2f\u0d7b \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "kpw", "\u0d09\u0d24\u0d4d\u0d24\u0d30 \u0d15\u0d4a\u0d31\u0d3f\u0d2f\u0d7b \u0d35\u0d4b\u0d7a" },
            { "krw", "\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d15\u0d4a\u0d31\u0d3f\u0d2f\u0d7b \u0d35\u0d4b\u0d7a" },
            { "kwd", "\u0d15\u0d41\u0d35\u0d48\u0d31\u0d4d\u0d31\u0d3f \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "kyd", "\u0d15\u0d47\u0d2e\u0d3e\u0d7b \u0d10\u0d32\u0d7b\u0d21\u0d4d\u200c\u0d38\u0d4d \u0d21\u0d4b\u0d33\u0d7c" },
            { "kzt", "\u0d15\u0d38\u0d3e\u0d15\u0d4d\u0d15\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d28\u0d3f \u0d1f\u0d46\u0d02\u0d17\u0d46" },
            { "lak", "\u0d32\u0d3e\u0d35\u0d4b\u0d37\u0d3f\u0d2f\u0d7b \u0d15\u0d3f\u0d2a\u0d4d" },
            { "lbp", "\u0d32\u0d46\u0d2c\u0d28\u0d40\u0d38\u0d4d \u0d2a\u0d57\u0d23\u0d4d\u0d1f\u0d4d" },
            { "lkr", "\u0d36\u0d4d\u0d30\u0d40\u0d32\u0d19\u0d4d\u0d15\u0d7b \u0d31\u0d41\u0d2a\u0d4d\u0d2a\u0d40" },
            { "lrd", "\u0d32\u0d48\u0d2c\u0d40\u0d30\u0d3f\u0d2f\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "lsl", "\u0d32\u0d46\u0d38\u0d4b\u0d24\u0d4b \u0d32\u0d4b\u0d24\u0d4d\u0d24\u0d3f" },
            { "ltl", "\u0d32\u0d3f\u0d24\u0d4d\u0d35\u0d3e\u0d28\u0d3f\u0d2f\u0d7b \u0d32\u0d3f\u0d31\u0d4d\u0d31\u0d3e\u0d38\u0d4d" },
            { "ltt", "\u0d32\u0d3f\u0d24\u0d4d\u0d35\u0d3e\u0d28\u0d3f\u0d2f\u0d7b \u0d24\u0d32\u0d4b\u0d28\u0d3e\u0d38\u0d4d" },
            { "luc", "\u0d32\u0d15\u0d4d\u0d38\u0d02\u0d2c\u0d7c\u0d17\u0d4d \u0d15\u0d7a\u0d35\u0d47\u0d7c\u0d1f\u0d4d\u0d1f\u0d3f\u0d2c\u0d3f\u0d7e \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "luf", "\u0d32\u0d15\u0d4d\u0d38\u0d02\u0d2c\u0d7c\u0d17\u0d4d \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "lul", "\u0d32\u0d15\u0d4d\u0d38\u0d02\u0d2c\u0d7c\u0d17\u0d4d \u0d2b\u0d3f\u0d28\u0d3e\u0d7b\u0d37\u0d4d\u0d2f\u0d7d \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "lvl", "\u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d4d\u0d35\u0d3f\u0d2f\u0d7b \u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d4d\u0d38\u0d4d" },
            { "lvr", "\u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d4d\u0d35\u0d3f\u0d2f\u0d7b \u0d31\u0d42\u0d2c\u0d3f\u0d7e" },
            { "lyd", "\u0d32\u0d3f\u0d2c\u0d3f\u0d2f\u0d7b \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "mad", "\u0d2e\u0d4a\u0d31\u0d4b\u0d15\u0d4d\u0d15\u0d7b \u0d26\u0d3f\u0d7c\u0d39\u0d02" },
            { "maf", "\u0d2e\u0d4a\u0d31\u0d4b\u0d15\u0d4d\u0d15\u0d7b \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "mdl", "\u0d2e\u0d4a\u0d7e\u0d21\u0d4b\u0d35\u0d7b \u0d32\u0d3f\u0d2f\u0d41" },
            { "mga", "\u0d2e\u0d21\u0d17\u0d3e\u0d38\u0d3f \u0d0f\u0d30\u0d3f\u0d2f\u0d31\u0d3f" },
            { "mgf", "\u0d2e\u0d21\u0d17\u0d3e\u0d38\u0d4d\u0d15\u0d7c \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "mkd", "\u0d2e\u0d3e\u0d38\u0d3f\u0d21\u0d4b\u0d23\u0d3f\u0d2f\u0d7b \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "mlf", "\u0d2e\u0d3e\u0d32\u0d3f \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "mmk", "\u0d2e\u0d4d\u0d2f\u0d3e\u0d7b\u0d2e\u0d3e\u0d7c \u0d15\u0d4d\u0d2f\u0d3e\u0d1f\u0d4d" },
            { "mnt", "\u0d2e\u0d02\u0d17\u0d4b\u0d33\u0d3f\u0d2f\u0d7b \u0d24\u0d41\u0d17\u0d4d\u0d30\u0d3f\u0d15\u0d4d" },
            { "mop", "\u0d2e\u0d15\u0d3e\u0d28\u0d40\u0d38\u0d4d \u0d2a\u0d24\u0d3e\u0d15\u0d4d\u0d15" },
            { "mro", "\u0d2e\u0d57\u0d31\u0d3f\u0d31\u0d4d\u0d31\u0d47\u0d28\u0d3f\u0d2f\u0d7b \u0d14\u0d17\u0d3f\u0d2f (1973\u20132017)" },
            { "mru", "\u0d2e\u0d57\u0d31\u0d3f\u0d31\u0d4d\u0d31\u0d47\u0d28\u0d3f\u0d2f\u0d7b \u0d14\u0d17\u0d3f\u0d2f" },
            { "mtl", "\u0d2e\u0d7d\u0d24\u0d4d\u0d24\u0d40\u0d38\u0d4d \u0d32\u0d3f\u0d31" },
            { "mtp", "\u0d2e\u0d7d\u0d24\u0d4d\u0d24\u0d40\u0d38\u0d4d \u0d2a\u0d4c\u0d23\u0d4d\u0d1f\u0d4d" },
            { "mur", "\u0d2e\u0d57\u0d31\u0d40\u0d37\u0d4d\u0d2f\u0d7b \u0d31\u0d41\u0d2a\u0d4d\u0d2a\u0d40" },
            { "mvr", "\u0d2e\u0d3e\u0d7d\u0d26\u0d40\u0d35\u0d3f\u0d2f\u0d7b \u0d31\u0d41\u0d2b\u0d3f\u0d2f" },
            { "mwk", "\u0d2e\u0d32\u0d3e\u0d35\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d35\u0d1a\u0d4d\u0d1a\u0d3e" },
            { "mxn", "\u0d2e\u0d46\u0d15\u0d4d\u0d38\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d2a\u0d46\u0d38\u0d4b" },
            { "mxp", "\u0d2e\u0d46\u0d15\u0d4d\u0d38\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d38\u0d3f\u0d7d\u0d35\u0d7c \u0d2a\u0d46\u0d2f\u0d4d\u0d38\u0d4b (1861\u20131992)" },
            { "mxv", "\u0d2e\u0d46\u0d15\u0d4d\u0d38\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d2f\u0d42\u0d23\u0d3f\u0d21\u0d3e\u0d21\u0d4d \u0d21\u0d3f \u0d07\u0d7b\u0d35\u0d46\u0d7c\u0d37\u0d7b (UDI)" },
            { "myr", "\u0d2e\u0d32\u0d47\u0d37\u0d4d\u0d2f\u0d7b \u0d31\u0d3f\u0d02\u0d17\u0d3f\u0d31\u0d4d\u0d31\u0d4d" },
            { "mze", "\u0d2e\u0d4a\u0d38\u0d3e\u0d28\u0d4d\u0d2a\u0d3f\u0d15\u0d4d\u0d15\u0d4d \u0d0e\u0d38\u0d4d\u0d15\u0d4d\u0d2f\u0d41\u0d21\u0d4b" },
            { "mzm", "\u0d13\u0d7e\u0d21\u0d4d \u0d2e\u0d4a\u0d38\u0d3e\u0d28\u0d4d\u0d2a\u0d3f\u0d15\u0d4d\u0d15\u0d4d \u0d2e\u0d46\u0d31\u0d4d\u0d31\u0d3f\u0d15\u0d4d\u0d15\u0d7d" },
            { "mzn", "\u0d2e\u0d4a\u0d38\u0d3e\u0d02\u0d2c\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d2e\u0d46\u0d31\u0d4d\u0d31\u0d3f\u0d15\u0d4d\u0d15\u0d7d" },
            { "nad", "\u0d28\u0d2e\u0d40\u0d2c\u0d3f\u0d2f\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "ngn", "\u0d28\u0d48\u0d1c\u0d40\u0d30\u0d3f\u0d2f\u0d7b \u0d28\u0d48\u0d31" },
            { "nic", "\u0d28\u0d3f\u0d15\u0d30\u0d3e\u0d17\u0d4d\u0d35\u0d7b \u0d15\u0d4a\u0d7c\u0d21\u0d4b\u0d2c" },
            { "nio", "\u0d28\u0d3f\u0d15\u0d4d\u0d15\u0d30\u0d3e\u0d17\u0d4d\u0d35\u0d7b \u0d15\u0d4b\u0d7c\u0d21\u0d4b\u0d2c" },
            { "nlg", "\u0d28\u0d46\u0d24\u0d7c\u0d32\u0d7b\u0d21\u0d4d\u0d38\u0d4d \u0d17\u0d3f\u0d7d\u0d21\u0d7c" },
            { "nok", "\u0d28\u0d4b\u0d7c\u0d35\u0d40\u0d1c\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d30\u0d4b\u0d23\u0d46" },
            { "npr", "\u0d28\u0d47\u0d2a\u0d4d\u0d2a\u0d3e\u0d33\u0d40\u0d38\u0d4d \u0d31\u0d41\u0d2a\u0d4d\u0d2a\u0d40" },
            { "nzd", "\u0d28\u0d4d\u0d2f\u0d42\u0d38\u0d3f\u0d32\u0d3e\u0d28\u0d4d\u0d31\u0d4d \u0d21\u0d4b\u0d33\u0d7c" },
            { "omr", "\u0d12\u0d2e\u0d3e\u0d28\u0d3f \u0d31\u0d3f\u0d2f\u0d3e\u0d7d" },
            { "pab", "\u0d2a\u0d28\u0d3e\u0d2e\u0d28\u0d3f\u0d2f\u0d7b \u0d2c\u0d3e\u0d7d\u0d2c\u0d4b\u0d35" },
            { "pei", "\u0d2a\u0d46\u0d31\u0d42\u0d35\u0d3f\u0d2f\u0d7b \u0d07\u0d7b\u0d31\u0d3f" },
            { "pen", "\u0d2a\u0d46\u0d31\u0d41\u0d35\u0d3f\u0d2f\u0d7b \u0d38\u0d4b\u0d7e" },
            { "pes", "\u0d2a\u0d46\u0d31\u0d42\u0d35\u0d3f\u0d2f\u0d7b \u0d38\u0d4b\u0d7e (1863\u20131965)" },
            { "pgk", "\u0d2a\u0d3e\u0d2a\u0d4d\u0d2a\u0d41\u0d35 \u0d28\u0d4d\u0d2f\u0d42 \u0d17\u0d3f\u0d28\u0d3f\u0d2f\u0d7b \u0d15\u0d3f\u0d28" },
            { "php", "\u0d2b\u0d3f\u0d32\u0d3f\u0d2a\u0d4d\u0d2a\u0d40\u0d28\u0d3f \u0d2a\u0d46\u0d38\u0d4b" },
            { "pkr", "\u0d2a\u0d3e\u0d15\u0d4d\u0d15\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d28\u0d3f \u0d31\u0d41\u0d2a\u0d4d\u0d2a\u0d40" },
            { "pln", "\u0d2a\u0d4b\u0d33\u0d3f\u0d37\u0d4d \u0d38\u0d4d\u0d32\u0d4b\u0d1f\u0d4d\u0d1f\u0d3f" },
            { "plz", "\u0d2a\u0d4b\u0d33\u0d3f\u0d37\u0d4d \u0d38\u0d4d\u0d32\u0d4b\u0d1f\u0d4d\u0d1f\u0d3f (1950\u20131995)" },
            { "pte", "\u0d2a\u0d4b\u0d7c\u0d1a\u0d4d\u0d1a\u0d41\u0d17\u0d40\u0d38\u0d4d \u0d0e\u0d38\u0d4d\u0d15\u0d4d\u0d2f\u0d41\u0d21\u0d4b" },
            { "pyg", "\u0d2a\u0d30\u0d3e\u0d17\u0d4d\u0d35\u0d47\u0d2f\u0d7b \u0d17\u0d4d\u0d35\u0d30\u0d28\u0d40" },
            { "qar", "\u0d16\u0d24\u0d4d\u0d24\u0d7c \u0d31\u0d3f\u0d2f\u0d3e\u0d7d" },
            { "rhd", "\u0d31\u0d4a\u0d21\u0d47\u0d37\u0d4d\u0d2f\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "rol", "\u0d2a\u0d4d\u0d30\u0d3e\u0d1a\u0d40\u0d28 \u0d31\u0d4a\u0d2e\u0d47\u0d28\u0d3f\u0d2f\u0d7b \u0d32\u0d3f\u0d2f\u0d41" },
            { "ron", "\u0d31\u0d4a\u0d2e\u0d3e\u0d28\u0d3f\u0d2f\u0d7b \u0d32\u0d46\u0d2f\u0d41" },
            { "rsd", "\u0d38\u0d46\u0d7c\u0d2c\u0d3f\u0d2f\u0d7b \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "rub", "\u0d31\u0d37\u0d4d\u0d2f\u0d7b \u0d31\u0d42\u0d2c\u0d3f\u0d7e" },
            { "rur", "\u0d31\u0d37\u0d4d\u0d2f\u0d7b \u0d31\u0d42\u0d2c\u0d3f\u0d7e (1991\u20131998)" },
            { "rwf", "\u0d31\u0d41\u0d35\u0d3e\u0d23\u0d4d\u0d1f\u0d7b \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "sar", "\u0d38\u0d57\u0d26\u0d3f \u0d31\u0d3f\u0d2f\u0d3e\u0d7d" },
            { "sbd", "\u0d38\u0d4b\u0d33\u0d2e\u0d7b \u0d26\u0d4d\u0d35\u0d40\u0d2a\u0d41\u0d15\u0d33\u0d41\u0d1f\u0d46 \u0d21\u0d4b\u0d33\u0d7c" },
            { "scr", "\u0d38\u0d40\u0d37\u0d46\u0d32\u0d4b\u0d2f\u0d3f\u0d38\u0d4d \u0d31\u0d41\u0d2a\u0d4d\u0d2a\u0d40" },
            { "sdd", "\u0d2a\u0d4d\u0d30\u0d3e\u0d1a\u0d40\u0d28 \u0d38\u0d41\u0d21\u0d3e\u0d28\u0d40\u0d38\u0d4d \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "sdg", "\u0d38\u0d41\u0d21\u0d3e\u0d28\u0d40\u0d38\u0d4d \u0d2a\u0d57\u0d23\u0d4d\u0d1f\u0d4d" },
            { "sdp", "\u0d2a\u0d4d\u0d30\u0d3e\u0d1a\u0d40\u0d28 \u0d38\u0d41\u0d21\u0d3e\u0d28\u0d40\u0d38\u0d4d \u0d2a\u0d4c\u0d23\u0d4d\u0d1f\u0d4d" },
            { "sek", "\u0d38\u0d4d\u0d35\u0d40\u0d21\u0d3f\u0d37\u0d4d \u0d15\u0d4d\u0d30\u0d4b\u0d23" },
            { "sgd", "\u0d38\u0d3f\u0d02\u0d17\u0d2a\u0d4d\u0d2a\u0d42\u0d7c \u0d21\u0d4b\u0d33\u0d7c" },
            { "shp", "\u0d38\u0d46\u0d28\u0d4d\u0d31\u0d4d \u0d39\u0d46\u0d32\u0d40\u0d28 \u0d2a\u0d57\u0d23\u0d4d\u0d1f\u0d4d" },
            { "sit", "\u0d38\u0d4d\u0d32\u0d4a\u0d35\u0d47\u0d28\u0d3f\u0d2f \u0d31\u0d4d\u0d31\u0d4b\u0d33\u0d7c" },
            { "skk", "\u0d38\u0d4d\u0d32\u0d4b\u0d35\u0d3e\u0d15\u0d4d \u0d15\u0d4a\u0d30\u0d42\u0d28" },
            { "sll", "\u0d38\u0d3f\u0d2f\u0d46\u0d31 \u0d32\u0d3f\u0d2f\u0d4b\u0d23\u0d3f\u0d2f\u0d7b \u0d32\u0d3f\u0d2f\u0d4b\u0d7a" },
            { "sos", "\u0d38\u0d4b\u0d2e\u0d3e\u0d32\u0d3f \u0d37\u0d3f\u0d32\u0d4d\u0d32\u0d3f\u0d02\u0d17\u0d4d" },
            { "srd", "\u0d38\u0d41\u0d30\u0d3f\u0d28\u0d46\u0d2f\u0d3f\u0d2e\u0d3f\u0d38\u0d4d \u0d21\u0d4b\u0d33\u0d7c" },
            { "srg", "\u0d38\u0d42\u0d30\u0d3f\u0d28\u0d3e\u0d02 \u0d17\u0d3f\u0d7d\u0d21\u0d7c" },
            { "ssp", "\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23 \u0d38\u0d41\u0d21\u0d3e\u0d28\u0d40\u0d38\u0d4d \u0d2a\u0d57\u0d23\u0d4d\u0d1f\u0d4d" },
            { "std", "\u0d38\u0d3e\u0d35\u0d4b \u0d1f\u0d4b\u0d2e\u0d3f \u0d06\u0d7b\u0d21\u0d4d \u0d2a\u0d4d\u0d30\u0d3f\u0d7b\u0d38\u0d3f\u0d2a\u0d46 \u0d21\u0d4b\u0d2c\u0d4d\u0d30 (1977\u20132017)" },
            { "stn", "\u0d38\u0d3e\u0d35\u0d4b \u0d1f\u0d4b\u0d2e\u0d3f \u0d06\u0d7b\u0d21\u0d4d \u0d2a\u0d4d\u0d30\u0d3f\u0d7b\u0d38\u0d3f\u0d2a\u0d46 \u0d21\u0d4b\u0d2c\u0d4d\u0d30" },
            { "sur", "\u0d38\u0d4b\u0d35\u0d3f\u0d2f\u0d31\u0d4d\u0d31\u0d4d \u0d31\u0d42\u0d2c\u0d3f\u0d7e" },
            { "svc", "\u0d0e\u0d7d \u0d38\u0d3e\u0d7d\u0d35\u0d21\u0d4b\u0d7c \u0d15\u0d4b\u0d33\u0d7b" },
            { "syp", "\u0d38\u0d3f\u0d31\u0d3f\u0d2f\u0d7b \u0d2a\u0d57\u0d23\u0d4d\u0d1f\u0d4d" },
            { "szl", "\u0d38\u0d4d\u0d35\u0d3e\u0d38\u0d3f \u0d32\u0d3f\u0d32\u0d3e\u0d02\u0d17\u0d28\u0d3f" },
            { "thb", "\u0d24\u0d3e\u0d2f\u0d4d \u0d2c\u0d1f\u0d4d\u0d1f\u0d4d" },
            { "tjr", "\u0d24\u0d3e\u0d1c\u0d3f\u0d15\u0d4d\u0d15\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b \u0d31\u0d42\u0d2c\u0d3f\u0d7e" },
            { "tjs", "\u0d24\u0d3e\u0d1c\u0d3f\u0d15\u0d4d\u0d15\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d28\u0d3f \u0d38\u0d4b\u0d02\u0d28\u0d3f" },
            { "tmm", "\u0d24\u0d41\u0d7c\u0d15\u0d4d\u0d2e\u0d46\u0d28\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d7b \u0d2e\u0d28\u0d24\u0d4d" },
            { "tmt", "\u0d24\u0d41\u0d7c\u0d15\u0d4d\u0d15\u0d4d\u200c\u0d2e\u0d46\u0d28\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d28\u0d3f \u0d2e\u0d28\u0d24\u0d4d" },
            { "tnd", "\u0d1f\u0d41\u0d23\u0d40\u0d37\u0d4d\u0d2f\u0d7b \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "top", "\u0d1f\u0d4b\u0d02\u0d17\u0d7b \u0d2a\u0d3e\u0d02\u0d17" },
            { "tpe", "\u0d24\u0d3f\u0d2e\u0d4b\u0d7c \u0d0e\u0d38\u0d4d\u0d15\u0d4d\u0d2f\u0d42\u0d21\u0d4b" },
            { "trl", "\u0d2a\u0d4d\u0d30\u0d3e\u0d1a\u0d40\u0d28 \u0d24\u0d41\u0d7c\u0d15\u0d4d\u0d15\u0d3f\u0d37\u0d4d \u0d32\u0d3f\u0d31" },
            { "try", "\u0d1f\u0d7c\u0d15\u0d4d\u0d15\u0d3f\u0d37\u0d4d \u0d32\u0d3f\u0d31" },
            { "ttd", "\u0d1f\u0d4d\u0d30\u0d3f\u0d28\u0d3f\u0d21\u0d3e\u0d21\u0d4d \u0d05\u0d28\u0d4d\u0d31\u0d4d \u0d1f\u0d41\u0d2c\u0d3e\u0d17\u0d4b \u0d21\u0d4b\u0d33\u0d7c" },
            { "twd", "\u0d28\u0d4d\u0d2f\u0d42 \u0d24\u0d3e\u0d2f\u0d4d\u200c\u0d35\u0d3e\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "tzs", "\u0d1f\u0d3e\u0d7b\u0d38\u0d3e\u0d28\u0d3f\u0d2f\u0d7b \u0d37\u0d3f\u0d32\u0d4d\u0d32\u0d3f\u0d02\u0d17\u0d4d" },
            { "uah", "\u0d09\u0d15\u0d4d\u0d30\u0d47\u0d28\u0d3f\u0d2f\u0d7b \u0d39\u0d4d\u0d30\u0d3f\u0d35\u0d4d\u200c\u0d28\u0d3f\u0d2f" },
            { "uak", "\u0d2f\u0d41\u0d15\u0d4d\u0d30\u0d47\u0d28\u0d3f\u0d2f\u0d7b \u0d15\u0d3e\u0d7c\u0d2c\u0d4b\u0d35\u0d3e\u0d28\u0d46\u0d38\u0d4d" },
            { "ugs", "\u0d09\u0d17\u0d3e\u0d23\u0d4d\u0d1f\u0d7b \u0d37\u0d3f\u0d32\u0d4d\u0d32\u0d3f\u0d02\u0d17\u0d4d (1966\u20131987)" },
            { "ugx", "\u0d09\u0d17\u0d3e\u0d23\u0d4d\u0d1f\u0d7b \u0d37\u0d3f\u0d32\u0d4d\u0d32\u0d3f\u0d02\u0d17\u0d4d" },
            { "usd", "\u0d2f\u0d41.\u0d0e\u0d38\u0d4d. \u0d21\u0d4b\u0d33\u0d7c" },
            { "usn", "\u0d2f\u0d41\u0d0e\u0d38\u0d4d \u0d21\u0d4b\u0d33\u0d7c (\u0d05\u0d1f\u0d41\u0d24\u0d4d\u0d24 \u0d26\u0d3f\u0d35\u0d38\u0d02)" },
            { "uss", "\u0d2f\u0d41\u0d0e\u0d38\u0d4d \u0d21\u0d4b\u0d33\u0d7c (\u0d05\u0d24\u0d47 \u0d26\u0d3f\u0d35\u0d38\u0d02)" },
            { "uyi", "\u0d09\u0d31\u0d41\u0d17\u0d4d\u0d35\u0d47 \u0d2a\u0d46\u0d2f\u0d4d\u0d38\u0d4b \u0d0e\u0d7b \u0d2f\u0d42\u0d23\u0d3f\u0d21\u0d3e\u0d21\u0d4d\u0d38\u0d4d" },
            { "uyp", "\u0d09\u0d31\u0d41\u0d17\u0d4d\u0d35\u0d47 \u0d2a\u0d46\u0d2f\u0d4d\u0d38\u0d4b (1975\u20131993)" },
            { "uyu", "\u0d09\u0d31\u0d41\u0d17\u0d4d\u0d35\u0d47\u0d2f\u0d7b \u0d2a\u0d46\u0d38\u0d4b" },
            { "uzs", "\u0d09\u0d38\u0d4d\u200c\u0d2c\u0d46\u0d15\u0d4d\u0d15\u0d3f\u0d38\u0d4d\u0d25\u0d3e\u0d28\u0d3f \u0d38\u0d4b\u0d02" },
            { "veb", "\u0d35\u0d46\u0d28\u0d38\u0d4d\u0d35\u0d47\u0d32\u0d7b \u0d2c\u0d4b\u0d32\u0d3f\u0d35\u0d7c (1871\u20132008)" },
            { "vef", "\u0d35\u0d46\u0d28\u0d3f\u0d38\u0d4d\u0d35\u0d47\u0d32\u0d7b \u0d2c\u0d4a\u0d33\u0d40\u0d35\u0d7c" },
            { "vnd", "\u0d35\u0d3f\u0d2f\u0d31\u0d4d\u0d31\u0d4d\u0d28\u0d3e\u0d2e\u0d40\u0d38\u0d4d \u0d21\u0d4b\u0d19\u0d4d" },
            { "vuv", "\u0d35\u0d28\u0d4d\u0d35\u0d3e\u0d24\u0d41 \u0d35\u0d3e\u0d24\u0d41" },
            { "wst", "\u0d38\u0d2e\u0d4b\u0d35\u0d7b \u0d24\u0d3e\u0d32" },
            { "xaf", "\u0d2e\u0d26\u0d4d\u0d27\u0d4d\u0d2f \u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b [CFA] \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "xag", "\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f" },
            { "xau", "\u0d38\u0d4d\u0d35\u0d7c\u0d23\u0d4d\u0d23\u0d02" },
            { "xba", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d15\u0d4b\u0d28\u0d4d\u0d2a\u0d38\u0d3f\u0d31\u0d4d\u0d31\u0d4d \u0d2f\u0d42\u0d23\u0d3f\u0d31\u0d4d\u0d31\u0d4d" },
            { "xbb", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d2e\u0d4b\u0d23\u0d3f\u0d31\u0d4d\u0d31\u0d31\u0d3f \u0d2f\u0d42\u0d23\u0d3f\u0d31\u0d4d\u0d31\u0d4d" },
            { "xbc", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d2f\u0d42\u0d23\u0d3f\u0d31\u0d4d\u0d31\u0d4d \u0d13\u0d2b\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d4c\u0d23\u0d4d\u0d1f\u0d4d (XBC)" },
            { "xbd", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d2f\u0d42\u0d23\u0d3f\u0d31\u0d4d\u0d31\u0d4d \u0d13\u0d2b\u0d4d \u0d05\u0d15\u0d4d\u0d15\u0d4c\u0d23\u0d4d\u0d1f\u0d4d (XBD)" },
            { "xcd", "\u0d15\u0d3f\u0d34\u0d15\u0d4d\u0d15\u0d7b \u0d15\u0d30\u0d40\u0d2c\u0d3f\u0d2f\u0d7b \u0d21\u0d4b\u0d33\u0d7c" },
            { "xdr", "\u0d38\u0d4d\u0d2a\u0d46\u0d37\u0d4d\u0d2f\u0d7d \u0d21\u0d4d\u0d30\u0d4b\u0d2f\u0d3f\u0d02\u0d17\u0d4d \u0d31\u0d48\u0d31\u0d4d\u0d31\u0d4d\u0d38\u0d4d" },
            { "xeu", "\u0d2f\u0d42\u0d31\u0d4b\u0d2a\u0d4d\u0d2f\u0d7b \u0d28\u0d3e\u0d23\u0d2f \u0d2f\u0d42\u0d23\u0d3f\u0d31\u0d4d\u0d31\u0d4d" },
            { "xfo", "\u0d2b\u0d4d\u0d30\u0d46\u0d1e\u0d4d\u0d1a\u0d4d \u0d17\u0d4b\u0d7e\u0d21\u0d4d \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "xfu", "\u0d2b\u0d4d\u0d30\u0d46\u0d1e\u0d4d\u0d1a\u0d4d UIC-\u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "xof", "\u0d2a\u0d36\u0d4d\u0d1a\u0d3f\u0d2e \u0d06\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b [CFA] \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "xpd", "\u0d2a\u0d32\u0d3e\u0d21\u0d3f\u0d2f\u0d02" },
            { "xpf", "CFP \u0d2b\u0d4d\u0d30\u0d3e\u0d19\u0d4d\u0d15\u0d4d" },
            { "xpt", "\u0d2a\u0d4d\u0d32\u0d3e\u0d31\u0d4d\u0d31\u0d3f\u0d28\u0d02" },
            { "xre", "RINET \u0d2b\u0d23\u0d4d\u0d1f\u0d4d\u0d38\u0d4d" },
            { "xts", "\u0d1f\u0d46\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d3f\u0d02\u0d17\u0d3f\u0d28\u0d41\u0d33\u0d4d\u0d33 \u0d15\u0d31\u0d7b\u0d38\u0d3f \u0d15\u0d4b\u0d21\u0d4d" },
            { "xxx", "\u0d05\u0d1c\u0d4d\u0d1e\u0d3e\u0d24 \u0d28\u0d3e\u0d23\u0d2f\u0d02" },
            { "ydd", "\u0d2f\u0d2e\u0d28\u0d3f \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "yer", "\u0d2f\u0d46\u0d2e\u0d28\u0d3f \u0d31\u0d3f\u0d2f\u0d3e\u0d7d" },
            { "yud", "\u0d2f\u0d42\u0d17\u0d4b\u0d38\u0d4d\u0d32\u0d47\u0d35\u0d3f\u0d2f\u0d7b \u0d39\u0d3e\u0d7c\u0d21\u0d4d \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "yum", "\u0d2f\u0d42\u0d17\u0d4b\u0d38\u0d4d\u0d32\u0d47\u0d35\u0d3f\u0d2f\u0d7b \u0d28\u0d4b\u0d35\u0d3f \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "yun", "\u0d2f\u0d42\u0d17\u0d4b\u0d38\u0d4d\u0d32\u0d47\u0d35\u0d3f\u0d2f\u0d7b \u0d15\u0d7a\u0d35\u0d47\u0d7c\u0d1f\u0d4d\u0d1f\u0d3f\u0d2c\u0d3f\u0d7e \u0d26\u0d3f\u0d28\u0d3e\u0d7c" },
            { "zal", "\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23\u0d3e\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d31\u0d3e\u0d7b\u0d21\u0d4d (\u0d2b\u0d3f\u0d28\u0d3e\u0d7b\u0d37\u0d4d\u0d2f\u0d7d)" },
            { "zar", "\u0d26\u0d15\u0d4d\u0d37\u0d3f\u0d23\u0d3e\u0d2b\u0d4d\u0d30\u0d3f\u0d15\u0d4d\u0d15\u0d7b \u0d31\u0d3e\u0d7b\u0d21\u0d4d" },
            { "zmk", "\u0d38\u0d3e\u0d02\u0d2c\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d35\u0d3e\u0d1a (1968\u20132012)" },
            { "zmw", "\u0d38\u0d3e\u0d02\u0d2c\u0d3f\u0d2f\u0d7b \u0d15\u0d4d\u0d35\u0d3e\u0d1a\u0d4d\u0d1a" },
            { "zrn", "\u0d38\u0d48\u0d31\u0d3f\u0d2f\u0d7b \u0d28\u0d4d\u0d2f\u0d42 \u0d38\u0d48\u0d7c" },
            { "zrz", "\u0d38\u0d48\u0d31\u0d3f\u0d2f\u0d7b \u0d38\u0d48\u0d7c" },
            { "zwd", "\u0d38\u0d3f\u0d02\u0d2c\u0d3e\u0d2c\u0d4d\u200c\u0d35\u0d46 \u0d21\u0d4b\u0d33\u0d7c" },
        };
        return data;
    }
}
