/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Objects;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.TransformNodesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class ScaleCommand
extends TransformNodesCommand {
    private final EastNorth pivot = this.getNodesCenter();
    private double scalingFactor;
    private final EastNorth startEN;

    public ScaleCommand(Collection<? extends OsmPrimitive> objects, EastNorth currentEN) {
        super(objects);
        this.startEN = currentEN;
        this.handleEvent(currentEN);
    }

    @Override
    public final void handleEvent(EastNorth currentEN) {
        double startAngle = Math.atan2(this.startEN.east() - this.pivot.east(), this.startEN.north() - this.pivot.north());
        double endAngle = Math.atan2(currentEN.east() - this.pivot.east(), currentEN.north() - this.pivot.north());
        double startDistance = this.pivot.distance(this.startEN);
        double currentDistance = this.pivot.distance(currentEN);
        this.setScalingFactor(Math.cos(startAngle - endAngle) * currentDistance / startDistance);
        this.transformNodes();
    }

    protected void setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    @Override
    protected void transformNodes() {
        for (Node n : this.nodes) {
            EastNorth oldEastNorth = ((Command.OldNodeState)this.oldStates.get(n)).getEastNorth();
            double dx = oldEastNorth.east() - this.pivot.east();
            double dy = oldEastNorth.north() - this.pivot.north();
            double nx = this.pivot.east() + this.scalingFactor * dx;
            double ny = this.pivot.north() + this.scalingFactor * dy;
            n.setEastNorth(new EastNorth(nx, ny));
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Scale {0} node", "Scale {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pivot, this.scalingFactor, this.startEN);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ScaleCommand that = (ScaleCommand)obj;
        return Double.compare(that.scalingFactor, this.scalingFactor) == 0 && Objects.equals(this.pivot, that.pivot) && Objects.equals(this.startEN, that.startEN);
    }
}

