"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("../../../../specs/constants");
var constants_2 = require("../../specs/constants");
var config_1 = require("../config/config");
var commonDefaults = {
    specType: constants_1.SpecTypes.Series,
    subtype: constants_2.GoalSubtype.Goal,
    base: 0,
    target: 100,
    actual: 50,
    ticks: [0, 25, 50, 75, 100],
};
exports.defaultGoalSpec = __assign(__assign({}, commonDefaults), { bands: [50, 75, 100], bandFillColor: function (_a) {
        var value = _a.value, base = _a.base, highestValue = _a.highestValue, lowestValue = _a.lowestValue;
        var aboveBase = value > base;
        var ratio = aboveBase
            ? (value - base) / (Math.max(base, highestValue) - base)
            : (value - base) / (Math.min(base, lowestValue) - base);
        var level = Math.round(255 * ratio);
        return aboveBase ? "rgb(0, " + level + ", 0)" : "rgb( " + level + ", 0, 0)";
    }, tickValueFormatter: function (_a) {
        var value = _a.value;
        return String(value);
    }, labelMajor: function (_a) {
        var base = _a.base;
        return String(base);
    }, labelMinor: function (_a) { return 'unit'; }, centralMajor: function (_a) {
        var base = _a.base;
        return String(base);
    }, centralMinor: function (_a) {
        var target = _a.target;
        return String(target);
    } });
exports.nullGoalViewModel = __assign(__assign({}, commonDefaults), { bands: [], ticks: [], labelMajor: '', labelMinor: '', centralMajor: '', centralMinor: '', highestValue: 100, lowestValue: 0, aboveBaseCount: 0, belowBaseCount: 0 });
exports.nullShapeViewModel = function (specifiedConfig, chartCenter) { return ({
    config: specifiedConfig || config_1.config,
    bulletViewModel: exports.nullGoalViewModel,
    chartCenter: chartCenter || { x: 0, y: 0 },
    pickQuads: function () { return []; },
}); };
//# sourceMappingURL=viewmodel_types.js.map