"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_1 = require("../../../../../renderers/canvas");
var measure_1 = require("../../../../partition_chart/layout/utils/measure");
function renderText(ctx, origin, text, font, degree) {
    if (degree === void 0) { degree = 0; }
    if (text === undefined || text === null) {
        return;
    }
    canvas_1.withRotatedOrigin(ctx, origin, degree, function (ctx) {
        canvas_1.withContext(ctx, function (ctx) {
            ctx.fillStyle = font.fill;
            ctx.textAlign = font.align;
            ctx.textBaseline = font.baseline;
            ctx.font = measure_1.cssFontShorthand(font, font.fontSize);
            ctx.fillText(text, origin.x, origin.y);
        });
    });
}
exports.renderText = renderText;
var SPACE = ' ';
var ELLIPSIS = '…';
var DASH = '-';
function wrapLines(ctx, text, font, fontSize, fixedWidth, fixedHeight) {
    var lineHeight = 1;
    var lines = text.split('\n');
    var textWidth = 0;
    var lineHeightPx = lineHeight * fontSize;
    var padding = 0;
    var maxWidth = fixedWidth - padding * 2;
    var maxHeightPx = fixedHeight - padding * 2;
    var currentHeightPx = 0;
    var shouldWrap = true;
    var wrapAtWord = true;
    var shouldAddEllipsis = false;
    var textArr = [];
    var textMeasureProcessor = measure_1.measureText(ctx);
    var getTextWidth = function (text) {
        var measuredText = textMeasureProcessor(fontSize, [
            __assign({ text: text }, font),
        ]);
        var measure = measuredText[0];
        if (measure) {
            return measure.width;
        }
        return 0;
    };
    var additionalWidth = 0;
    for (var i = 0, max = lines.length; i < max; ++i) {
        var line = lines[i];
        var lineWidth = getTextWidth(line);
        if (fixedWidth && lineWidth > maxWidth) {
            while (line.length > 0) {
                var low = 0;
                var high = line.length;
                var match = '';
                var matchWidth = 0;
                while (low < high) {
                    var mid = (low + high) >>> 1;
                    var substr = line.slice(0, mid + 1);
                    var substrWidth = getTextWidth(substr) + additionalWidth;
                    if (substrWidth <= maxWidth) {
                        low = mid + 1;
                        match = substr + (shouldAddEllipsis ? ELLIPSIS : '');
                        matchWidth = substrWidth;
                    }
                    else {
                        high = mid;
                    }
                }
                if (match) {
                    if (wrapAtWord) {
                        var wrapIndex = void 0;
                        var nextChar = line[match.length];
                        var nextIsSpaceOrDash = nextChar === SPACE || nextChar === DASH;
                        if (nextIsSpaceOrDash && matchWidth <= maxWidth) {
                            wrapIndex = match.length;
                        }
                        else {
                            wrapIndex = Math.max(match.lastIndexOf(SPACE), match.lastIndexOf(DASH)) + 1;
                        }
                        if (wrapIndex > 0) {
                            low = wrapIndex;
                            match = match.slice(0, low);
                            matchWidth = getTextWidth(match);
                        }
                    }
                    match = match.trimEnd();
                    textArr.push(match);
                    textWidth = Math.max(textWidth, matchWidth);
                    currentHeightPx += lineHeightPx;
                    if (!shouldWrap || (fixedHeight && currentHeightPx + lineHeightPx > maxHeightPx)) {
                        break;
                    }
                    line = line.slice(low);
                    line = line.trimStart();
                    if (line.length > 0) {
                        lineWidth = getTextWidth(line);
                        if (lineWidth <= maxWidth) {
                            textArr.push(line);
                            currentHeightPx += lineHeightPx;
                            textWidth = Math.max(textWidth, lineWidth);
                            break;
                        }
                    }
                }
                else {
                    break;
                }
            }
        }
        else {
            textArr.push(line);
            currentHeightPx += lineHeightPx;
            textWidth = Math.max(textWidth, lineWidth);
        }
        if (fixedHeight && currentHeightPx + lineHeightPx > maxHeightPx) {
            break;
        }
    }
    return {
        lines: textArr,
        height: fontSize,
        width: textWidth,
    };
}
exports.wrapLines = wrapLines;
//# sourceMappingURL=text.js.map