"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../utils/commons");
var spec_1 = require("../state/utils/spec");
function computeChartDimensions(parentDimensions, chartTheme, axisDimensions, axisSpecs) {
    if (parentDimensions.width <= 0 || parentDimensions.height <= 0) {
        return {
            chartDimensions: {
                width: 0,
                height: 0,
                left: 0,
                top: 0,
            },
            leftMargin: 0,
        };
    }
    var chartMargins = chartTheme.chartMargins, chartPaddings = chartTheme.chartPaddings;
    var axisTitleStyle = chartTheme.axes.axisTitleStyle;
    var axisTitleHeight = axisTitleStyle.fontSize + axisTitleStyle.padding;
    var vLeftAxisSpecWidth = 0;
    var vRightAxisSpecWidth = 0;
    var hTopAxisSpecHeight = 0;
    var hBottomAxisSpecHeight = 0;
    var horizontalEdgeLabelOverflow = 0;
    var verticalEdgeLabelOverflow = 0;
    axisDimensions.forEach(function (_a, id) {
        var _b = _a.maxLabelBboxWidth, maxLabelBboxWidth = _b === void 0 ? 0 : _b, _c = _a.maxLabelBboxHeight, maxLabelBboxHeight = _c === void 0 ? 0 : _c;
        var axisSpec = spec_1.getSpecsById(axisSpecs, id);
        if (!axisSpec || axisSpec.hide) {
            return;
        }
        var position = axisSpec.position, tickSize = axisSpec.tickSize, tickPadding = axisSpec.tickPadding, title = axisSpec.title;
        var titleHeight = title !== undefined ? axisTitleHeight : 0;
        var maxAxisHeight = maxLabelBboxHeight + tickSize + tickPadding + titleHeight;
        var maxAxisWidth = maxLabelBboxWidth + tickSize + tickPadding + titleHeight;
        switch (position) {
            case commons_1.Position.Top:
                hTopAxisSpecHeight += maxAxisHeight + chartMargins.top;
                horizontalEdgeLabelOverflow = Math.max(horizontalEdgeLabelOverflow, maxLabelBboxWidth / 2);
                break;
            case commons_1.Position.Bottom:
                hBottomAxisSpecHeight += maxAxisHeight + chartMargins.bottom;
                horizontalEdgeLabelOverflow = Math.max(horizontalEdgeLabelOverflow, maxLabelBboxWidth / 2);
                break;
            case commons_1.Position.Right:
                vRightAxisSpecWidth += maxAxisWidth + chartMargins.right;
                verticalEdgeLabelOverflow = Math.max(verticalEdgeLabelOverflow, maxLabelBboxHeight / 2);
                break;
            case commons_1.Position.Left:
            default:
                vLeftAxisSpecWidth += maxAxisWidth + chartMargins.left;
                verticalEdgeLabelOverflow = Math.max(verticalEdgeLabelOverflow, maxLabelBboxHeight / 2);
                break;
        }
    });
    var chartLeftAxisMaxWidth = Math.max(vLeftAxisSpecWidth, horizontalEdgeLabelOverflow + chartMargins.left);
    var chartRightAxisMaxWidth = Math.max(vRightAxisSpecWidth, horizontalEdgeLabelOverflow + chartMargins.right);
    var chartTopAxisMaxHeight = Math.max(hTopAxisSpecHeight, verticalEdgeLabelOverflow + chartMargins.top);
    var chartBottomAxisMaxHeight = Math.max(hBottomAxisSpecHeight, verticalEdgeLabelOverflow + chartMargins.bottom);
    var chartWidth = parentDimensions.width - chartLeftAxisMaxWidth - chartRightAxisMaxWidth;
    var chartHeight = parentDimensions.height - chartTopAxisMaxHeight - chartBottomAxisMaxHeight;
    var top = chartTopAxisMaxHeight + chartPaddings.top;
    var left = chartLeftAxisMaxWidth + chartPaddings.left;
    return {
        leftMargin: chartLeftAxisMaxWidth - vLeftAxisSpecWidth,
        chartDimensions: {
            top: top,
            left: left,
            width: chartWidth - chartPaddings.left - chartPaddings.right,
            height: chartHeight - chartPaddings.top - chartPaddings.bottom,
        },
    };
}
exports.computeChartDimensions = computeChartDimensions;
//# sourceMappingURL=dimensions.js.map