function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { AbstractEmsService } from './ems_service';
export var TMSService = /*#__PURE__*/function (_AbstractEmsService) {
  _inherits(TMSService, _AbstractEmsService);

  var _super = _createSuper(TMSService);

  function TMSService(config, emsClient, proxyPath) {
    var _this;

    _classCallCheck(this, TMSService);

    _this = _super.call(this, config, emsClient, proxyPath);

    _defineProperty(_assertThisInitialized(_this), "_config", void 0);

    _defineProperty(_assertThisInitialized(_this), "_getRasterStyleJson", _.once( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var rasterUrl, url;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              rasterUrl = _this._getStyleUrlForLocale('raster');

              if (!rasterUrl) {
                _context.next = 6;
                break;
              }

              url = _this._proxyPath + _this._getAbsoluteUrl(rasterUrl);
              return _context.abrupt("return", _this._emsClient.getManifest(_this._emsClient.extendUrlWithParams(url)));

            case 6:
              return _context.abrupt("return");

            case 7:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))));

    _defineProperty(_assertThisInitialized(_this), "_getVectorStyleJsonRaw", _.once( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var vectorUrl, url, vectorJson;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              vectorUrl = _this._getStyleUrlForLocale('vector');

              if (!vectorUrl) {
                _context2.next = 9;
                break;
              }

              url = _this._proxyPath + _this._getAbsoluteUrl(vectorUrl);
              _context2.next = 5;
              return _this._emsClient.getManifest(_this._emsClient.extendUrlWithParams(url));

            case 5:
              vectorJson = _context2.sent;
              return _context2.abrupt("return", _objectSpread({}, vectorJson));

            case 9:
              return _context2.abrupt("return");

            case 10:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    }))));

    _defineProperty(_assertThisInitialized(_this), "_getVectorStyleJsonInlined", _.once( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
      var vectorJson, inlinedSources, sources, _iterator, _step, _sourceName, url, sourceUrl, extendedUrl, sourceJson, extendedTileUrls, htmlAttribution;

      return regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return _this._getVectorStyleJsonRaw();

            case 2:
              vectorJson = _context3.sent;

              if (!vectorJson) {
                _context3.next = 46;
                break;
              }

              inlinedSources = {};
              sources = vectorJson.sources;
              _iterator = _createForOfIteratorHelper(Object.getOwnPropertyNames(sources));
              _context3.prev = 7;

              _iterator.s();

            case 9:
              if ((_step = _iterator.n()).done) {
                _context3.next = 24;
                break;
              }

              _sourceName = _step.value;
              url = sources[_sourceName].url;
              sourceUrl = _this._proxyPath + _this._getAbsoluteUrl(url);
              extendedUrl = _this._emsClient.extendUrlWithParams(sourceUrl);
              _context3.next = 16;
              return _this._emsClient.getManifest(extendedUrl);

            case 16:
              sourceJson = _context3.sent;
              extendedTileUrls = sourceJson.tiles.map(function (tileUrl) {
                var url = _this._proxyPath + _this._getAbsoluteUrl(tileUrl);

                return _this._emsClient.extendUrlWithParams(url);
              }); // Override the attribution in the sources with the localized attribution

              _context3.next = 20;
              return _this.getHTMLAttribution();

            case 20:
              htmlAttribution = _context3.sent;
              inlinedSources[_sourceName] = _objectSpread({}, sourceJson, {
                type: 'vector',
                attribution: htmlAttribution,
                tiles: extendedTileUrls
              });

            case 22:
              _context3.next = 9;
              break;

            case 24:
              _context3.next = 29;
              break;

            case 26:
              _context3.prev = 26;
              _context3.t0 = _context3["catch"](7);

              _iterator.e(_context3.t0);

            case 29:
              _context3.prev = 29;

              _iterator.f();

              return _context3.finish(29);

            case 32:
              _context3.t1 = _objectSpread;
              _context3.t2 = {};
              _context3.t3 = vectorJson;
              _context3.t4 = inlinedSources;
              _context3.next = 38;
              return _this._getSpriteSheetRootPath();

            case 38:
              _context3.t5 = _context3.sent;
              _context3.next = 41;
              return _this._getUrlTemplateForGlyphs();

            case 41:
              _context3.t6 = _context3.sent;
              _context3.t7 = {
                sources: _context3.t4,
                sprite: _context3.t5,
                glyphs: _context3.t6
              };
              return _context3.abrupt("return", (0, _context3.t1)(_context3.t2, _context3.t3, _context3.t7));

            case 46:
              return _context3.abrupt("return");

            case 47:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3, null, [[7, 26, 29, 32]]);
    }))));

    _this._config = config;
    return _this;
  }

  _createClass(TMSService, [{
    key: "getDefaultRasterStyle",
    value: function () {
      var _getDefaultRasterStyle = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
        var _this2 = this;

        var tileJson, tiles;
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                _context4.next = 2;
                return this._getRasterStyleJson();

              case 2:
                tileJson = _context4.sent;

                if (!tileJson) {
                  _context4.next = 8;
                  break;
                }

                tiles = tileJson.tiles.map(function (tile) {
                  return _this2._proxyPath + _this2._getAbsoluteUrl(tile);
                });
                return _context4.abrupt("return", _objectSpread({}, tileJson, {}, {
                  tiles: tiles
                }));

              case 8:
                return _context4.abrupt("return");

              case 9:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function getDefaultRasterStyle() {
        return _getDefaultRasterStyle.apply(this, arguments);
      }

      return getDefaultRasterStyle;
    }()
  }, {
    key: "getUrlTemplate",
    value: function () {
      var _getUrlTemplate = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
        var tileJson, directUrl;
        return regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                _context5.next = 2;
                return this._getRasterStyleJson();

              case 2:
                tileJson = _context5.sent;

                if (!tileJson) {
                  _context5.next = 8;
                  break;
                }

                directUrl = this._proxyPath + this._getAbsoluteUrl(tileJson.tiles[0]);
                return _context5.abrupt("return", this._emsClient.extendUrlWithParams(directUrl));

              case 8:
                return _context5.abrupt("return", '');

              case 9:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this);
      }));

      function getUrlTemplate() {
        return _getUrlTemplate.apply(this, arguments);
      }

      return getUrlTemplate;
    }()
  }, {
    key: "getUrlTemplateForVector",
    value: function () {
      var _getUrlTemplateForVector = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(sourceId) {
        var tileJson, directUrl;
        return regeneratorRuntime.wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                _context6.next = 2;
                return this._getVectorStyleJsonInlined();

              case 2:
                tileJson = _context6.sent;

                if (tileJson) {
                  _context6.next = 5;
                  break;
                }

                return _context6.abrupt("return", '');

              case 5:
                if (!(tileJson.sources[sourceId] && tileJson.sources[sourceId].tiles)) {
                  _context6.next = 10;
                  break;
                }

                directUrl = this._proxyPath + this._getAbsoluteUrl(tileJson.sources[sourceId].tiles[0]);
                return _context6.abrupt("return", this._emsClient.extendUrlWithParams(directUrl));

              case 10:
                return _context6.abrupt("return", '');

              case 11:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6, this);
      }));

      function getUrlTemplateForVector(_x) {
        return _getUrlTemplateForVector.apply(this, arguments);
      }

      return getUrlTemplateForVector;
    }()
  }, {
    key: "getVectorStyleSheet",
    value: function () {
      var _getVectorStyleSheet = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7() {
        return regeneratorRuntime.wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                _context7.next = 2;
                return this._getVectorStyleJsonInlined();

              case 2:
                return _context7.abrupt("return", _context7.sent);

              case 3:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this);
      }));

      function getVectorStyleSheet() {
        return _getVectorStyleSheet.apply(this, arguments);
      }

      return getVectorStyleSheet;
    }()
  }, {
    key: "getVectorStyleSheetRaw",
    value: function () {
      var _getVectorStyleSheetRaw = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8() {
        return regeneratorRuntime.wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                _context8.next = 2;
                return this._getVectorStyleJsonRaw();

              case 2:
                return _context8.abrupt("return", _context8.sent);

              case 3:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, this);
      }));

      function getVectorStyleSheetRaw() {
        return _getVectorStyleSheetRaw.apply(this, arguments);
      }

      return getVectorStyleSheetRaw;
    }()
  }, {
    key: "getSpriteSheetMeta",
    value: function () {
      var _getSpriteSheetMeta = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9() {
        var isRetina,
            metaUrl,
            spritePngs,
            metaUrlExtended,
            jsonMeta,
            _args9 = arguments;
        return regeneratorRuntime.wrap(function _callee9$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                isRetina = _args9.length > 0 && _args9[0] !== undefined ? _args9[0] : false;
                _context9.next = 3;
                return this.getSpriteSheetJsonPath(isRetina);

              case 3:
                metaUrl = _context9.sent;
                _context9.next = 6;
                return this.getSpriteSheetPngPath(isRetina);

              case 6:
                spritePngs = _context9.sent;

                if (!(metaUrl && spritePngs)) {
                  _context9.next = 15;
                  break;
                }

                metaUrlExtended = this._emsClient.extendUrlWithParams(metaUrl);
                _context9.next = 11;
                return this._emsClient.getManifest(metaUrlExtended);

              case 11:
                jsonMeta = _context9.sent;
                return _context9.abrupt("return", {
                  png: spritePngs,
                  json: jsonMeta
                });

              case 15:
                return _context9.abrupt("return");

              case 16:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee9, this);
      }));

      function getSpriteSheetMeta() {
        return _getSpriteSheetMeta.apply(this, arguments);
      }

      return getSpriteSheetMeta;
    }()
  }, {
    key: "getSpriteSheetJsonPath",
    value: function () {
      var _getSpriteSheetJsonPath = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10() {
        var isRetina,
            spriteSheetRootPath,
            suffix,
            _args10 = arguments;
        return regeneratorRuntime.wrap(function _callee10$(_context10) {
          while (1) {
            switch (_context10.prev = _context10.next) {
              case 0:
                isRetina = _args10.length > 0 && _args10[0] !== undefined ? _args10[0] : false;
                _context10.next = 3;
                return this._getSpriteSheetRootPath();

              case 3:
                spriteSheetRootPath = _context10.sent;

                if (!spriteSheetRootPath) {
                  _context10.next = 9;
                  break;
                }

                suffix = isRetina ? '@2x' : '';
                return _context10.abrupt("return", spriteSheetRootPath + suffix + '.json');

              case 9:
                return _context10.abrupt("return", '');

              case 10:
              case "end":
                return _context10.stop();
            }
          }
        }, _callee10, this);
      }));

      function getSpriteSheetJsonPath() {
        return _getSpriteSheetJsonPath.apply(this, arguments);
      }

      return getSpriteSheetJsonPath;
    }()
  }, {
    key: "getSpriteSheetPngPath",
    value: function () {
      var _getSpriteSheetPngPath = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee11() {
        var isRetina,
            spriteSheetRootPath,
            suffix,
            _args11 = arguments;
        return regeneratorRuntime.wrap(function _callee11$(_context11) {
          while (1) {
            switch (_context11.prev = _context11.next) {
              case 0:
                isRetina = _args11.length > 0 && _args11[0] !== undefined ? _args11[0] : false;
                _context11.next = 3;
                return this._getSpriteSheetRootPath();

              case 3:
                spriteSheetRootPath = _context11.sent;

                if (!spriteSheetRootPath) {
                  _context11.next = 9;
                  break;
                }

                suffix = isRetina ? '@2x' : '';
                return _context11.abrupt("return", spriteSheetRootPath + suffix + '.png');

              case 9:
                return _context11.abrupt("return", '');

              case 10:
              case "end":
                return _context11.stop();
            }
          }
        }, _callee11, this);
      }));

      function getSpriteSheetPngPath() {
        return _getSpriteSheetPngPath.apply(this, arguments);
      }

      return getSpriteSheetPngPath;
    }()
  }, {
    key: "getDisplayName",
    value: function getDisplayName() {
      return this._emsClient.getValueInLanguage(this._config.name);
    }
  }, {
    key: "getMinZoom",
    value: function () {
      var _getMinZoom = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee12() {
        var tileJson;
        return regeneratorRuntime.wrap(function _callee12$(_context12) {
          while (1) {
            switch (_context12.prev = _context12.next) {
              case 0:
                _context12.next = 2;
                return this._getRasterStyleJson();

              case 2:
                tileJson = _context12.sent;

                if (!tileJson) {
                  _context12.next = 7;
                  break;
                }

                return _context12.abrupt("return", tileJson.minzoom);

              case 7:
                return _context12.abrupt("return");

              case 8:
              case "end":
                return _context12.stop();
            }
          }
        }, _callee12, this);
      }));

      function getMinZoom() {
        return _getMinZoom.apply(this, arguments);
      }

      return getMinZoom;
    }()
  }, {
    key: "getMaxZoom",
    value: function () {
      var _getMaxZoom = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee13() {
        var tileJson;
        return regeneratorRuntime.wrap(function _callee13$(_context13) {
          while (1) {
            switch (_context13.prev = _context13.next) {
              case 0:
                _context13.next = 2;
                return this._getRasterStyleJson();

              case 2:
                tileJson = _context13.sent;

                if (!tileJson) {
                  _context13.next = 7;
                  break;
                }

                return _context13.abrupt("return", tileJson.maxzoom);

              case 7:
                return _context13.abrupt("return");

              case 8:
              case "end":
                return _context13.stop();
            }
          }
        }, _callee13, this);
      }));

      function getMaxZoom() {
        return _getMaxZoom.apply(this, arguments);
      }

      return getMaxZoom;
    }()
  }, {
    key: "getId",
    value: function getId() {
      return this._config.id;
    }
  }, {
    key: "hasId",
    value: function hasId(id) {
      return this._config.id === id;
    }
  }, {
    key: "getApiUrl",
    value: function getApiUrl() {
      return this._emsClient.getTileApiUrl();
    }
  }, {
    key: "_getStyleUrlForLocale",
    value: function _getStyleUrlForLocale(formatType) {
      var vectorFormats = this._getFormats(formatType, this._emsClient.getLocale());

      if (!vectorFormats.length) {
        //fallback to default locale
        vectorFormats = this._getFormats(formatType, this._emsClient.getDefaultLocale());
      }

      if (!vectorFormats.length) {
        // eslint-disable-next-line max-len
        throw new Error("Cannot find ".concat(formatType, " tile layer for locale ").concat(this._emsClient.getLocale(), " or ").concat(this._emsClient.getDefaultLocale()));
      }

      var defaultStyle = vectorFormats[0];

      if (defaultStyle && defaultStyle.hasOwnProperty('url')) {
        return defaultStyle.url;
      }
    }
  }, {
    key: "_getFormats",
    value: function _getFormats(formatType, locale) {
      return this._config.formats.filter(function (format) {
        return format.locale === locale && format.format === formatType;
      });
    }
  }, {
    key: "_getSpriteSheetRootPath",
    value: function () {
      var _getSpriteSheetRootPath2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee14() {
        var vectorStyleJson;
        return regeneratorRuntime.wrap(function _callee14$(_context14) {
          while (1) {
            switch (_context14.prev = _context14.next) {
              case 0:
                _context14.next = 2;
                return this._getVectorStyleJsonRaw();

              case 2:
                vectorStyleJson = _context14.sent;

                if (!vectorStyleJson) {
                  _context14.next = 7;
                  break;
                }

                return _context14.abrupt("return", this._proxyPath + this._getAbsoluteUrl(vectorStyleJson.sprite));

              case 7:
                return _context14.abrupt("return", '');

              case 8:
              case "end":
                return _context14.stop();
            }
          }
        }, _callee14, this);
      }));

      function _getSpriteSheetRootPath() {
        return _getSpriteSheetRootPath2.apply(this, arguments);
      }

      return _getSpriteSheetRootPath;
    }()
  }, {
    key: "_getUrlTemplateForGlyphs",
    value: function () {
      var _getUrlTemplateForGlyphs2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee15() {
        var vectorStyleJson;
        return regeneratorRuntime.wrap(function _callee15$(_context15) {
          while (1) {
            switch (_context15.prev = _context15.next) {
              case 0:
                _context15.next = 2;
                return this._getVectorStyleJsonRaw();

              case 2:
                vectorStyleJson = _context15.sent;

                if (!vectorStyleJson) {
                  _context15.next = 7;
                  break;
                }

                return _context15.abrupt("return", this._proxyPath + this._getAbsoluteUrl(vectorStyleJson.glyphs));

              case 7:
                return _context15.abrupt("return", '');

              case 8:
              case "end":
                return _context15.stop();
            }
          }
        }, _callee15, this);
      }));

      function _getUrlTemplateForGlyphs() {
        return _getUrlTemplateForGlyphs2.apply(this, arguments);
      }

      return _getUrlTemplateForGlyphs;
    }()
  }]);

  return TMSService;
}(AbstractEmsService);