"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBox = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _portal = require("../portal");

var _combo_box_options_list = require("./combo_box_options_list");

var _matching_options = require("./matching_options");

var _combo_box_input = require("./combo_box_input/combo_box_input");

var _popover = require("../../services/popover");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var initialSearchValue = '';

var EuiComboBox =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiComboBox, _Component);

  function EuiComboBox() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, EuiComboBox);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(EuiComboBox)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "state", {
      activeOptionIndex: -1,
      hasFocus: false,
      isListOpen: false,
      listElement: null,
      listPosition: 'bottom',
      listZIndex: undefined,
      matchingOptions: (0, _matching_options.getMatchingOptions)(_this.props.options, _this.props.selectedOptions, initialSearchValue, _this.props.async, Boolean(_this.props.singleSelection)),
      searchValue: initialSearchValue,
      width: 0
    });

    _defineProperty(_assertThisInitialized(_this), "_isMounted", false);

    _defineProperty(_assertThisInitialized(_this), "rootId", (0, _services.htmlIdGenerator)());

    _defineProperty(_assertThisInitialized(_this), "comboBoxRefInstance", null);

    _defineProperty(_assertThisInitialized(_this), "comboBoxRefCallback", function (ref) {
      // IE11 doesn't support the `relatedTarget` event property for blur events
      // but does add it for focusout. React doesn't support `onFocusOut` so here we are.
      if (_this.comboBoxRefInstance) {
        _this.comboBoxRefInstance.removeEventListener('focusout', _this.onContainerBlur);
      }

      _this.comboBoxRefInstance = ref;

      if (_this.comboBoxRefInstance) {
        _this.comboBoxRefInstance.addEventListener('focusout', _this.onContainerBlur);

        var comboBoxBounds = _this.comboBoxRefInstance.getBoundingClientRect();

        _this.setState({
          width: comboBoxBounds.width
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "autoSizeInputRefInstance", null);

    _defineProperty(_assertThisInitialized(_this), "autoSizeInputRefCallback", function (ref) {
      _this.autoSizeInputRefInstance = ref;
    });

    _defineProperty(_assertThisInitialized(_this), "searchInputRefInstance", null);

    _defineProperty(_assertThisInitialized(_this), "searchInputRefCallback", function (ref) {
      _this.searchInputRefInstance = ref;
      if (_this.props.inputRef) _this.props.inputRef(ref);
    });

    _defineProperty(_assertThisInitialized(_this), "listRefInstance", null);

    _defineProperty(_assertThisInitialized(_this), "listRefCallback", function (ref) {
      if (_this.comboBoxRefInstance) {
        // find the zIndex of the combobox relative to the page body
        // and use that to depth-position the list box
        // adds an extra `100` to provide some defense around neighboring elements' positioning
        var listZIndex = (0, _popover.getElementZIndex)(_this.comboBoxRefInstance, document.body) + 100;

        _this.setState({
          listZIndex: listZIndex
        });
      }

      _this.listRefInstance = ref;
    });

    _defineProperty(_assertThisInitialized(_this), "toggleButtonRefInstance", null);

    _defineProperty(_assertThisInitialized(_this), "toggleButtonRefCallback", function (ref) {
      _this.toggleButtonRefInstance = ref;
    });

    _defineProperty(_assertThisInitialized(_this), "optionsRefInstances", []);

    _defineProperty(_assertThisInitialized(_this), "optionRefCallback", function (index, ref) {
      _this.optionsRefInstances[index] = ref;
    });

    _defineProperty(_assertThisInitialized(_this), "openList", function () {
      _this.setState({
        isListOpen: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closeList", function () {
      _this.clearActiveOption();

      _this.setState({
        listZIndex: undefined,
        isListOpen: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "updatePosition", function () {
      var listElement = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _this.state.listElement;

      if (!_this._isMounted) {
        return;
      }

      if (!_this.state.isListOpen) {
        return;
      }

      if (!listElement) {
        return;
      } // it's possible that updateListPosition is called when listElement is becoming visible, but isn't yet


      var listElementBounds = listElement.getBoundingClientRect();

      if (listElementBounds.width === 0 || listElementBounds.height === 0) {
        return;
      }

      if (!_this.comboBoxRefInstance) {
        return;
      }

      var comboBoxBounds = _this.comboBoxRefInstance.getBoundingClientRect();

      var _ref = (0, _services.findPopoverPosition)({
        allowCrossAxis: false,
        anchor: _this.comboBoxRefInstance,
        popover: listElement,
        position: 'bottom'
      }),
          position = _ref.position,
          top = _ref.top;

      if (_this.listRefInstance) {
        _this.listRefInstance.style.top = "".concat(top, "px"); // listElement doesn't have its width set until after updating the position
        // which means the popover service won't know about the correct width
        // however, we already know where to position the element

        _this.listRefInstance.style.left = "".concat(comboBoxBounds.left + window.pageXOffset, "px");
        _this.listRefInstance.style.width = "".concat(comboBoxBounds.width, "px");
      } // Cache for future calls.


      _this.setState({
        listElement: listElement,
        listPosition: position,
        width: comboBoxBounds.width
      });
    });

    _defineProperty(_assertThisInitialized(_this), "incrementActiveOptionIndex", function (amount) {
      // If there are no options available, do nothing.
      if (!_this.state.matchingOptions.length) {
        return;
      }

      _this.setState(function (_ref2) {
        var activeOptionIndex = _ref2.activeOptionIndex,
            matchingOptions = _ref2.matchingOptions;
        var nextActiveOptionIndex;

        if (activeOptionIndex < 0) {
          // If this is the beginning of the user's keyboard navigation of the menu, then we'll focus
          // either the first or last item.
          nextActiveOptionIndex = amount < 0 ? matchingOptions.length - 1 : 0;
        } else {
          nextActiveOptionIndex = activeOptionIndex + amount;

          if (nextActiveOptionIndex < 0) {
            nextActiveOptionIndex = matchingOptions.length - 1;
          } else if (nextActiveOptionIndex === matchingOptions.length) {
            nextActiveOptionIndex = 0;
          }
        } // Group titles are included in option list but are not selectable
        // Skip group title options


        var direction = amount > 0 ? 1 : -1;

        while (matchingOptions[nextActiveOptionIndex].isGroupLabelOption) {
          nextActiveOptionIndex = nextActiveOptionIndex + direction;

          if (nextActiveOptionIndex < 0) {
            nextActiveOptionIndex = matchingOptions.length - 1;
          } else if (nextActiveOptionIndex === matchingOptions.length) {
            nextActiveOptionIndex = 0;
          }
        }

        return {
          activeOptionIndex: nextActiveOptionIndex
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "hasActiveOption", function () {
      return _this.state.activeOptionIndex > -1 && _this.state.activeOptionIndex < _this.state.matchingOptions.length;
    });

    _defineProperty(_assertThisInitialized(_this), "clearActiveOption", function () {
      _this.setState({
        activeOptionIndex: -1
      });
    });

    _defineProperty(_assertThisInitialized(_this), "clearSearchValue", function () {
      _this.onSearchChange('');
    });

    _defineProperty(_assertThisInitialized(_this), "removeLastOption", function () {
      if (!_this.props.selectedOptions.length) {
        return;
      } // Backspace will be used to delete the input, not a pill.


      if (_this.state.searchValue.length) {
        return;
      } // Delete last pill.


      _this.onRemoveOption(_this.props.selectedOptions[_this.props.selectedOptions.length - 1]);

      if (Boolean(_this.props.singleSelection) && !_this.state.isListOpen) {
        _this.openList();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "addCustomOption", function (isContainerBlur, searchValue) {
      var _this$props = _this.props,
          onCreateOption = _this$props.onCreateOption,
          options = _this$props.options,
          selectedOptions = _this$props.selectedOptions,
          singleSelection = _this$props.singleSelection;
      var matchingOptions = _this.state.matchingOptions;

      if (_this.doesSearchMatchOnlyOption()) {
        _this.onAddOption(matchingOptions[0], isContainerBlur);

        return;
      }

      if (!onCreateOption) {
        return;
      } // Don't bother trying to create an option if the user hasn't typed anything.


      if (!searchValue) {
        return;
      } // Don't create the value if it's already been selected.


      if ((0, _matching_options.getSelectedOptionForSearchValue)(searchValue, selectedOptions)) {
        return;
      } // Add new custom pill if this is custom input, even if it partially matches an option..


      var isOptionCreated = onCreateOption(searchValue, (0, _matching_options.flattenOptionGroups)(options)); // Expect the consumer to be explicit in rejecting a custom option.

      if (isOptionCreated === false) {
        return;
      }

      _this.clearSearchValue();

      if (_this.isSingleSelectionCustomOption() || Boolean(singleSelection) && matchingOptions.length < 1) {
        // Adding a custom option to a single select that does not appear in the list of options
        _this.closeList();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "doesSearchMatchOnlyOption", function () {
      var searchValue = _this.state.searchValue;

      if (_this.state.matchingOptions.length !== 1) {
        return false;
      }

      return _this.state.matchingOptions[0].label.toLowerCase() === searchValue.toLowerCase();
    });

    _defineProperty(_assertThisInitialized(_this), "areAllOptionsSelected", function () {
      var _this$props2 = _this.props,
          options = _this$props2.options,
          selectedOptions = _this$props2.selectedOptions,
          async = _this$props2.async; // Assume if this is async then there could be infinite options.

      if (async) {
        return false;
      }

      var flattenOptions = (0, _matching_options.flattenOptionGroups)(options).map(function (option) {
        return _objectSpread({}, option, {
          label: option.label.trim().toLowerCase()
        });
      });
      var numberOfSelectedOptions = 0;
      selectedOptions.forEach(function (_ref3) {
        var label = _ref3.label;
        var trimmedLabel = label.trim().toLowerCase();
        if (flattenOptions.findIndex(function (option) {
          return option.label === trimmedLabel;
        }) !== -1) numberOfSelectedOptions += 1;
      });
      return flattenOptions.length === numberOfSelectedOptions;
    });

    _defineProperty(_assertThisInitialized(_this), "isSingleSelectionCustomOption", function () {
      var _this$props3 = _this.props,
          onCreateOption = _this$props3.onCreateOption,
          options = _this$props3.options,
          selectedOptions = _this$props3.selectedOptions,
          singleSelection = _this$props3.singleSelection; // The selected option of a single select is custom and does not appear in the list of options

      return Boolean(singleSelection) && onCreateOption && selectedOptions.length > 0 && !options.includes(selectedOptions[0]);
    });

    _defineProperty(_assertThisInitialized(_this), "onComboBoxFocus", function (event) {
      if (_this.props.onFocus) {
        _this.props.onFocus(event);
      }

      if (!_this.isSingleSelectionCustomOption()) {
        _this.openList();
      }

      _this.setState({
        hasFocus: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "setCustomOptions", function (isContainerBlur) {
      var searchValue = _this.state.searchValue;
      var delimiter = _this.props.delimiter;

      if (delimiter) {
        searchValue.split(delimiter).forEach(function (option) {
          if (option.length > 0) _this.addCustomOption(true, option);
        });
      } else {
        _this.addCustomOption(isContainerBlur, searchValue);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onContainerBlur", function (event) {
      // close the options list, unless the use clicked on an option

      /**
       * FireFox returns `relatedTarget` as `null` for security reasons, but provides a proprietary `explicitOriginalTarget`.
       * @see https://developer.mozilla.org/en-US/docs/Web/API/Event/explicitOriginalTarget
       */
      var focusEvent = event;
      var relatedTarget = focusEvent.relatedTarget || focusEvent.explicitOriginalTarget;

      var focusedInOptionsList = relatedTarget && _this.listRefInstance && _this.listRefInstance.contains(relatedTarget);

      var focusedInInput = relatedTarget && _this.comboBoxRefInstance && _this.comboBoxRefInstance.contains(relatedTarget);

      if (!focusedInOptionsList && !focusedInInput) {
        _this.closeList();

        if (_this.props.onBlur) {
          _this.props.onBlur(event);
        }

        _this.setState({
          hasFocus: false
        }); // If the user tabs away or changes focus to another element, take whatever input they've
        // typed and convert it into a pill, to prevent the combo box from looking like a text input.


        if (!_this.hasActiveOption()) {
          _this.setCustomOptions(true);
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (event) {
      switch (event.key) {
        case _services.keys.ARROW_UP:
          event.preventDefault();
          event.stopPropagation();

          if (_this.state.isListOpen) {
            _this.incrementActiveOptionIndex(-1);
          } else {
            _this.openList();
          }

          break;

        case _services.keys.ARROW_DOWN:
          event.preventDefault();
          event.stopPropagation();

          if (_this.state.isListOpen) {
            _this.incrementActiveOptionIndex(1);
          } else {
            _this.openList();
          }

          break;

        case _services.keys.BACKSPACE:
          event.stopPropagation();

          _this.removeLastOption();

          break;

        case _services.keys.ESCAPE:
          event.stopPropagation();

          _this.closeList();

          break;

        case _services.keys.ENTER:
          event.preventDefault();
          event.stopPropagation();

          if (_this.hasActiveOption()) {
            _this.onAddOption(_this.state.matchingOptions[_this.state.activeOptionIndex]);
          } else {
            _this.setCustomOptions(false);
          }

          break;

        case _services.keys.TAB:
          // Disallow tabbing when the user is navigating the options.
          if (_this.hasActiveOption() && _this.state.isListOpen) {
            event.preventDefault();
            event.stopPropagation();
          }

          break;

        default:
          if (_this.props.onKeyDown) {
            _this.props.onKeyDown(event);
          }

      }
    });

    _defineProperty(_assertThisInitialized(_this), "onOptionEnterKey", function (option) {
      _this.onAddOption(option);
    });

    _defineProperty(_assertThisInitialized(_this), "onOptionClick", function (option) {
      _this.onAddOption(option);
    });

    _defineProperty(_assertThisInitialized(_this), "onAddOption", function (addedOption, isContainerBlur) {
      if (addedOption.disabled) {
        return;
      }

      var _this$props4 = _this.props,
          onChange = _this$props4.onChange,
          selectedOptions = _this$props4.selectedOptions,
          singleSelectionProp = _this$props4.singleSelection;
      var singleSelection = Boolean(singleSelectionProp);
      var changeOptions = singleSelection ? [addedOption] : selectedOptions.concat(addedOption);

      if (onChange) {
        onChange(changeOptions);
      }

      _this.clearSearchValue();

      _this.clearActiveOption();

      if (!isContainerBlur) {
        if (_this.searchInputRefInstance) {
          _this.searchInputRefInstance.focus();
        }
      }

      if (singleSelection) {
        requestAnimationFrame(_this.closeList);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onRemoveOption", function (removedOption) {
      var _this$props5 = _this.props,
          onChange = _this$props5.onChange,
          selectedOptions = _this$props5.selectedOptions;

      if (onChange) {
        onChange(selectedOptions.filter(function (option) {
          return option !== removedOption;
        }));
      }

      _this.clearActiveOption();
    });

    _defineProperty(_assertThisInitialized(_this), "clearSelectedOptions", function () {
      var onChange = _this.props.onChange;

      if (onChange) {
        onChange([]);
      } // Clicking the clear button will also cause it to disappear. This would result in focus
      // shifting unexpectedly to the body element so we set it to the input which is more reasonable,


      if (_this.searchInputRefInstance) {
        _this.searchInputRefInstance.focus();
      }

      if (!_this.state.isListOpen) {
        _this.openList();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onComboBoxClick", function () {
      // When the user clicks anywhere on the box, enter the interaction state.
      if (_this.searchInputRefInstance) {
        _this.searchInputRefInstance.focus();
      } // If the user does this from a state in which an option has focus, then we need to reset it or clear it.


      if (Boolean(_this.props.singleSelection) && _this.props.selectedOptions.length === 1) {
        _this.setState({
          activeOptionIndex: _this.state.matchingOptions.indexOf(_this.props.selectedOptions[0])
        });
      } else {
        _this.clearActiveOption();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onOpenListClick", function () {
      if (_this.searchInputRefInstance) {
        _this.searchInputRefInstance.focus();
      }

      if (!_this.state.isListOpen) {
        _this.openList();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onOptionListScroll", function () {
      if (_this.searchInputRefInstance) {
        _this.searchInputRefInstance.focus();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onCloseListClick", function () {
      _this.closeList();
    });

    _defineProperty(_assertThisInitialized(_this), "onSearchChange", function (searchValue) {
      var _this$props6 = _this.props,
          onSearchChange = _this$props6.onSearchChange,
          delimiter = _this$props6.delimiter;

      if (onSearchChange) {
        var _hasMatchingOptions = _this.state.matchingOptions.length > 0;

        onSearchChange(searchValue, _hasMatchingOptions);
      }

      _this.setState({
        searchValue: searchValue
      }, function () {
        if (searchValue && _this.state.isListOpen === false) _this.openList();
      });

      if (delimiter && searchValue.endsWith(delimiter)) {
        searchValue.split(delimiter).forEach(function (value) {
          if (value.length > 0) _this.addCustomOption(false, value);
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "updateMatchingOptionsIfDifferent", function (newMatchingOptions) {
      var _this$state = _this.state,
          matchingOptions = _this$state.matchingOptions,
          activeOptionIndex = _this$state.activeOptionIndex;
      var _this$props7 = _this.props,
          singleSelection = _this$props7.singleSelection,
          selectedOptions = _this$props7.selectedOptions;
      var areOptionsDifferent = false;

      if (matchingOptions.length !== newMatchingOptions.length) {
        areOptionsDifferent = true;
      } else {
        for (var i = 0; i < matchingOptions.length; i++) {
          if (matchingOptions[i].label !== newMatchingOptions[i].label) {
            areOptionsDifferent = true;
            break;
          }
        }
      }

      if (areOptionsDifferent) {
        _this.optionsRefInstances = [];
        var nextActiveOptionIndex = activeOptionIndex; // ensure that the currently selected single option is active if it is in the matchingOptions

        if (Boolean(singleSelection) && selectedOptions.length === 1) {
          if (newMatchingOptions.includes(selectedOptions[0])) {
            nextActiveOptionIndex = newMatchingOptions.indexOf(selectedOptions[0]);
          }
        }

        _this.setState({
          matchingOptions: newMatchingOptions,
          activeOptionIndex: nextActiveOptionIndex
        });

        if (!newMatchingOptions.length) {
          // Prevent endless setState -> componentWillUpdate -> setState loop.
          if (_this.hasActiveOption()) {
            _this.clearActiveOption();
          }
        }
      }
    });

    return _this;
  }

  _createClass(EuiComboBox, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this._isMounted = true; // TODO: This will need to be called once the actual stylesheet loads.

      setTimeout(function () {
        if (_this2.autoSizeInputRefInstance) {
          _this2.autoSizeInputRefInstance.copyInputStyles();
        }
      }, 100);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this$props8 = this.props,
          options = _this$props8.options,
          selectedOptions = _this$props8.selectedOptions,
          singleSelection = _this$props8.singleSelection;
      var searchValue = this.state.searchValue; // React 16.3 has a bug (fixed in 16.4) where getDerivedStateFromProps
      // isn't called after a state change, and we track `searchValue` in state
      // instead we need to react to a change in searchValue here

      this.updateMatchingOptionsIfDifferent((0, _matching_options.getMatchingOptions)(options, selectedOptions, searchValue, this.props.async, Boolean(singleSelection)));
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props9 = this.props,
          dataTestSubj = _this$props9['data-test-subj'],
          async = _this$props9.async,
          className = _this$props9.className,
          compressed = _this$props9.compressed,
          fullWidth = _this$props9.fullWidth,
          id = _this$props9.id,
          inputRef = _this$props9.inputRef,
          isClearable = _this$props9.isClearable,
          isDisabled = _this$props9.isDisabled,
          isInvalid = _this$props9.isInvalid,
          isLoading = _this$props9.isLoading,
          noSuggestions = _this$props9.noSuggestions,
          onBlur = _this$props9.onBlur,
          onChange = _this$props9.onChange,
          onCreateOption = _this$props9.onCreateOption,
          onSearchChange = _this$props9.onSearchChange,
          options = _this$props9.options,
          placeholder = _this$props9.placeholder,
          renderOption = _this$props9.renderOption,
          rowHeight = _this$props9.rowHeight,
          selectedOptions = _this$props9.selectedOptions,
          singleSelection = _this$props9.singleSelection,
          prepend = _this$props9.prepend,
          sortMatchesBy = _this$props9.sortMatchesBy,
          delimiter = _this$props9.delimiter,
          append = _this$props9.append,
          rest = _objectWithoutProperties(_this$props9, ["data-test-subj", "async", "className", "compressed", "fullWidth", "id", "inputRef", "isClearable", "isDisabled", "isInvalid", "isLoading", "noSuggestions", "onBlur", "onChange", "onCreateOption", "onSearchChange", "options", "placeholder", "renderOption", "rowHeight", "selectedOptions", "singleSelection", "prepend", "sortMatchesBy", "delimiter", "append"]);

      var _this$state2 = this.state,
          activeOptionIndex = _this$state2.activeOptionIndex,
          hasFocus = _this$state2.hasFocus,
          isListOpen = _this$state2.isListOpen,
          listPosition = _this$state2.listPosition,
          searchValue = _this$state2.searchValue,
          width = _this$state2.width,
          matchingOptions = _this$state2.matchingOptions;
      var newMatchingOptions = matchingOptions;

      if (sortMatchesBy === 'startsWith') {
        var refObj = {
          startWith: [],
          others: []
        };
        newMatchingOptions.forEach(function (object) {
          if (object.label.toLowerCase().startsWith(searchValue.trim().toLowerCase())) {
            refObj.startWith.push(object);
          } else {
            refObj.others.push(object);
          }
        });
        newMatchingOptions = [].concat(_toConsumableArray(refObj.startWith), _toConsumableArray(refObj.others));
      } // Visually indicate the combobox is in an invalid state if it has lost focus but there is text entered in the input.
      // When custom options are disabled and the user leaves the combo box after entering text that does not match any
      // options, this tells the user that they've entered invalid input.


      var markAsInvalid = isInvalid || (hasFocus === false || isListOpen === false) && searchValue;
      var classes = (0, _classnames.default)('euiComboBox', className, {
        'euiComboBox--compressed': compressed,
        'euiComboBox--fullWidth': fullWidth,
        'euiComboBox-isDisabled': isDisabled,
        'euiComboBox-isInvalid': markAsInvalid,
        'euiComboBox-isOpen': isListOpen
      });
      var value = selectedOptions.map(function (selectedOption) {
        return selectedOption.label;
      }).join(', ');
      var optionsList;

      if (!noSuggestions && isListOpen) {
        var optionsListDataTestSubj = dataTestSubj ? "".concat(dataTestSubj, "-optionsList") : undefined;
        optionsList = _react.default.createElement(_portal.EuiPortal, null, _react.default.createElement(_combo_box_options_list.EuiComboBoxOptionsList, {
          zIndex: this.state.listZIndex,
          activeOptionIndex: this.state.activeOptionIndex,
          areAllOptionsSelected: this.areAllOptionsSelected(),
          "data-test-subj": optionsListDataTestSubj,
          fullWidth: fullWidth,
          isLoading: isLoading,
          listRef: this.listRefCallback,
          matchingOptions: newMatchingOptions,
          onCloseList: this.closeList,
          onCreateOption: onCreateOption,
          onOptionClick: this.onOptionClick,
          onOptionEnterKey: this.onOptionEnterKey,
          onScroll: this.onOptionListScroll,
          optionRef: this.optionRefCallback,
          options: options,
          position: listPosition,
          singleSelection: singleSelection,
          renderOption: renderOption,
          rootId: this.rootId,
          rowHeight: rowHeight,
          scrollToIndex: activeOptionIndex,
          searchValue: searchValue,
          selectedOptions: selectedOptions,
          updatePosition: this.updatePosition,
          width: width,
          delimiter: delimiter,
          getSelectedOptionForSearchValue: _matching_options.getSelectedOptionForSearchValue
        }));
      }

      return (
        /**
         * Re: jsx-a11y/interactive-supports-focus
         * Focus is managed and is placed on the textbox element (`EuiComboBoxInput`)
         *
         * Re: jsx-a11y/role-has-required-aria-props
         * Expansion is managed and required `aria-controls` prop is placed on the textbox element (`EuiComboBoxInput`)
         *
         * Reference for both: https://www.w3.org/TR/2017/REC-wai-aria-1.1-20171214/#combobox,
         * which verifies that this implementation follows the spec.
         */
        // eslint-disable-next-line jsx-a11y/interactive-supports-focus
        _react.default.createElement("div", _extends({}, rest, {
          "aria-expanded": isListOpen,
          "aria-haspopup": "listbox",
          className: classes,
          "data-test-subj": dataTestSubj,
          onKeyDown: this.onKeyDown,
          ref: this.comboBoxRefCallback,
          role: "combobox"
        }), _react.default.createElement(_combo_box_input.EuiComboBoxInput, {
          autoSizeInputRef: this.autoSizeInputRefCallback,
          compressed: compressed,
          focusedOptionId: this.hasActiveOption() ? this.rootId("_option-".concat(this.state.activeOptionIndex)) : undefined,
          fullWidth: fullWidth,
          hasSelectedOptions: selectedOptions.length > 0,
          id: id,
          inputRef: this.searchInputRefCallback,
          isDisabled: isDisabled,
          isListOpen: isListOpen,
          noIcon: !!noSuggestions,
          onChange: this.onSearchChange,
          onClear: isClearable && !isDisabled ? this.clearSelectedOptions : undefined,
          onClick: this.onComboBoxClick,
          onCloseListClick: this.onCloseListClick,
          onFocus: this.onComboBoxFocus,
          onOpenListClick: this.onOpenListClick,
          onRemoveOption: this.onRemoveOption,
          placeholder: placeholder,
          rootId: this.rootId,
          searchValue: searchValue,
          selectedOptions: selectedOptions,
          singleSelection: singleSelection,
          toggleButtonRef: this.toggleButtonRefCallback,
          updatePosition: this.updatePosition,
          value: value,
          append: singleSelection ? append : undefined,
          prepend: singleSelection ? prepend : undefined
        }), optionsList)
      );
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var options = nextProps.options,
          selectedOptions = nextProps.selectedOptions,
          singleSelection = nextProps.singleSelection;
      var activeOptionIndex = prevState.activeOptionIndex,
          searchValue = prevState.searchValue; // Calculate and cache the options which match the searchValue, because we use this information
      // in multiple places and it would be expensive to calculate repeatedly.

      var matchingOptions = (0, _matching_options.getMatchingOptions)(options, selectedOptions, searchValue, nextProps.async, Boolean(singleSelection));
      var stateUpdate = {
        matchingOptions: matchingOptions
      };

      if (activeOptionIndex >= matchingOptions.length) {
        stateUpdate.activeOptionIndex = -1;
      }

      return stateUpdate;
    }
  }]);

  return EuiComboBox;
}(_react.Component);

exports.EuiComboBox = EuiComboBox;

_defineProperty(EuiComboBox, "defaultProps", {
  async: false,
  compressed: false,
  fullWidth: false,
  isClearable: true,
  options: [],
  selectedOptions: [],
  singleSelection: false,
  prepend: undefined,
  append: undefined,
  sortMatchesBy: 'none'
});

EuiComboBox.propTypes = {
  "data-test-subj": _propTypes.default.string,

  /**
     * Updates the list of options asynchronously
     */
  async: _propTypes.default.bool.isRequired,
  className: _propTypes.default.string,

  /**
     * When `true` creates a shorter height input
     */
  compressed: _propTypes.default.bool.isRequired,

  /**
     * When `true` expands to the entire width available
     */
  fullWidth: _propTypes.default.bool.isRequired,
  id: _propTypes.default.string,
  inputRef: _propTypes.default.any,

  /**
     * Shows a button that quickly clears any input
     */
  isClearable: _propTypes.default.bool.isRequired,

  /**
     * Disables the input
     */
  isDisabled: _propTypes.default.bool,
  isInvalid: _propTypes.default.bool,

  /**
     * Swaps the dropdown options for a loading spinner
     */
  isLoading: _propTypes.default.bool,

  /**
     * Doesn't show the suggestions list/dropdown
     */
  noSuggestions: _propTypes.default.bool,
  onBlur: _propTypes.default.any,

  /**
     * Called every time the query in the combo box is parsed
     */
  onChange: _propTypes.default.func,
  onFocus: _propTypes.default.any,
  onKeyDown: _propTypes.default.any,

  /**
     * Called every time the text query in the search box is parsed
     */
  onSearchChange: _propTypes.default.func,

  /**
     * Sets the placeholder of the input
     */
  placeholder: _propTypes.default.string,

  /**
     * Every option must be the same height and must be explicitly set if using a custom render
     */
  rowHeight: _propTypes.default.number,

  /**
     * When `true` only allows the user to select a single option. Set to `{ asPlainText: true }` to not render input selection as pills
     */
  singleSelection: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.shape({
    asPlainText: _propTypes.default.bool
  }).isRequired]).isRequired,

  /**
     * Display matching options by:
     * `startsWith`: moves items that start with search value to top of the list;
     * `none`: don't change the sort order of initial object
     */
  sortMatchesBy: _propTypes.default.oneOf(["none", "startsWith"]).isRequired,

  /**
     * Creates an input group with element(s) coming before input. It won't show if `singleSelection` is set to `false`.
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.any,

  /**
     * Creates an input group with element(s) coming after input. It won't show if `singleSelection` is set to `false`.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.any,

  /**
     * A special character to use as a value separator. Typically a comma `,`
     */
  delimiter: _propTypes.default.string,
  "aria-label": _propTypes.default.string
};
EuiComboBox.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "comboBoxRefCallback",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "ref",
      "type": null
    }],
    "returns": null
  }, {
    "name": "autoSizeInputRefCallback",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "ref",
      "type": null
    }],
    "returns": null
  }, {
    "name": "searchInputRefCallback",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "ref",
      "type": null
    }],
    "returns": null
  }, {
    "name": "listRefCallback",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "ref",
      "type": null
    }],
    "returns": null
  }, {
    "name": "toggleButtonRefCallback",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "ref",
      "type": null
    }],
    "returns": null
  }, {
    "name": "optionRefCallback",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "index",
      "type": null
    }, {
      "name": "ref",
      "type": null
    }],
    "returns": null
  }, {
    "name": "openList",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "closeList",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "updatePosition",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "listElement",
      "type": null
    }],
    "returns": null
  }, {
    "name": "incrementActiveOptionIndex",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "amount",
      "type": null
    }],
    "returns": null
  }, {
    "name": "hasActiveOption",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "clearActiveOption",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "clearSearchValue",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "removeLastOption",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "addCustomOption",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "isContainerBlur",
      "type": null
    }, {
      "name": "searchValue",
      "type": null
    }],
    "returns": null
  }, {
    "name": "doesSearchMatchOnlyOption",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "areAllOptionsSelected",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "isSingleSelectionCustomOption",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "onComboBoxFocus",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "setCustomOptions",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "isContainerBlur",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onContainerBlur",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onKeyDown",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onOptionEnterKey",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "option",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onOptionClick",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "option",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onAddOption",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "addedOption",
      "type": null
    }, {
      "name": "isContainerBlur",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onRemoveOption",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "removedOption",
      "type": null
    }],
    "returns": null
  }, {
    "name": "clearSelectedOptions",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "onComboBoxClick",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "onOpenListClick",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "onOptionListScroll",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "onCloseListClick",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "onSearchChange",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "searchValue",
      "type": null
    }],
    "returns": null
  }, {
    "name": "updateMatchingOptionsIfDifferent",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "newMatchingOptions",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiComboBox",
  "props": {
    "async": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Updates the list of options asynchronously"
    },
    "compressed": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "When `true` creates a shorter height input"
    },
    "fullWidth": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "When `true` expands to the entire width available"
    },
    "isClearable": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Shows a button that quickly clears any input"
    },
    "options": {
      "defaultValue": {
        "value": "[]",
        "computed": false
      },
      "required": false
    },
    "selectedOptions": {
      "defaultValue": {
        "value": "[]",
        "computed": false
      },
      "required": false
    },
    "singleSelection": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "bool"
        }, {
          "name": "shape",
          "value": {
            "asPlainText": {
              "name": "bool",
              "required": false
            }
          }
        }]
      },
      "required": false,
      "description": "When `true` only allows the user to select a single option. Set to `{ asPlainText: true }` to not render input selection as pills"
    },
    "prepend": {
      "defaultValue": {
        "value": "undefined",
        "computed": true
      },
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Creates an input group with element(s) coming before input. It won't show if `singleSelection` is set to `false`.\n`string` | `ReactElement` or an array of these"
    },
    "append": {
      "defaultValue": {
        "value": "undefined",
        "computed": true
      },
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Creates an input group with element(s) coming after input. It won't show if `singleSelection` is set to `false`.\n`string` | `ReactElement` or an array of these"
    },
    "sortMatchesBy": {
      "defaultValue": {
        "value": "'none'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"startsWith\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Display matching options by:\n`startsWith`: moves items that start with search value to top of the list;\n`none`: don't change the sort order of initial object"
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "id": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "inputRef": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "isDisabled": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Disables the input"
    },
    "isInvalid": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "isLoading": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Swaps the dropdown options for a loading spinner"
    },
    "noSuggestions": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Doesn't show the suggestions list/dropdown"
    },
    "onBlur": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "onChange": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "Called every time the query in the combo box is parsed"
    },
    "onFocus": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "onKeyDown": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "onSearchChange": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "Called every time the text query in the search box is parsed"
    },
    "placeholder": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Sets the placeholder of the input"
    },
    "rowHeight": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": "Every option must be the same height and must be explicitly set if using a custom render"
    },
    "delimiter": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "A special character to use as a value separator. Typically a comma `,`"
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};