'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getParentAutofocusables = exports.getFocusables = undefined;

var _tabbables = require('./tabbables');

var _tabbables2 = _interopRequireDefault(_tabbables);

var _array = require('./array');

var _constants = require('../constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getFocusables = exports.getFocusables = function getFocusables(parents) {
  return parents.reduce(function (acc, parent) {
    return acc.concat((0, _array.toArray)(parent.querySelectorAll(_tabbables2.default.join(','))));
  }, []);
};

var getParentAutofocusables = exports.getParentAutofocusables = function getParentAutofocusables(parent) {
  var parentFocus = parent.querySelectorAll('[' + _constants.FOCUS_AUTO + ']');
  return (0, _array.toArray)(parentFocus).map(function (node) {
    return getFocusables([node]);
  }).reduce(function (acc, nodes) {
    return acc.concat(nodes);
  }, []);
};