function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component, Fragment } from 'react';
import { i18n } from '@kbn/i18n';
import { injectI18n, FormattedMessage } from '@kbn/i18n/react';
import { EuiButtonEmpty, EuiFlexGroup, EuiFlexItem, EuiHeaderSectionItemButton, EuiIcon, EuiPopover, EuiPopoverTitle, EuiSpacer, EuiTitle, EuiHorizontalRule } from '@elastic/eui';
import { combineLatest } from 'rxjs';
import { HeaderExtension } from './header_extension';
import { GITHUB_CREATE_ISSUE_LINK, KIBANA_FEEDBACK_LINK } from '../../constants';
/** @public */

var HeaderHelpMenuUI = /*#__PURE__*/function (_Component) {
  _inherits(HeaderHelpMenuUI, _Component);

  var _super = _createSuper(HeaderHelpMenuUI);

  function HeaderHelpMenuUI(props) {
    var _this;

    _classCallCheck(this, HeaderHelpMenuUI);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "subscription", void 0);

    _defineProperty(_assertThisInitialized(_this), "createGithubUrl", function (labels, title) {
      var url = new URL('https://github.com/elastic/kibana/issues/new?');

      if (labels.length) {
        url.searchParams.set('labels', labels.join(','));
      }

      if (title) {
        url.searchParams.set('title', title);
      }

      return url.toString();
    });

    _defineProperty(_assertThisInitialized(_this), "createCustomLink", function (index, text, addSpacer, buttonProps) {
      return /*#__PURE__*/React.createElement(Fragment, {
        key: "helpButton".concat(index)
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, _extends({}, buttonProps, {
        size: "xs",
        flush: "left"
      }), text), addSpacer && /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "xs"
      }));
    });

    _defineProperty(_assertThisInitialized(_this), "onMenuButtonClick", function () {
      _this.setState({
        isOpen: !_this.state.isOpen
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closeMenu", function () {
      _this.setState({
        isOpen: false
      });
    });

    _this.state = {
      isOpen: false,
      helpExtension: undefined,
      helpSupportUrl: ''
    };
    return _this;
  }

  _createClass(HeaderHelpMenuUI, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this.subscription = combineLatest(this.props.helpExtension$, this.props.helpSupportUrl$).subscribe(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            helpExtension = _ref2[0],
            helpSupportUrl = _ref2[1];

        _this2.setState({
          helpExtension: helpExtension,
          helpSupportUrl: helpSupportUrl
        });
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.subscription) {
        this.subscription.unsubscribe();
        this.subscription = undefined;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props = this.props,
          intl = _this$props.intl,
          kibanaVersion = _this$props.kibanaVersion,
          useDefaultContent = _this$props.useDefaultContent,
          kibanaDocLink = _this$props.kibanaDocLink;
      var _this$state = this.state,
          helpExtension = _this$state.helpExtension,
          helpSupportUrl = _this$state.helpSupportUrl;
      var defaultContent = useDefaultContent ? /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        href: kibanaDocLink,
        target: "_blank",
        size: "xs",
        flush: "left"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "core.ui.chrome.headerGlobalNav.helpMenuKibanaDocumentationTitle",
        defaultMessage: "Kibana documentation"
      })), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "xs"
      }), /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        href: helpSupportUrl,
        target: "_blank",
        size: "xs",
        flush: "left"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "core.ui.chrome.headerGlobalNav.helpMenuAskElasticTitle",
        defaultMessage: "Ask Elastic"
      })), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "xs"
      }), /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        href: KIBANA_FEEDBACK_LINK,
        target: "_blank",
        size: "xs",
        flush: "left"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "core.ui.chrome.headerGlobalNav.helpMenuGiveFeedbackTitle",
        defaultMessage: "Give feedback"
      })), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "xs"
      }), /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        href: GITHUB_CREATE_ISSUE_LINK,
        target: "_blank",
        size: "xs",
        iconType: "logoGithub",
        flush: "left"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "core.ui.chrome.headerGlobalNav.helpMenuOpenGitHubIssueTitle",
        defaultMessage: "Open an issue in GitHub"
      }))) : null;
      var customContent;

      if (helpExtension) {
        var appName = helpExtension.appName,
            links = helpExtension.links,
            content = helpExtension.content;

        var getFeedbackText = function getFeedbackText() {
          return i18n.translate('core.ui.chrome.headerGlobalNav.helpMenuGiveFeedbackOnApp', {
            defaultMessage: 'Give feedback on {appName}',
            values: {
              appName: helpExtension.appName
            }
          });
        };

        var customLinks = links && links.map(function (link, index) {
          var linkType = link.linkType,
              title = link.title,
              _link$labels = link.labels,
              labels = _link$labels === void 0 ? [] : _link$labels,
              text = link.content,
              rest = _objectWithoutProperties(link, ["linkType", "title", "labels", "content"]);

          switch (linkType) {
            case 'documentation':
              return _this3.createCustomLink(index, /*#__PURE__*/React.createElement(FormattedMessage, {
                id: "core.ui.chrome.headerGlobalNav.helpMenuDocumentation",
                defaultMessage: "Documentation"
              }), index < links.length - 1, _objectSpread({
                target: '_blank',
                rel: 'noopener'
              }, rest));

            case 'github':
              return _this3.createCustomLink(index, getFeedbackText(), index < links.length - 1, _objectSpread({
                iconType: 'logoGithub',
                href: _this3.createGithubUrl(labels, title),
                target: '_blank',
                rel: 'noopener'
              }, rest));

            case 'discuss':
              return _this3.createCustomLink(index, getFeedbackText(), index < links.length - 1, _objectSpread({
                iconType: 'editorComment',
                target: '_blank',
                rel: 'noopener'
              }, rest));

            case 'custom':
              return _this3.createCustomLink(index, text, index < links.length - 1, _objectSpread({}, rest));

            default:
              break;
          }
        });
        customContent = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiTitle, {
          size: "xxs"
        }, /*#__PURE__*/React.createElement("h3", null, appName)), /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "s"
        }), customLinks, content && /*#__PURE__*/React.createElement(React.Fragment, null, customLinks && /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "s"
        }), /*#__PURE__*/React.createElement(HeaderExtension, {
          extension: content
        })));
      }

      var button = /*#__PURE__*/React.createElement(EuiHeaderSectionItemButton, {
        "aria-expanded": this.state.isOpen,
        "aria-haspopup": "true",
        "aria-label": intl.formatMessage({
          id: 'core.ui.chrome.headerGlobalNav.helpMenuButtonAriaLabel',
          defaultMessage: 'Help menu'
        }),
        onClick: this.onMenuButtonClick
      }, /*#__PURE__*/React.createElement(EuiIcon, {
        type: "help",
        size: "m"
      }));
      return /*#__PURE__*/React.createElement(EuiPopover, {
        anchorPosition: "downRight",
        button: button,
        closePopover: this.closeMenu,
        "data-test-subj": "helpMenuButton",
        id: "headerHelpMenu",
        isOpen: this.state.isOpen,
        ownFocus: true,
        repositionOnScroll: true
      }, /*#__PURE__*/React.createElement(EuiPopoverTitle, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        responsive: false
      }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "core.ui.chrome.headerGlobalNav.helpMenuTitle",
        defaultMessage: "Help"
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false,
        className: "chrHeaderHelpMenu__version"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "core.ui.chrome.headerGlobalNav.helpMenuVersion",
        defaultMessage: "v {version}",
        values: {
          version: kibanaVersion
        }
      })))), /*#__PURE__*/React.createElement("div", {
        style: {
          maxWidth: 240
        }
      }, defaultContent, defaultContent && customContent && /*#__PURE__*/React.createElement(EuiHorizontalRule, {
        margin: "m"
      }), customContent));
    }
  }]);

  return HeaderHelpMenuUI;
}(Component);

export var HeaderHelpMenu = injectI18n(HeaderHelpMenuUI);
HeaderHelpMenu.defaultProps = {
  useDefaultContent: true
};