function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { render, unmountComponentAtNode } from 'react-dom';
import { GlobalToastList } from './global_toast_list';
import { ToastsApi } from './toasts_api';
export var ToastsService = /*#__PURE__*/function () {
  function ToastsService() {
    _classCallCheck(this, ToastsService);

    _defineProperty(this, "api", void 0);

    _defineProperty(this, "targetDomElement", void 0);
  }

  _createClass(ToastsService, [{
    key: "setup",
    value: function setup(_ref) {
      var uiSettings = _ref.uiSettings;
      this.api = new ToastsApi({
        uiSettings: uiSettings
      });
      return this.api;
    }
  }, {
    key: "start",
    value: function start(_ref2) {
      var _this = this;

      var i18n = _ref2.i18n,
          overlays = _ref2.overlays,
          targetDomElement = _ref2.targetDomElement;
      this.api.start({
        overlays: overlays,
        i18n: i18n
      });
      this.targetDomElement = targetDomElement;
      render( /*#__PURE__*/React.createElement(i18n.Context, null, /*#__PURE__*/React.createElement(GlobalToastList, {
        dismissToast: function dismissToast(toastId) {
          return _this.api.remove(toastId);
        },
        toasts$: this.api.get$()
      })), targetDomElement);
      return this.api;
    }
  }, {
    key: "stop",
    value: function stop() {
      if (this.targetDomElement) {
        unmountComponentAtNode(this.targetDomElement);
        this.targetDomElement.textContent = '';
      }
    }
  }]);

  return ToastsService;
}();