/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { coreMock } from '../../../../../../../src/core/public/mocks';
import { AggTypesRegistry } from '../agg_types_registry';
import { getAggTypes } from '../agg_types';
import { BucketAggType } from '../buckets/bucket_agg_type';
import { MetricAggType } from '../metrics/metric_agg_type';
import { fieldFormatsServiceMock } from '../../../field_formats/mocks';
// Mocked uiSettings shared among aggs unit tests
var mockUiSettings = jest.fn().mockImplementation(function (key) {
  var _config$key;

  var config = {
    'histogram:maxBars': 4,
    'histogram:barTarget': 3,
    dateFormat: 'YYYY-MM-DD',
    'dateFormat:scaled': [['', 'HH:mm:ss.SSS'], ['PT1S', 'HH:mm:ss'], ['PT1M', 'HH:mm'], ['PT1H', 'YYYY-MM-DD HH:mm'], ['P1DT', 'YYYY-MM-DD'], ['P1YT', 'YYYY']]
  };
  return (_config$key = config[key]) !== null && _config$key !== void 0 ? _config$key : key;
});
/**
 * Testing utility which creates a new instance of AggTypesRegistry,
 * registers the provided agg types, and returns AggTypesRegistry.start()
 *
 * This is useful if your test depends on a certain agg type to be present
 * in the registry.
 *
 * @param [types] - Optional array of AggTypes to register.
 * If no value is provided, all default types will be registered.
 *
 * @internal
 */

export function mockAggTypesRegistry(types) {
  var registry = new AggTypesRegistry();
  var registrySetup = registry.setup();

  if (types) {
    types.forEach(function (type) {
      if (type instanceof BucketAggType) {
        registrySetup.registerBucket(type);
      } else if (type instanceof MetricAggType) {
        registrySetup.registerMetric(type);
      }
    });
  } else {
    var coreSetup = coreMock.createSetup();
    coreSetup.uiSettings.get = mockUiSettings;
    var aggTypes = getAggTypes({
      calculateBounds: jest.fn(),
      getInternalStartServices: function getInternalStartServices() {
        return {
          fieldFormats: fieldFormatsServiceMock.createStartContract()
        };
      },
      uiSettings: coreSetup.uiSettings
    });
    aggTypes.buckets.forEach(function (type) {
      return registrySetup.registerBucket(type);
    });
    aggTypes.metrics.forEach(function (type) {
      return registrySetup.registerMetric(type);
    });
  }

  return registry.start();
}