function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get, hasIn } from 'lodash';
import { i18n } from '@kbn/i18n';
import { calculateObjectHash } from '../../../../../plugins/kibana_utils/public';
import { tabifyAggResponse } from '../tabify';
import { calculateBounds, getTime, isRangeFilter } from '../../../common';
import { getFieldFormats, getIndexPatterns, getQueryService, getSearchService } from '../../services';
import { buildTabularInspectorData } from './build_tabular_inspector_data';
import { getRequestInspectorStats, getResponseInspectorStats, serializeAggConfig } from './utils';
var name = 'esaggs';

var handleCourierRequest = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
    var _indexPattern$getTime;

    var searchSource, aggs, timeRange, timeFields, indexPattern, query, filters, forceFetch, partialRows, metricsAtAllLevels, inspectorAdapters, filterManager, abortSignal, timeFilterSearchSource, requestSearchSource, defaultTimeField, defaultTimeFields, allTimeFields, reqBody, queryHash, shouldQuery, request, response, resp, _iterator, _step, agg, parsedTimeRange, tabifyParams, tabifyCacheHash, shouldCalculateNewTabify;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            searchSource = _ref.searchSource, aggs = _ref.aggs, timeRange = _ref.timeRange, timeFields = _ref.timeFields, indexPattern = _ref.indexPattern, query = _ref.query, filters = _ref.filters, forceFetch = _ref.forceFetch, partialRows = _ref.partialRows, metricsAtAllLevels = _ref.metricsAtAllLevels, inspectorAdapters = _ref.inspectorAdapters, filterManager = _ref.filterManager, abortSignal = _ref.abortSignal;
            // Create a new search source that inherits the original search source
            // but has the appropriate timeRange applied via a filter.
            // This is a temporary solution until we properly pass down all required
            // information for the request to the request handler (https://github.com/elastic/kibana/issues/16641).
            // Using callParentStartHandlers: true we make sure, that the parent searchSource
            // onSearchRequestStart will be called properly even though we use an inherited
            // search source.
            timeFilterSearchSource = searchSource.createChild({
              callParentStartHandlers: true
            });
            requestSearchSource = timeFilterSearchSource.createChild({
              callParentStartHandlers: true
            });
            aggs.setTimeRange(timeRange); // For now we need to mirror the history of the passed search source, since
            // the request inspector wouldn't work otherwise.

            Object.defineProperty(requestSearchSource, 'history', {
              get: function get() {
                return searchSource.history;
              },
              set: function set(history) {
                return searchSource.history = history;
              }
            });
            requestSearchSource.setField('aggs', function () {
              return aggs.toDsl(metricsAtAllLevels);
            });
            requestSearchSource.onRequestStart(function (paramSearchSource, options) {
              return aggs.onSearchRequestStart(paramSearchSource, options);
            }); // If timeFields have been specified, use the specified ones, otherwise use primary time field of index
            // pattern if it's available.

            defaultTimeField = indexPattern === null || indexPattern === void 0 ? void 0 : (_indexPattern$getTime = indexPattern.getTimeField) === null || _indexPattern$getTime === void 0 ? void 0 : _indexPattern$getTime.call(indexPattern);
            defaultTimeFields = defaultTimeField ? [defaultTimeField.name] : [];
            allTimeFields = timeFields && timeFields.length > 0 ? timeFields : defaultTimeFields; // If a timeRange has been specified and we had at least one timeField available, create range
            // filters for that those time fields

            if (timeRange && allTimeFields.length > 0) {
              timeFilterSearchSource.setField('filter', function () {
                return allTimeFields.map(function (fieldName) {
                  return getTime(indexPattern, timeRange, {
                    fieldName: fieldName
                  });
                }).filter(isRangeFilter);
              });
            }

            requestSearchSource.setField('filter', filters);
            requestSearchSource.setField('query', query);
            _context.next = 15;
            return requestSearchSource.getSearchRequestBody();

          case 15:
            reqBody = _context.sent;
            queryHash = calculateObjectHash(reqBody); // We only need to reexecute the query, if forceFetch was true or the hash of the request body has changed
            // since the last request

            shouldQuery = forceFetch || searchSource.lastQuery !== queryHash;

            if (!shouldQuery) {
              _context.next = 38;
              break;
            }

            inspectorAdapters.requests.reset();
            request = inspectorAdapters.requests.start(i18n.translate('data.functions.esaggs.inspector.dataRequest.title', {
              defaultMessage: 'Data'
            }), {
              description: i18n.translate('data.functions.esaggs.inspector.dataRequest.description', {
                defaultMessage: 'This request queries Elasticsearch to fetch the data for the visualization.'
              })
            });
            request.stats(getRequestInspectorStats(requestSearchSource));
            _context.prev = 22;
            _context.next = 25;
            return requestSearchSource.fetch({
              abortSignal: abortSignal
            });

          case 25:
            response = _context.sent;
            searchSource.lastQuery = queryHash;
            request.stats(getResponseInspectorStats(searchSource, response)).ok({
              json: response
            });
            searchSource.rawResponse = response;
            _context.next = 35;
            break;

          case 31:
            _context.prev = 31;
            _context.t0 = _context["catch"](22);
            // Log any error during request to the inspector
            request.error({
              json: _context.t0
            });
            throw _context.t0;

          case 35:
            _context.prev = 35;
            // Add the request body no matter if things went fine or not
            requestSearchSource.getSearchRequestBody().then(function (req) {
              request.json(req);
            });
            return _context.finish(35);

          case 38:
            // Note that rawResponse is not deeply cloned here, so downstream applications using courier
            // must take care not to mutate it, or it could have unintended side effects, e.g. displaying
            // response data incorrectly in the inspector.
            resp = searchSource.rawResponse;
            _iterator = _createForOfIteratorHelper(aggs.aggs);
            _context.prev = 40;

            _iterator.s();

          case 42:
            if ((_step = _iterator.n()).done) {
              _context.next = 50;
              break;
            }

            agg = _step.value;

            if (!hasIn(agg, 'type.postFlightRequest')) {
              _context.next = 48;
              break;
            }

            _context.next = 47;
            return agg.type.postFlightRequest(resp, aggs, agg, requestSearchSource, inspectorAdapters.requests, abortSignal);

          case 47:
            resp = _context.sent;

          case 48:
            _context.next = 42;
            break;

          case 50:
            _context.next = 55;
            break;

          case 52:
            _context.prev = 52;
            _context.t1 = _context["catch"](40);

            _iterator.e(_context.t1);

          case 55:
            _context.prev = 55;

            _iterator.f();

            return _context.finish(55);

          case 58:
            searchSource.finalResponse = resp;
            parsedTimeRange = timeRange ? calculateBounds(timeRange) : null;
            tabifyParams = {
              metricsAtAllLevels: metricsAtAllLevels,
              partialRows: partialRows,
              timeRange: parsedTimeRange ? {
                from: parsedTimeRange.min,
                to: parsedTimeRange.max,
                timeFields: allTimeFields
              } : undefined
            };
            tabifyCacheHash = calculateObjectHash(_objectSpread({
              tabifyAggs: aggs
            }, tabifyParams)); // We only need to reexecute tabify, if either we did a new request or some input params to tabify changed

            shouldCalculateNewTabify = shouldQuery || searchSource.lastTabifyHash !== tabifyCacheHash;

            if (shouldCalculateNewTabify) {
              searchSource.lastTabifyHash = tabifyCacheHash;
              searchSource.tabifiedResponse = tabifyAggResponse(aggs, searchSource.finalResponse, tabifyParams);
            }

            inspectorAdapters.data.setTabularLoader(function () {
              return buildTabularInspectorData(searchSource.tabifiedResponse, {
                queryFilter: filterManager,
                deserializeFieldFormat: getFieldFormats().deserialize
              });
            }, {
              returnsFormattedValues: true
            });
            return _context.abrupt("return", searchSource.tabifiedResponse);

          case 66:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[22, 31, 35, 38], [40, 52, 55, 58]]);
  }));

  return function handleCourierRequest(_x) {
    return _ref2.apply(this, arguments);
  };
}();

export var esaggs = function esaggs() {
  return {
    name: name,
    type: 'kibana_datatable',
    inputTypes: ['kibana_context', 'null'],
    help: i18n.translate('data.functions.esaggs.help', {
      defaultMessage: 'Run AggConfig aggregation'
    }),
    args: {
      index: {
        types: ['string'],
        help: ''
      },
      metricsAtAllLevels: {
        types: ['boolean'],
        default: false,
        help: ''
      },
      partialRows: {
        types: ['boolean'],
        default: false,
        help: ''
      },
      includeFormatHints: {
        types: ['boolean'],
        default: false,
        help: ''
      },
      aggConfigs: {
        types: ['string'],
        default: '""',
        help: ''
      },
      timeFields: {
        types: ['string'],
        help: '',
        multi: true
      }
    },
    fn: function fn(input, args, _ref3) {
      return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        var inspectorAdapters, abortSignal, indexPatterns, _getQueryService, filterManager, searchService, aggConfigsState, indexPattern, aggs, searchSource, response, table;

        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                inspectorAdapters = _ref3.inspectorAdapters, abortSignal = _ref3.abortSignal;
                indexPatterns = getIndexPatterns();
                _getQueryService = getQueryService(), filterManager = _getQueryService.filterManager;
                searchService = getSearchService();
                aggConfigsState = JSON.parse(args.aggConfigs);
                _context2.next = 7;
                return indexPatterns.get(args.index);

              case 7:
                indexPattern = _context2.sent;
                aggs = searchService.aggs.createAggConfigs(indexPattern, aggConfigsState); // we should move searchSource creation inside courier request handler

                _context2.next = 11;
                return searchService.searchSource.create();

              case 11:
                searchSource = _context2.sent;
                searchSource.setField('index', indexPattern);
                searchSource.setField('size', 0);
                _context2.next = 16;
                return handleCourierRequest({
                  searchSource: searchSource,
                  aggs: aggs,
                  indexPattern: indexPattern,
                  timeRange: get(input, 'timeRange', undefined),
                  query: get(input, 'query', undefined),
                  filters: get(input, 'filters', undefined),
                  timeFields: args.timeFields,
                  forceFetch: true,
                  metricsAtAllLevels: args.metricsAtAllLevels,
                  partialRows: args.partialRows,
                  inspectorAdapters: inspectorAdapters,
                  filterManager: filterManager,
                  abortSignal: abortSignal
                });

              case 16:
                response = _context2.sent;
                table = {
                  type: 'kibana_datatable',
                  rows: response.rows,
                  columns: response.columns.map(function (column) {
                    var cleanedColumn = {
                      id: column.id,
                      name: column.name,
                      meta: serializeAggConfig(column.aggConfig)
                    };

                    if (args.includeFormatHints) {
                      cleanedColumn.formatHint = column.aggConfig.toSerializedFieldFormat();
                    }

                    return cleanedColumn;
                  })
                };
                return _context2.abrupt("return", table);

              case 19:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }))();
    }
  };
};