function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get } from 'lodash';
import { TabbedAggResponseWriter } from './response_writer';
import { TabifyBuckets } from './buckets';
import { AggGroupNames } from '../aggs';
/**
 * Sets up the ResponseWriter and kicks off bucket collection.
 */

export function tabifyAggResponse(aggConfigs, esResponse, respOpts) {
  /**
   * read an aggregation from a bucket, which *might* be found at key (if
   * the response came in object form), and will recurse down the aggregation
   * tree and will pass the read values to the ResponseWriter.
   */
  function collectBucket(aggs, write, bucket, key, aggScale) {
    var column = write.columns.shift();

    if (column) {
      var agg = column.aggConfig;
      var aggInfo = agg.write(aggs);
      aggScale *= aggInfo.metricScale || 1;

      switch (agg.type.type) {
        case AggGroupNames.Buckets:
          var aggBucket = get(bucket, agg.id);
          var tabifyBuckets = new TabifyBuckets(aggBucket, agg.params, respOpts === null || respOpts === void 0 ? void 0 : respOpts.timeRange);

          if (tabifyBuckets.length) {
            tabifyBuckets.forEach(function (subBucket, tabifyBucketKey) {
              // if the bucket doesn't have value don't add it to the row
              // we don't want rows like: { column1: undefined, column2: 10 }
              var bucketValue = agg.getKey(subBucket, tabifyBucketKey);
              var hasBucketValue = typeof bucketValue !== 'undefined';

              if (hasBucketValue) {
                write.bucketBuffer.push({
                  id: column.id,
                  value: bucketValue
                });
              }

              collectBucket(aggs, write, subBucket, agg.getKey(subBucket, tabifyBucketKey), aggScale);

              if (hasBucketValue) {
                write.bucketBuffer.pop();
              }
            });
          } else if (respOpts === null || respOpts === void 0 ? void 0 : respOpts.partialRows) {
            // we don't have any buckets, but we do have metrics at this
            // level, then pass all the empty buckets and jump back in for
            // the metrics.
            write.columns.unshift(column);
            passEmptyBuckets(aggs, write, bucket, key, aggScale);
            write.columns.shift();
          } else {
            // we don't have any buckets, and we don't have isHierarchical
            // data, so no metrics, just try to write the row
            write.row();
          }

          break;

        case AggGroupNames.Metrics:
          var value = agg.getValue(bucket); // since the aggregation could be a non integer (such as a max date)
          // only do the scaling calculation if it is needed.

          if (aggScale !== 1) {
            value *= aggScale;
          }

          write.metricBuffer.push({
            id: column.id,
            value: value
          });

          if (!write.columns.length) {
            // row complete
            write.row();
          } else {
            // process the next agg at this same level
            collectBucket(aggs, write, bucket, key, aggScale);
          }

          write.metricBuffer.pop();
          break;
      }

      write.columns.unshift(column);
    }
  } // write empty values for each bucket agg, then write
  // the metrics from the initial bucket using collectBucket()


  function passEmptyBuckets(aggs, write, bucket, key, aggScale) {
    var column = write.columns.shift();

    if (column) {
      var agg = column.aggConfig;

      switch (agg.type.type) {
        case AggGroupNames.Metrics:
          // pass control back to collectBucket()
          write.columns.unshift(column);
          collectBucket(aggs, write, bucket, key, aggScale);
          return;

        case AggGroupNames.Buckets:
          passEmptyBuckets(aggs, write, bucket, key, aggScale);
      }

      write.columns.unshift(column);
    }
  }

  var write = new TabbedAggResponseWriter(aggConfigs, respOpts || {});

  var topLevelBucket = _objectSpread(_objectSpread({}, esResponse.aggregations), {}, {
    doc_count: esResponse.hits.total
  });

  collectBucket(aggConfigs, write, topLevelBucket, '', 1);
  return write.response();
}