function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiFormRow } from '@elastic/eui';
import { injectI18n } from '@kbn/i18n/react';
import { uniq } from 'lodash';
import React from 'react';
import { GenericComboBox } from './generic_combo_box';
import { PhraseSuggestorUI } from './phrase_suggestor';
import { ValueInputType } from './value_input_type';
import { withKibana } from '../../../../../kibana_react/public';

var PhraseValueInputUI = /*#__PURE__*/function (_PhraseSuggestorUI) {
  _inherits(PhraseValueInputUI, _PhraseSuggestorUI);

  var _super = _createSuper(PhraseValueInputUI);

  function PhraseValueInputUI() {
    _classCallCheck(this, PhraseValueInputUI);

    return _super.apply(this, arguments);
  }

  _createClass(PhraseValueInputUI, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(EuiFormRow, {
        label: this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.valueInputLabel',
          defaultMessage: 'Value'
        })
      }, this.isSuggestingValues() ? this.renderWithSuggestions() : /*#__PURE__*/React.createElement(ValueInputType, {
        placeholder: this.props.intl.formatMessage({
          id: 'data.filter.filterEditor.valueInputPlaceholder',
          defaultMessage: 'Enter a value'
        }),
        value: this.props.value,
        onChange: this.props.onChange,
        type: this.props.field ? this.props.field.type : 'string'
      }));
    }
  }, {
    key: "renderWithSuggestions",
    value: function renderWithSuggestions() {
      var suggestions = this.state.suggestions;
      var _this$props = this.props,
          value = _this$props.value,
          intl = _this$props.intl,
          _onChange = _this$props.onChange; // there are cases when the value is a number, this would cause an exception

      var valueAsStr = String(value);
      var options = value ? uniq([valueAsStr].concat(_toConsumableArray(suggestions))) : suggestions;
      return /*#__PURE__*/React.createElement(StringComboBox, {
        placeholder: intl.formatMessage({
          id: 'data.filter.filterEditor.valueSelectPlaceholder',
          defaultMessage: 'Select a value'
        }),
        options: options,
        getLabel: function getLabel(option) {
          return option;
        },
        selectedOptions: value ? [valueAsStr] : [],
        onChange: function onChange(_ref) {
          var _ref2 = _slicedToArray(_ref, 1),
              _ref2$ = _ref2[0],
              newValue = _ref2$ === void 0 ? '' : _ref2$;

          return _onChange(newValue);
        },
        onSearchChange: this.onSearchChange,
        singleSelection: {
          asPlainText: true
        },
        onCreateOption: _onChange,
        isClearable: false,
        "data-test-subj": "filterParamsComboBox phraseParamsComboxBox"
      });
    }
  }]);

  return PhraseValueInputUI;
}(PhraseSuggestorUI);

function StringComboBox(props) {
  return GenericComboBox(props);
}

export var PhraseValueInput = injectI18n(withKibana(PhraseValueInputUI));