function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { Component } from 'react';
import React from 'react';
import { i18n } from '@kbn/i18n';
import { EuiTextArea, EuiOutsideClickDetector, EuiFlexGroup, EuiFlexItem, EuiButton, EuiLink, htmlIdGenerator } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { debounce, compact, isEqual, isFunction } from 'lodash';
import { QuerySuggestionTypes } from '../../autocomplete';
import { withKibana, toMountPoint } from '../../../../kibana_react/public';
import { fetchIndexPatterns } from './fetch_index_patterns';
import { QueryLanguageSwitcher } from './language_switcher';
import { getQueryLog, matchPairs, toUser, fromUser } from '../../query';
import { SuggestionsComponent } from '..';
var KEY_CODES = {
  LEFT: 37,
  UP: 38,
  RIGHT: 39,
  DOWN: 40,
  ENTER: 13,
  ESC: 27,
  TAB: 9,
  HOME: 36,
  END: 35
};
export var QueryStringInputUI = /*#__PURE__*/function (_Component) {
  _inherits(QueryStringInputUI, _Component);

  var _super = _createSuper(QueryStringInputUI);

  function QueryStringInputUI() {
    var _this;

    _classCallCheck(this, QueryStringInputUI);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isSuggestionsVisible: false,
      index: null,
      suggestions: [],
      suggestionLimit: 50,
      selectionStart: null,
      selectionEnd: null,
      indexPatterns: []
    });

    _defineProperty(_assertThisInitialized(_this), "inputRef", null);

    _defineProperty(_assertThisInitialized(_this), "persistedLog", void 0);

    _defineProperty(_assertThisInitialized(_this), "abortController", void 0);

    _defineProperty(_assertThisInitialized(_this), "services", _this.props.kibana.services);

    _defineProperty(_assertThisInitialized(_this), "componentIsUnmounting", false);

    _defineProperty(_assertThisInitialized(_this), "getQueryString", function () {
      return toUser(_this.props.query.query);
    });

    _defineProperty(_assertThisInitialized(_this), "fetchIndexPatterns", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var stringPatterns, objectPatterns, objectPatternsFromStrings;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              stringPatterns = _this.props.indexPatterns.filter(function (indexPattern) {
                return typeof indexPattern === 'string';
              });
              objectPatterns = _this.props.indexPatterns.filter(function (indexPattern) {
                return typeof indexPattern !== 'string';
              });
              _context.next = 4;
              return fetchIndexPatterns(_this.services.savedObjects.client, stringPatterns, _this.services.uiSettings);

            case 4:
              objectPatternsFromStrings = _context.sent;

              _this.setState({
                indexPatterns: [].concat(_toConsumableArray(objectPatterns), _toConsumableArray(objectPatternsFromStrings))
              });

            case 6:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(_assertThisInitialized(_this), "getSuggestions", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var language, queryString, recentSearchSuggestions, hasQuerySuggestions, indexPatterns, _this$inputRef, selectionStart, selectionEnd, suggestions;

      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              if (_this.inputRef) {
                _context2.next = 2;
                break;
              }

              return _context2.abrupt("return");

            case 2:
              language = _this.props.query.language;
              queryString = _this.getQueryString();
              recentSearchSuggestions = _this.getRecentSearchSuggestions(queryString);
              hasQuerySuggestions = _this.services.data.autocomplete.hasQuerySuggestions(language);

              if (!(!hasQuerySuggestions || !Array.isArray(_this.state.indexPatterns) || compact(_this.state.indexPatterns).length === 0)) {
                _context2.next = 8;
                break;
              }

              return _context2.abrupt("return", recentSearchSuggestions);

            case 8:
              indexPatterns = _this.state.indexPatterns;
              _this$inputRef = _this.inputRef, selectionStart = _this$inputRef.selectionStart, selectionEnd = _this$inputRef.selectionEnd;

              if (!(selectionStart === null || selectionEnd === null)) {
                _context2.next = 12;
                break;
              }

              return _context2.abrupt("return");

            case 12:
              _context2.prev = 12;
              if (_this.abortController) _this.abortController.abort();
              _this.abortController = new AbortController();
              _context2.next = 17;
              return _this.services.data.autocomplete.getQuerySuggestions({
                language: language,
                indexPatterns: indexPatterns,
                query: queryString,
                selectionStart: selectionStart,
                selectionEnd: selectionEnd,
                signal: _this.abortController.signal
              });

            case 17:
              _context2.t0 = _context2.sent;

              if (_context2.t0) {
                _context2.next = 20;
                break;
              }

              _context2.t0 = [];

            case 20:
              suggestions = _context2.t0;
              return _context2.abrupt("return", [].concat(_toConsumableArray(suggestions), _toConsumableArray(recentSearchSuggestions)));

            case 24:
              _context2.prev = 24;
              _context2.t1 = _context2["catch"](12);

              if (!(_context2.t1.message === 'The user aborted a request.')) {
                _context2.next = 28;
                break;
              }

              return _context2.abrupt("return");

            case 28:
              throw _context2.t1;

            case 29:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, null, [[12, 24]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "getRecentSearchSuggestions", function (query) {
      if (!_this.persistedLog) {
        return [];
      }

      var recentSearches = _this.persistedLog.get();

      var matchingRecentSearches = recentSearches.filter(function (recentQuery) {
        var recentQueryString = _typeof(recentQuery) === 'object' ? toUser(recentQuery) : recentQuery;
        return recentQueryString.includes(query);
      });
      return matchingRecentSearches.map(function (recentSearch) {
        var text = toUser(recentSearch);
        var start = 0;
        var end = query.length;
        return {
          type: QuerySuggestionTypes.RecentSearch,
          text: text,
          start: start,
          end: end
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "updateSuggestions", debounce( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
      var suggestions;
      return regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return _this.getSuggestions();

            case 2:
              _context3.t0 = _context3.sent;

              if (_context3.t0) {
                _context3.next = 5;
                break;
              }

              _context3.t0 = [];

            case 5:
              suggestions = _context3.t0;

              if (!_this.componentIsUnmounting) {
                _this.setState({
                  suggestions: suggestions
                });
              }

            case 7:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3);
    })), 100));

    _defineProperty(_assertThisInitialized(_this), "onSubmit", function (query) {
      if (_this.props.onSubmit) {
        if (_this.persistedLog) {
          _this.persistedLog.add(query.query);
        }

        _this.props.onSubmit({
          query: fromUser(query.query),
          language: query.language
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onChange", function (query) {
      _this.updateSuggestions();

      if (_this.props.onChange) {
        _this.props.onChange({
          query: fromUser(query.query),
          language: query.language
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onQueryStringChange", function (value) {
      _this.setState({
        isSuggestionsVisible: true,
        index: null,
        suggestionLimit: 50
      });

      _this.onChange({
        query: value,
        language: _this.props.query.language
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onInputChange", function (event) {
      _this.onQueryStringChange(event.target.value);

      if (event.target.value === '') {
        _this.handleRemoveHeight();
      } else {
        _this.handleAutoHeight();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onClickInput", function (event) {
      if (event.target instanceof HTMLTextAreaElement) {
        _this.onQueryStringChange(event.target.value);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyUp", function (event) {
      if ([KEY_CODES.LEFT, KEY_CODES.RIGHT, KEY_CODES.HOME, KEY_CODES.END].includes(event.keyCode)) {
        _this.setState({
          isSuggestionsVisible: true
        });

        if (event.target instanceof HTMLTextAreaElement) {
          _this.onQueryStringChange(event.target.value);
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (event) {
      if (event.target instanceof HTMLTextAreaElement) {
        var _this$state = _this.state,
            isSuggestionsVisible = _this$state.isSuggestionsVisible,
            index = _this$state.index;
        var preventDefault = event.preventDefault.bind(event);
        var target = event.target,
            key = event.key,
            metaKey = event.metaKey;
        var value = target.value,
            selectionStart = target.selectionStart,
            selectionEnd = target.selectionEnd;

        var updateQuery = function updateQuery(query, newSelectionStart, newSelectionEnd) {
          _this.onQueryStringChange(query);

          _this.setState({
            selectionStart: newSelectionStart,
            selectionEnd: newSelectionEnd
          });
        };

        switch (event.keyCode) {
          case KEY_CODES.DOWN:
            if (isSuggestionsVisible && index !== null) {
              event.preventDefault();

              _this.incrementIndex(index); // Note to engineers. `isSuggestionVisible` does not mean the suggestions are visible.
              // This should likely be fixed, it's more that suggestions can be shown.

            } else if (isSuggestionsVisible && index == null || _this.getQueryString() === '') {
              event.preventDefault();

              _this.setState({
                isSuggestionsVisible: true,
                index: 0
              });
            }

            break;

          case KEY_CODES.UP:
            if (isSuggestionsVisible && index !== null) {
              event.preventDefault();

              _this.decrementIndex(index);
            }

            break;

          case KEY_CODES.ENTER:
            if (!_this.props.bubbleSubmitEvent) {
              event.preventDefault();
            }

            if (isSuggestionsVisible && index !== null && _this.state.suggestions[index]) {
              event.preventDefault();

              _this.selectSuggestion(_this.state.suggestions[index]);
            } else {
              _this.onSubmit(_this.props.query);

              _this.setState({
                isSuggestionsVisible: false
              });
            }

            break;

          case KEY_CODES.ESC:
            event.preventDefault();

            _this.setState({
              isSuggestionsVisible: false,
              index: null
            });

            break;

          case KEY_CODES.TAB:
            _this.setState({
              isSuggestionsVisible: false,
              index: null
            });

            break;

          default:
            if (selectionStart !== null && selectionEnd !== null) {
              matchPairs({
                value: value,
                selectionStart: selectionStart,
                selectionEnd: selectionEnd,
                key: key,
                metaKey: metaKey,
                updateQuery: updateQuery,
                preventDefault: preventDefault
              });
            }

            break;
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "selectSuggestion", function (suggestion) {
      if (!_this.inputRef) {
        return;
      }

      var type = suggestion.type,
          text = suggestion.text,
          start = suggestion.start,
          end = suggestion.end,
          cursorIndex = suggestion.cursorIndex;

      _this.handleNestedFieldSyntaxNotification(suggestion);

      var query = _this.getQueryString();

      var _this$inputRef2 = _this.inputRef,
          selectionStart = _this$inputRef2.selectionStart,
          selectionEnd = _this$inputRef2.selectionEnd;

      if (selectionStart === null || selectionEnd === null) {
        return;
      }

      var value = query.substr(0, selectionStart) + query.substr(selectionEnd);
      var newQueryString = value.substr(0, start) + text + value.substr(end);

      _this.onQueryStringChange(newQueryString);

      _this.setState({
        selectionStart: start + (cursorIndex ? cursorIndex : text.length),
        selectionEnd: start + (cursorIndex ? cursorIndex : text.length)
      });

      if (type === QuerySuggestionTypes.RecentSearch) {
        _this.setState({
          isSuggestionsVisible: false,
          index: null
        });

        _this.onSubmit({
          query: newQueryString,
          language: _this.props.query.language
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleNestedFieldSyntaxNotification", function (suggestion) {
      if ('field' in suggestion && suggestion.field.subType && suggestion.field.subType.nested && !_this.services.storage.get('kibana.KQLNestedQuerySyntaxInfoOptOut')) {
        var _this$services = _this.services,
            notifications = _this$services.notifications,
            docLinks = _this$services.docLinks;

        var onKQLNestedQuerySyntaxInfoOptOut = function onKQLNestedQuerySyntaxInfoOptOut(toast) {
          if (!_this.services.storage) return;

          _this.services.storage.set('kibana.KQLNestedQuerySyntaxInfoOptOut', true);

          notifications.toasts.remove(toast);
        };

        if (notifications && docLinks) {
          var toast = notifications.toasts.add({
            title: i18n.translate('data.query.queryBar.KQLNestedQuerySyntaxInfoTitle', {
              defaultMessage: 'KQL nested query syntax'
            }),
            text: toMountPoint( /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "data.query.queryBar.KQLNestedQuerySyntaxInfoText",
              defaultMessage: "It looks like you're querying on a nested field. You can construct KQL syntax for nested queries in different ways, depending on the results you want. Learn more in our {link}.",
              values: {
                link: /*#__PURE__*/React.createElement(EuiLink, {
                  href: docLinks.links.query.kueryQuerySyntax,
                  target: "_blank"
                }, /*#__PURE__*/React.createElement(FormattedMessage, {
                  id: "data.query.queryBar.KQLNestedQuerySyntaxInfoDocLinkText",
                  defaultMessage: "docs"
                }))
              }
            })), /*#__PURE__*/React.createElement(EuiFlexGroup, {
              justifyContent: "flexEnd",
              gutterSize: "s"
            }, /*#__PURE__*/React.createElement(EuiFlexItem, {
              grow: false
            }, /*#__PURE__*/React.createElement(EuiButton, {
              size: "s",
              onClick: function onClick() {
                return onKQLNestedQuerySyntaxInfoOptOut(toast);
              }
            }, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "data.query.queryBar.KQLNestedQuerySyntaxInfoOptOutText",
              defaultMessage: "Don't show again"
            }))))))
          });
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "increaseLimit", function () {
      _this.setState({
        suggestionLimit: _this.state.suggestionLimit + 50
      });
    });

    _defineProperty(_assertThisInitialized(_this), "incrementIndex", function (currentIndex) {
      var nextIndex = currentIndex + 1;

      if (currentIndex === null || nextIndex >= _this.state.suggestions.length) {
        nextIndex = 0;
      }

      _this.setState({
        index: nextIndex
      });
    });

    _defineProperty(_assertThisInitialized(_this), "decrementIndex", function (currentIndex) {
      var previousIndex = currentIndex - 1;

      if (previousIndex < 0) {
        _this.setState({
          index: _this.state.suggestions.length - 1
        });
      } else {
        _this.setState({
          index: previousIndex
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onSelectLanguage", function (language) {
      // Send telemetry info every time the user opts in or out of kuery
      // As a result it is important this function only ever gets called in the
      // UI component's change handler.
      _this.services.http.post('/api/kibana/kql_opt_in_telemetry', {
        body: JSON.stringify({
          opt_in: language === 'kuery'
        })
      });

      _this.services.storage.set('kibana.userQueryLanguage', language);

      var newQuery = {
        query: '',
        language: language
      };

      _this.onChange(newQuery);

      _this.onSubmit(newQuery);
    });

    _defineProperty(_assertThisInitialized(_this), "onOutsideClick", function () {
      if (_this.state.isSuggestionsVisible) {
        _this.setState({
          isSuggestionsVisible: false,
          index: null
        });
      }

      _this.handleBlurHeight();

      if (_this.props.onChangeQueryInputFocus) {
        _this.props.onChangeQueryInputFocus(false);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onInputBlur", function () {
      _this.handleBlurHeight();

      if (_this.props.onChangeQueryInputFocus) {
        _this.props.onChangeQueryInputFocus(false);
      }

      if (isFunction(_this.props.onBlur)) {
        _this.props.onBlur();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onClickSuggestion", function (suggestion) {
      if (!_this.inputRef) {
        return;
      }

      _this.selectSuggestion(suggestion);

      _this.inputRef.focus();
    });

    _defineProperty(_assertThisInitialized(_this), "initPersistedLog", function () {
      var _this$services2 = _this.services,
          uiSettings = _this$services2.uiSettings,
          storage = _this$services2.storage,
          appName = _this$services2.appName;
      _this.persistedLog = _this.props.persistedLog ? _this.props.persistedLog : getQueryLog(uiSettings, storage, appName, _this.props.query.language);
    });

    _defineProperty(_assertThisInitialized(_this), "onMouseEnterSuggestion", function (index) {
      _this.setState({
        index: index
      });
    });

    _defineProperty(_assertThisInitialized(_this), "textareaId", htmlIdGenerator()());

    _defineProperty(_assertThisInitialized(_this), "handleAutoHeight", function () {
      if (_this.inputRef !== null && document.activeElement === _this.inputRef) {
        _this.inputRef.style.setProperty('height', "".concat(_this.inputRef.scrollHeight, "px"), 'important');
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleRemoveHeight", function () {
      if (_this.inputRef !== null) {
        _this.inputRef.style.removeProperty('height');
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleBlurHeight", function () {
      if (_this.inputRef !== null) {
        _this.handleRemoveHeight();

        _this.inputRef.scrollTop = 0;
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnFocus", function () {
      if (_this.props.onChangeQueryInputFocus) {
        _this.props.onChangeQueryInputFocus(true);
      }

      requestAnimationFrame(function () {
        _this.handleAutoHeight();
      });
    });

    return _this;
  }

  _createClass(QueryStringInputUI, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var parsedQuery = fromUser(toUser(this.props.query.query));

      if (!isEqual(this.props.query.query, parsedQuery)) {
        this.onChange(_objectSpread(_objectSpread({}, this.props.query), {}, {
          query: parsedQuery
        }));
      }

      this.initPersistedLog();
      this.fetchIndexPatterns().then(this.updateSuggestions);
      window.addEventListener('resize', this.handleAutoHeight);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var parsedQuery = fromUser(toUser(this.props.query.query));

      if (!isEqual(this.props.query.query, parsedQuery)) {
        this.onChange(_objectSpread(_objectSpread({}, this.props.query), {}, {
          query: parsedQuery
        }));
      }

      this.initPersistedLog();

      if (!isEqual(prevProps.indexPatterns, this.props.indexPatterns)) {
        this.fetchIndexPatterns().then(this.updateSuggestions);
      } else if (!isEqual(prevProps.query, this.props.query)) {
        this.updateSuggestions();
      }

      if (this.state.selectionStart !== null && this.state.selectionEnd !== null) {
        if (this.inputRef != null) {
          this.inputRef.setSelectionRange(this.state.selectionStart, this.state.selectionEnd);
        }

        this.setState({
          selectionStart: null,
          selectionEnd: null
        });

        if (document.activeElement !== null && document.activeElement.id === this.textareaId) {
          this.handleAutoHeight();
        } else {
          this.handleRemoveHeight();
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.abortController) this.abortController.abort();
      this.updateSuggestions.cancel();
      this.componentIsUnmounting = true;
      window.removeEventListener('resize', this.handleAutoHeight);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var isSuggestionsVisible = this.state.isSuggestionsVisible && {
        'aria-controls': 'kbnTypeahead__items',
        'aria-owns': 'kbnTypeahead__items'
      };

      var ariaCombobox = _objectSpread(_objectSpread({}, isSuggestionsVisible), {}, {
        role: 'combobox'
      });

      return /*#__PURE__*/React.createElement("div", {
        className: "euiFormControlLayout euiFormControlLayout--group kbnQueryBar__wrap"
      }, this.props.prepend, /*#__PURE__*/React.createElement(EuiOutsideClickDetector, {
        onOutsideClick: this.onOutsideClick
      }, /*#__PURE__*/React.createElement("div", _extends({}, ariaCombobox, {
        style: {
          position: 'relative',
          width: '100%'
        },
        "aria-label": i18n.translate('data.query.queryBar.comboboxAriaLabel', {
          defaultMessage: 'Search and filter the {pageType} page',
          values: {
            pageType: this.services.appName
          }
        }),
        "aria-haspopup": "true",
        "aria-expanded": this.state.isSuggestionsVisible
      }), /*#__PURE__*/React.createElement("div", {
        role: "search",
        className: "euiFormControlLayout__childrenWrapper kuiLocalSearchAssistedInput"
      }, /*#__PURE__*/React.createElement(EuiTextArea, {
        placeholder: this.props.placeholder || i18n.translate('data.query.queryBar.searchInputPlaceholder', {
          defaultMessage: 'Search'
        }),
        value: this.getQueryString(),
        onKeyDown: this.onKeyDown,
        onKeyUp: this.onKeyUp,
        onChange: this.onInputChange,
        onClick: this.onClickInput,
        onBlur: this.onInputBlur,
        onFocus: this.handleOnFocus,
        className: "kbnQueryBar__textarea",
        fullWidth: true,
        rows: 1,
        id: this.textareaId,
        autoFocus: this.props.onChangeQueryInputFocus ? false : !this.props.disableAutoFocus,
        inputRef: function inputRef(node) {
          if (node) {
            _this2.inputRef = node;
          }
        },
        autoComplete: "off",
        spellCheck: false,
        "aria-label": i18n.translate('data.query.queryBar.searchInputAriaLabel', {
          defaultMessage: 'Start typing to search and filter the {pageType} page',
          values: {
            pageType: this.services.appName
          }
        }),
        "aria-autocomplete": "list",
        "aria-controls": this.state.isSuggestionsVisible ? 'kbnTypeahead__items' : undefined,
        "aria-activedescendant": this.state.isSuggestionsVisible && typeof this.state.index === 'number' ? "suggestion-".concat(this.state.index) : undefined,
        role: "textbox",
        "data-test-subj": this.props.dataTestSubj || 'queryInput'
      }, this.getQueryString())), /*#__PURE__*/React.createElement(SuggestionsComponent, {
        show: this.state.isSuggestionsVisible,
        suggestions: this.state.suggestions.slice(0, this.state.suggestionLimit),
        index: this.state.index,
        onClick: this.onClickSuggestion,
        onMouseEnter: this.onMouseEnterSuggestion,
        loadMore: this.increaseLimit
      }))), /*#__PURE__*/React.createElement(QueryLanguageSwitcher, {
        language: this.props.query.language,
        anchorPosition: this.props.languageSwitcherPopoverAnchorPosition,
        onSelectLanguage: this.onSelectLanguage
      }));
    }
  }]);

  return QueryStringInputUI;
}(Component);
export var QueryStringInput = withKibana(QueryStringInputUI);