function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useRef } from 'react';
import ReactDOM from 'react-dom';
import { HashRouter as Router, Switch, Route, Redirect } from 'react-router-dom';
import { EuiTab, EuiTabs, EuiToolTip } from '@elastic/eui';
import { I18nProvider } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';

function DevToolsWrapper(_ref) {
  var devTools = _ref.devTools,
      activeDevTool = _ref.activeDevTool,
      updateRoute = _ref.updateRoute;
  var mountedTool = useRef(null);
  useEffect(function () {
    return function () {
      if (mountedTool.current) {
        mountedTool.current.unmountHandler();
      }
    };
  }, []);
  return /*#__PURE__*/React.createElement("main", {
    className: "devApp"
  }, /*#__PURE__*/React.createElement(EuiTabs, null, devTools.map(function (currentDevTool) {
    return /*#__PURE__*/React.createElement(EuiToolTip, {
      content: currentDevTool.tooltipContent,
      key: currentDevTool.id
    }, /*#__PURE__*/React.createElement(EuiTab, {
      disabled: currentDevTool.isDisabled(),
      isSelected: currentDevTool === activeDevTool,
      onClick: function onClick() {
        if (!currentDevTool.isDisabled()) {
          updateRoute("/".concat(currentDevTool.id));
        }
      }
    }, currentDevTool.title));
  })), /*#__PURE__*/React.createElement("div", {
    className: "devApp__container",
    role: "tabpanel",
    "data-test-subj": activeDevTool.id,
    ref: /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(element) {
        var params, unmountHandler;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                if (!(element && (mountedTool.current === null || mountedTool.current.devTool !== activeDevTool || mountedTool.current.mountpoint !== element))) {
                  _context.next = 7;
                  break;
                }

                if (mountedTool.current) {
                  mountedTool.current.unmountHandler();
                }

                params = {
                  element: element,
                  appBasePath: '',
                  onAppLeave: function onAppLeave() {
                    return undefined;
                  },
                  // TODO: adapt to use Core's ScopedHistory
                  history: {}
                };
                _context.next = 5;
                return activeDevTool.mount(params);

              case 5:
                unmountHandler = _context.sent;
                mountedTool.current = {
                  devTool: activeDevTool,
                  mountpoint: element,
                  unmountHandler: unmountHandler
                };

              case 7:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function (_x) {
        return _ref2.apply(this, arguments);
      };
    }()
  }));
}

function redirectOnMissingCapabilities(application) {
  if (!application.capabilities.dev_tools.show) {
    application.navigateToApp('home');
    return true;
  }

  return false;
}

function setBadge(application, chrome) {
  if (application.capabilities.dev_tools.save) {
    return;
  }

  chrome.setBadge({
    text: i18n.translate('devTools.badge.readOnly.text', {
      defaultMessage: 'Read only'
    }),
    tooltip: i18n.translate('devTools.badge.readOnly.tooltip', {
      defaultMessage: 'Unable to save'
    }),
    iconType: 'glasses'
  });
}

function setTitle(chrome) {
  chrome.docTitle.change(i18n.translate('devTools.pageTitle', {
    defaultMessage: 'Dev Tools'
  }));
}

function setBreadcrumbs(chrome) {
  chrome.setBreadcrumbs([{
    text: i18n.translate('devTools.k7BreadcrumbsDevToolsLabel', {
      defaultMessage: 'Dev Tools'
    }),
    href: '#/'
  }]);
}

export function renderApp(element, application, chrome, history, devTools) {
  if (redirectOnMissingCapabilities(application)) {
    return function () {};
  }

  setBadge(application, chrome);
  setBreadcrumbs(chrome);
  setTitle(chrome);
  ReactDOM.render( /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(Router, null, /*#__PURE__*/React.createElement(Switch, null, devTools // Only create routes for devtools that are not disabled
  .filter(function (devTool) {
    return !devTool.isDisabled();
  }).map(function (devTool) {
    return /*#__PURE__*/React.createElement(Route, {
      key: devTool.id,
      path: "/".concat(devTool.id),
      exact: !devTool.enableRouting,
      render: function render(props) {
        return /*#__PURE__*/React.createElement(DevToolsWrapper, {
          updateRoute: props.history.push,
          activeDevTool: devTool,
          devTools: devTools
        });
      }
    });
  }), /*#__PURE__*/React.createElement(Route, {
    path: "/"
  }, /*#__PURE__*/React.createElement(Redirect, {
    to: "/".concat(devTools[0].id)
  }))))), element); // dispatch synthetic hash change event to update hash history objects
  // this is necessary because hash updates triggered by using popState won't trigger this event naturally.

  var unlisten = history.listen(function () {
    window.dispatchEvent(new HashChangeEvent('hashchange'));
  });
  return function () {
    ReactDOM.unmountComponentAtNode(element);
    unlisten();
  };
}