/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { FormattedMessage, I18nProvider } from '@kbn/i18n/react';
import { EuiButton, EuiEmptyPrompt, EuiPage, EuiPageBody, EuiPageContent } from '@elastic/eui';
export var DiscoverUninitialized = function DiscoverUninitialized(_ref) {
  var onRefresh = _ref.onRefresh;
  return /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(EuiPage, null, /*#__PURE__*/React.createElement(EuiPageBody, null, /*#__PURE__*/React.createElement(EuiPageContent, {
    horizontalPosition: "center"
  }, /*#__PURE__*/React.createElement(EuiEmptyPrompt, {
    iconType: "discoverApp",
    title: /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "discover.uninitializedTitle",
      defaultMessage: "Start searching"
    })),
    body: /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "discover.uninitializedText",
      defaultMessage: "Write a query, add some filters, or simply hit Refresh to retrieve results for the current query."
    })),
    actions: /*#__PURE__*/React.createElement(EuiButton, {
      color: "primary",
      fill: true,
      onClick: onRefresh
    }, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "discover.uninitializedRefreshButtonText",
      defaultMessage: "Refresh data"
    }))
  })))));
};