function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEffect, useState, useRef } from 'react';
import { i18n } from '@kbn/i18n';
import { isJSON } from '../../../static/validators/string';

var stringifyJson = function stringifyJson(json) {
  return Object.keys(json).length ? JSON.stringify(json, null, 2) : '{\n\n}';
};

export var useJson = function useJson(_ref) {
  var _ref$defaultValue = _ref.defaultValue,
      defaultValue = _ref$defaultValue === void 0 ? {} : _ref$defaultValue,
      onUpdate = _ref.onUpdate,
      _ref$isControlled = _ref.isControlled,
      isControlled = _ref$isControlled === void 0 ? false : _ref$isControlled;
  var didMount = useRef(false);

  var _useState = useState(stringifyJson(defaultValue)),
      _useState2 = _slicedToArray(_useState, 2),
      content = _useState2[0],
      setContent = _useState2[1];

  var _useState3 = useState(null),
      _useState4 = _slicedToArray(_useState3, 2),
      error = _useState4[0],
      setError = _useState4[1];

  var validate = function validate() {
    // We allow empty string as it will be converted to "{}""
    var isValid = content.trim() === '' ? true : isJSON(content);

    if (!isValid) {
      setError(i18n.translate('esUi.validation.string.invalidJSONError', {
        defaultMessage: 'Invalid JSON'
      }));
    } else {
      setError(null);
    }

    return isValid;
  };

  var formatContent = function formatContent() {
    var isValid = validate();
    var data = isValid && content.trim() !== '' ? JSON.parse(content) : {};
    return data;
  };

  useEffect(function () {
    if (didMount.current) {
      var isValid = isControlled ? undefined : validate();
      onUpdate({
        data: {
          raw: content,
          format: formatContent
        },
        validate: validate,
        isValid: isValid
      });
    } else {
      didMount.current = true;
    }
  }, [content]);
  return {
    content: content,
    setContent: setContent,
    error: error
  };
};