function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEffect, useState, useRef } from 'react';
export var sendRequest = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(httpClient, _ref) {
    var path, method, body, response;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            path = _ref.path, method = _ref.method, body = _ref.body;
            _context.prev = 1;
            _context.next = 4;
            return httpClient[method](path, body);

          case 4:
            response = _context.sent;

            if (!(typeof response.data === 'undefined')) {
              _context.next = 7;
              break;
            }

            throw new Error(response.statusText);

          case 7:
            return _context.abrupt("return", {
              data: response.data,
              error: null
            });

          case 10:
            _context.prev = 10;
            _context.t0 = _context["catch"](1);
            return _context.abrupt("return", {
              data: null,
              error: _context.t0.response ? _context.t0.response : _context.t0
            });

          case 13:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[1, 10]]);
  }));

  return function sendRequest(_x, _x2) {
    return _ref2.apply(this, arguments);
  };
}();
export var useRequest = function useRequest(httpClient, _ref3) {
  var path = _ref3.path,
      method = _ref3.method,
      body = _ref3.body,
      pollIntervalMs = _ref3.pollIntervalMs,
      initialData = _ref3.initialData,
      _ref3$deserializer = _ref3.deserializer,
      deserializer = _ref3$deserializer === void 0 ? function (data) {
    return data;
  } : _ref3$deserializer;

  // Main states for tracking request status and data
  var _useState = useState(null),
      _useState2 = _slicedToArray(_useState, 2),
      error = _useState2[0],
      setError = _useState2[1];

  var _useState3 = useState(true),
      _useState4 = _slicedToArray(_useState3, 2),
      isLoading = _useState4[0],
      setIsLoading = _useState4[1];

  var _useState5 = useState(initialData),
      _useState6 = _slicedToArray(_useState5, 2),
      data = _useState6[0],
      setData = _useState6[1]; // Consumers can use isInitialRequest to implement a polling UX.


  var _useState7 = useState(true),
      _useState8 = _slicedToArray(_useState7, 2),
      isInitialRequest = _useState8[0],
      setIsInitialRequest = _useState8[1];

  var pollInterval = useRef(null);
  var pollIntervalId = useRef(null); // We always want to use the most recently-set interval in scheduleRequest.

  pollInterval.current = pollIntervalMs; // Tied to every render and bound to each request.

  var isOutdatedRequest = false;

  var scheduleRequest = function scheduleRequest() {
    // Clear current interval
    if (pollIntervalId.current) {
      clearTimeout(pollIntervalId.current);
    } // Set new interval


    if (pollInterval.current) {
      pollIntervalId.current = setTimeout(_sendRequest, pollInterval.current);
    }
  };

  var _sendRequest = /*#__PURE__*/function () {
    var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var requestBody, response, serializedResponseData, responseError, responseData;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              // We don't clear error or data, so it's up to the consumer to decide whether to display the
              // "old" error/data or loading state when a new request is in-flight.
              setIsLoading(true);
              requestBody = {
                path: path,
                method: method,
                body: body
              };
              _context2.next = 4;
              return sendRequest(httpClient, requestBody);

            case 4:
              response = _context2.sent;
              serializedResponseData = response.data, responseError = response.error;
              responseData = deserializer(serializedResponseData); // If an outdated request has resolved, DON'T update state, but DO allow the processData handler
              // to execute side effects like update telemetry.

              if (!isOutdatedRequest) {
                _context2.next = 9;
                break;
              }

              return _context2.abrupt("return", {
                data: null,
                error: null
              });

            case 9:
              setError(responseError);
              setData(responseData);
              setIsLoading(false);
              setIsInitialRequest(false); // If we're on an interval, we need to schedule the next request. This also allows us to reset
              // the interval if the user has manually requested the data, to avoid doubled-up requests.

              scheduleRequest();
              return _context2.abrupt("return", {
                data: serializedResponseData,
                error: responseError
              });

            case 15:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    }));

    return function _sendRequest() {
      return _ref4.apply(this, arguments);
    };
  }();

  useEffect(function () {
    _sendRequest(); // To be functionally correct we'd send a new request if the method, path, or body changes.
    // But it doesn't seem likely that the method will change and body is likely to be a new
    // object even if its shape hasn't changed, so for now we're just watching the path.

  }, [path]);
  useEffect(function () {
    scheduleRequest(); // Clean up intervals and inflight requests and corresponding state changes

    return function () {
      isOutdatedRequest = true;

      if (pollIntervalId.current) {
        clearTimeout(pollIntervalId.current);
      }
    };
  }, [pollIntervalMs]);
  return {
    isInitialRequest: isInitialRequest,
    isLoading: isLoading,
    error: error,
    data: data,
    sendRequest: _sendRequest // Gives the user the ability to manually request data

  };
};