function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import { EuiBasicTable, EuiButton, EuiFieldText, EuiFormRow, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { DefaultFormatEditor } from '../default';
export var StaticLookupFormatEditor = /*#__PURE__*/function (_DefaultFormatEditor) {
  _inherits(StaticLookupFormatEditor, _DefaultFormatEditor);

  var _super = _createSuper(StaticLookupFormatEditor);

  function StaticLookupFormatEditor() {
    var _this;

    _classCallCheck(this, StaticLookupFormatEditor);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "onLookupChange", function (newLookupParams, index) {
      var lookupEntries = _toConsumableArray(_this.props.formatParams.lookupEntries);

      lookupEntries[index] = _objectSpread(_objectSpread({}, lookupEntries[index]), newLookupParams);

      _this.onChange({
        lookupEntries: lookupEntries
      });
    });

    _defineProperty(_assertThisInitialized(_this), "addLookup", function () {
      var lookupEntries = _toConsumableArray(_this.props.formatParams.lookupEntries);

      _this.onChange({
        lookupEntries: [].concat(_toConsumableArray(lookupEntries), [{}])
      });
    });

    _defineProperty(_assertThisInitialized(_this), "removeLookup", function (index) {
      var lookupEntries = _toConsumableArray(_this.props.formatParams.lookupEntries);

      lookupEntries.splice(index, 1);

      _this.onChange({
        lookupEntries: lookupEntries
      });
    });

    return _this;
  }

  _createClass(StaticLookupFormatEditor, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var formatParams = this.props.formatParams;
      var items = formatParams.lookupEntries && formatParams.lookupEntries.length && formatParams.lookupEntries.map(function (lookup, index) {
        return _objectSpread(_objectSpread({}, lookup), {}, {
          index: index
        });
      }) || [];
      var columns = [{
        field: 'key',
        name: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.staticLookup.keyLabel",
          defaultMessage: "Key"
        }),
        render: function render(value, item) {
          return /*#__PURE__*/React.createElement(EuiFieldText, {
            value: value || '',
            onChange: function onChange(e) {
              _this2.onLookupChange({
                key: e.target.value
              }, item.index);
            }
          });
        }
      }, {
        field: 'value',
        name: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.staticLookup.valueLabel",
          defaultMessage: "Value"
        }),
        render: function render(value, item) {
          return /*#__PURE__*/React.createElement(EuiFieldText, {
            value: value || '',
            onChange: function onChange(e) {
              _this2.onLookupChange({
                value: e.target.value
              }, item.index);
            }
          });
        }
      }, {
        field: 'actions',
        name: i18n.translate('indexPatternManagement.staticLookup.actions', {
          defaultMessage: 'actions'
        }),
        actions: [{
          name: i18n.translate('indexPatternManagement.staticLookup.deleteAria', {
            defaultMessage: 'Delete'
          }),
          description: i18n.translate('indexPatternManagement.staticLookup.deleteTitle', {
            defaultMessage: 'Delete entry'
          }),
          onClick: function onClick(item) {
            _this2.removeLookup(item.index);
          },
          type: 'icon',
          icon: 'trash',
          color: 'danger',
          available: function available() {
            return items.length > 1;
          }
        }],
        width: '30px'
      }];
      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiBasicTable, {
        items: items,
        columns: columns,
        style: {
          maxWidth: '400px'
        }
      }), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiButton, {
        iconType: "plusInCircle",
        size: "s",
        onClick: this.addLookup
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.staticLookup.addEntryButton",
        defaultMessage: "Add entry"
      })), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.staticLookup.unknownKeyLabel",
          defaultMessage: "Value for unknown key"
        })
      }, /*#__PURE__*/React.createElement(EuiFieldText, {
        value: formatParams.unknownKeyValue || '',
        placeholder: i18n.translate('indexPatternManagement.staticLookup.leaveBlankPlaceholder', {
          defaultMessage: 'Leave blank to keep value as-is'
        }),
        onChange: function onChange(e) {
          _this2.onChange({
            unknownKeyValue: e.target.value
          });
        }
      })), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }));
    }
  }]);

  return StaticLookupFormatEditor;
}(DefaultFormatEditor);

_defineProperty(StaticLookupFormatEditor, "formatId", 'static_lookup');