function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import { EuiFieldText, EuiFormRow, EuiLink, EuiSelect, EuiSwitch, EuiFieldNumber } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { DefaultFormatEditor } from '../default';
import { FormatEditorSamples } from '../../samples';
import { LabelTemplateFlyout } from './label_template_flyout';
import { UrlTemplateFlyout } from './url_template_flyout';
export var UrlFormatEditor = /*#__PURE__*/function (_DefaultFormatEditor) {
  _inherits(UrlFormatEditor, _DefaultFormatEditor);

  var _super = _createSuper(UrlFormatEditor);

  function UrlFormatEditor(props) {
    var _this;

    _classCallCheck(this, UrlFormatEditor);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "iconPattern", void 0);

    _defineProperty(_assertThisInitialized(_this), "sanitizeNumericValue", function (val) {
      var sanitizedValue = parseInt(val, 10);

      if (isNaN(sanitizedValue)) {
        return '';
      }

      return sanitizedValue;
    });

    _defineProperty(_assertThisInitialized(_this), "onTypeChange", function (newType) {
      var _this$props$formatPar = _this.props.formatParams,
          urlTemplate = _this$props$formatPar.urlTemplate,
          width = _this$props$formatPar.width,
          height = _this$props$formatPar.height;
      var params = {
        type: newType
      };

      if (newType === 'img') {
        params.width = width;
        params.height = height;

        if (!urlTemplate) {
          params.urlTemplate = _this.iconPattern;
        }
      } else if (newType !== 'img' && urlTemplate === _this.iconPattern) {
        params.urlTemplate = undefined;
      }

      _this.onChange(params);
    });

    _defineProperty(_assertThisInitialized(_this), "showUrlTemplateHelp", function () {
      _this.setState({
        showLabelTemplateHelp: false,
        showUrlTemplateHelp: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "hideUrlTemplateHelp", function () {
      _this.setState({
        showUrlTemplateHelp: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "showLabelTemplateHelp", function () {
      _this.setState({
        showLabelTemplateHelp: true,
        showUrlTemplateHelp: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "hideLabelTemplateHelp", function () {
      _this.setState({
        showLabelTemplateHelp: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "renderWidthHeightParameters", function () {
      var width = _this.sanitizeNumericValue(_this.props.formatParams.width);

      var height = _this.sanitizeNumericValue(_this.props.formatParams.height);

      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.widthLabel",
          defaultMessage: "Width"
        })
      }, /*#__PURE__*/React.createElement(EuiFieldNumber, {
        "data-test-subj": "urlEditorWidth",
        value: width,
        onChange: function onChange(e) {
          _this.onChange({
            width: e.target.value
          });
        }
      })), /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.heightLabel",
          defaultMessage: "Height"
        })
      }, /*#__PURE__*/React.createElement(EuiFieldNumber, {
        "data-test-subj": "urlEditorHeight",
        value: height,
        onChange: function onChange(e) {
          _this.onChange({
            height: e.target.value
          });
        }
      })));
    });

    _this.iconPattern = "/plugins/indexPatternManagement/assets/icons/{{value}}.png";
    _this.state = _objectSpread(_objectSpread({}, _this.state), {}, {
      sampleInputsByType: {
        a: ['john', '/some/pathname/asset.png', 1234],
        img: ['go', 'stop', ['de', 'ne', 'us', 'ni'], 'cv'],
        audio: ['hello.mp3']
      },
      sampleConverterType: 'html',
      showUrlTemplateHelp: false,
      showLabelTemplateHelp: false
    });
    return _this;
  }

  _createClass(UrlFormatEditor, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          format = _this$props.format,
          formatParams = _this$props.formatParams;
      var _this$state = this.state,
          error = _this$state.error,
          samples = _this$state.samples,
          sampleConverterType = _this$state.sampleConverterType;
      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(LabelTemplateFlyout, {
        isVisible: this.state.showLabelTemplateHelp,
        onClose: this.hideLabelTemplateHelp
      }), /*#__PURE__*/React.createElement(UrlTemplateFlyout, {
        isVisible: this.state.showUrlTemplateHelp,
        onClose: this.hideUrlTemplateHelp
      }), /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.typeLabel",
          defaultMessage: "Type"
        })
      }, /*#__PURE__*/React.createElement(EuiSelect, {
        "data-test-subj": "urlEditorType",
        value: formatParams.type,
        options: format.type.urlTypes.map(function (type) {
          return {
            value: type.kind,
            text: type.text
          };
        }),
        onChange: function onChange(e) {
          _this2.onTypeChange(e.target.value);
        }
      })), formatParams.type === 'a' ? /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.openTabLabel",
          defaultMessage: "Open in a new tab"
        })
      }, /*#__PURE__*/React.createElement(EuiSwitch, {
        label: formatParams.openLinkInCurrentTab ? /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.offLabel",
          defaultMessage: "Off"
        }) : /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.onLabel",
          defaultMessage: "On"
        }),
        checked: !formatParams.openLinkInCurrentTab,
        onChange: function onChange(e) {
          _this2.onChange({
            openLinkInCurrentTab: !e.target.checked
          });
        }
      })) : null, /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.urlTemplateLabel",
          defaultMessage: "URL template"
        }),
        helpText: /*#__PURE__*/React.createElement(EuiLink, {
          onClick: this.showUrlTemplateHelp
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.template.helpLinkText",
          defaultMessage: "URL template help"
        })),
        isInvalid: !!error,
        error: error
      }, /*#__PURE__*/React.createElement(EuiFieldText, {
        "data-test-subj": "urlEditorUrlTemplate",
        value: formatParams.urlTemplate || '',
        onChange: function onChange(e) {
          _this2.onChange({
            urlTemplate: e.target.value
          });
        }
      })), /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.labelTemplateLabel",
          defaultMessage: "Label template"
        }),
        helpText: /*#__PURE__*/React.createElement(EuiLink, {
          onClick: this.showLabelTemplateHelp
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "indexPatternManagement.url.labelTemplateHelpText",
          defaultMessage: "Label template help"
        })),
        isInvalid: !!error,
        error: error
      }, /*#__PURE__*/React.createElement(EuiFieldText, {
        "data-test-subj": "urlEditorLabelTemplate",
        value: formatParams.labelTemplate || '',
        onChange: function onChange(e) {
          _this2.onChange({
            labelTemplate: e.target.value
          });
        }
      })), formatParams.type === 'img' && this.renderWidthHeightParameters(), /*#__PURE__*/React.createElement(FormatEditorSamples, {
        samples: samples,
        sampleType: sampleConverterType
      }));
    }
  }]);

  return UrlFormatEditor;
}(DefaultFormatEditor);

_defineProperty(UrlFormatEditor, "formatId", 'url');