/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import { EuiCode, EuiIcon, EuiLink, EuiText, EuiSpacer } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { useKibana } from '../../../../../../../plugins/kibana_react/public';
export var ScriptingSyntax = function ScriptingSyntax() {
  var _useKibana$services$d;

  var docLinksScriptedFields = (_useKibana$services$d = useKibana().services.docLinks) === null || _useKibana$services$d === void 0 ? void 0 : _useKibana$services$d.links.scriptedFields;
  return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, null), /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntaxHeader",
    defaultMessage: "Syntax"
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.defaultLabel.defaultDetail",
    defaultMessage: "By default, Kibana scripted fields use {painless}, a simple and secure scripting language designed specifically for use with Elasticsearch, to access values in the document use the following format:",
    values: {
      painless: /*#__PURE__*/React.createElement(EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.painless
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.syntax.defaultLabel.painlessLink",
        defaultMessage: "Painless"
      }), ' ', /*#__PURE__*/React.createElement(EuiIcon, {
        type: "link"
      }))
    }
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(EuiCode, null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.default.formatLabel",
    defaultMessage: "doc['some_field'].value"
  }))), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.painlessLabel.painlessDetail",
    defaultMessage: "Painless is powerful but easy to use. It provides access to many {javaAPIs}. Read up on its {syntax} and you'll be up to speed in no time!",
    values: {
      javaAPIs: /*#__PURE__*/React.createElement(EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.painlessApi
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.syntax.painlessLabel.javaAPIsLink",
        defaultMessage: "native Java APIs"
      }), "\xA0", /*#__PURE__*/React.createElement(EuiIcon, {
        type: "link"
      })),
      syntax: /*#__PURE__*/React.createElement(EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.painlessSyntax
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.syntax.painlessLabel.syntaxLink",
        defaultMessage: "syntax"
      }), "\xA0", /*#__PURE__*/React.createElement(EuiIcon, {
        type: "link"
      }))
    }
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.kibanaLabel",
    defaultMessage: "Kibana currently imposes one special limitation on the painless scripts you write. They cannot contain named functions."
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.commonLabel.commonDetail",
    defaultMessage: "Coming from an older version of Kibana? The {lucene} you know and love are still available. Lucene expressions are a lot like JavaScript, but limited to basic arithmetic, bitwise and comparison operations.",
    values: {
      lucene: /*#__PURE__*/React.createElement(EuiLink, {
        target: "_blank",
        href: docLinksScriptedFields.luceneExpressions
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.syntax.lucene.commonLabel.luceneLink",
        defaultMessage: "Lucene Expressions"
      }), "\xA0", /*#__PURE__*/React.createElement(EuiIcon, {
        type: "link"
      }))
    }
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.limitsLabel",
    defaultMessage: "There are a few limitations when using Lucene Expressions:"
  })), /*#__PURE__*/React.createElement("ul", null, /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.limits.typesLabel",
    defaultMessage: "Only numeric, boolean, date, and geo_point fields may be accessed"
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.limits.fieldsLabel",
    defaultMessage: "Stored fields are not available"
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.limits.sparseLabel",
    defaultMessage: "If a field is sparse (only some documents contain a value), documents missing the field will have a value of 0"
  }))), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operationsLabel",
    defaultMessage: "Here are all the operations available to lucene expressions:"
  })), /*#__PURE__*/React.createElement("ul", null, /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.arithmeticLabel",
    defaultMessage: "Arithmetic operators: {operators}",
    values: {
      operators: /*#__PURE__*/React.createElement("code", null, "+ - * / %")
    }
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.bitwiseLabel",
    defaultMessage: "Bitwise operators: {operators}",
    values: {
      operators: /*#__PURE__*/React.createElement("code", null, "| & ^ ~ << >> >>>")
    }
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.booleanLabel",
    defaultMessage: "Boolean operators (including the ternary operator): {operators}",
    values: {
      operators: /*#__PURE__*/React.createElement("code", null, "&& || ! ?:")
    }
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.comparisonLabel",
    defaultMessage: "Comparison operators: {operators}",
    values: {
      operators: /*#__PURE__*/React.createElement("code", null, "< <= == >= >")
    }
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.mathLabel",
    defaultMessage: "Common mathematic functions: {operators}",
    values: {
      operators: /*#__PURE__*/React.createElement("code", null, "abs ceil exp floor ln log10 logn max min sqrt pow")
    }
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.trigLabel",
    defaultMessage: "Trigonometric library functions: {operators}",
    values: {
      operators: /*#__PURE__*/React.createElement("code", null, "acosh acos asinh asin atanh atan atan2 cosh cos sinh sin tanh tan")
    }
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.distanceLabel",
    defaultMessage: "Distance functions: {operators}",
    values: {
      operators: /*#__PURE__*/React.createElement("code", null, "haversin")
    }
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.syntax.lucene.operations.miscellaneousLabel",
    defaultMessage: "Miscellaneous functions: {operators}",
    values: {
      operators: /*#__PURE__*/React.createElement("code", null, "min, max")
    }
  })))));
};