function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiBadge, EuiButtonEmpty, EuiButtonIcon, EuiFlexGroup, EuiFlexItem, EuiInMemoryTable, EuiPanel, EuiSpacer, EuiText, EuiBadgeGroup } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { withRouter } from 'react-router-dom';
import React, { useState, useEffect } from 'react';
import { i18n } from '@kbn/i18n';
import { reactRouterNavigate, useKibana } from '../../../../../plugins/kibana_react/public';
import { CreateButton } from '../create_button';
import { CreateIndexPatternPrompt } from '../create_index_pattern_prompt';
import { getIndexPatterns } from '../utils';
import { getListBreadcrumbs } from '../breadcrumbs';
var pagination = {
  initialPageSize: 10,
  pageSizeOptions: [5, 10, 25, 50]
};
var sorting = {
  sort: {
    field: 'title',
    direction: 'asc'
  }
};
var search = {
  box: {
    incremental: true,
    schema: {
      fields: {
        title: {
          type: 'string'
        }
      }
    }
  }
};
var ariaRegion = i18n.translate('indexPatternManagement.editIndexPatternLiveRegionAriaLabel', {
  defaultMessage: 'Index patterns'
});
var title = i18n.translate('indexPatternManagement.indexPatternTable.title', {
  defaultMessage: 'Index patterns'
});
export var IndexPatternTable = function IndexPatternTable(_ref) {
  var canSave = _ref.canSave,
      history = _ref.history;
  var _useKibana$services = useKibana().services,
      setBreadcrumbs = _useKibana$services.setBreadcrumbs,
      savedObjects = _useKibana$services.savedObjects,
      uiSettings = _useKibana$services.uiSettings,
      indexPatternManagementStart = _useKibana$services.indexPatternManagementStart,
      chrome = _useKibana$services.chrome;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      showFlyout = _useState2[0],
      setShowFlyout = _useState2[1];

  var _useState3 = useState([]),
      _useState4 = _slicedToArray(_useState3, 2),
      indexPatterns = _useState4[0],
      setIndexPatterns = _useState4[1];

  var _useState5 = useState([]),
      _useState6 = _slicedToArray(_useState5, 2),
      creationOptions = _useState6[0],
      setCreationOptions = _useState6[1];

  setBreadcrumbs(getListBreadcrumbs());
  useEffect(function () {
    _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var options, gettedIndexPatterns;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return indexPatternManagementStart.creation.getIndexPatternCreationOptions(history.push);

            case 2:
              options = _context.sent;
              _context.next = 5;
              return getIndexPatterns(savedObjects.client, uiSettings.get('defaultIndex'), indexPatternManagementStart);

            case 5:
              gettedIndexPatterns = _context.sent;
              setCreationOptions(options);
              setIndexPatterns(gettedIndexPatterns);
              setShowFlyout(gettedIndexPatterns.length === 0);

            case 9:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  }, [history.push, indexPatterns.length, indexPatternManagementStart, uiSettings, savedObjects.client]);
  chrome.docTitle.change(title);
  var columns = [{
    field: 'title',
    name: 'Pattern',
    render: function render(name, index) {
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, _extends({
        size: "xs"
      }, reactRouterNavigate(history, "patterns/".concat(index.id))), name), /*#__PURE__*/React.createElement(EuiBadgeGroup, {
        gutterSize: "s"
      }, index.tags && index.tags.map(function (_ref3) {
        var tagKey = _ref3.key,
            tagName = _ref3.name;
        return /*#__PURE__*/React.createElement(EuiBadge, {
          className: "indexPatternList__badge",
          key: tagKey
        }, tagName);
      })));
    },
    dataType: 'string',
    sortable: function sortable(_ref4) {
      var sort = _ref4.sort;
      return sort;
    }
  }];
  var createButton = canSave ? /*#__PURE__*/React.createElement(CreateButton, {
    options: creationOptions
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.indexPatternTable.createBtn",
    defaultMessage: "Create index pattern"
  })) : /*#__PURE__*/React.createElement(React.Fragment, null);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "l",
    "data-test-subj": "indexPatternTable",
    role: "region",
    "aria-label": ariaRegion
  }, showFlyout && /*#__PURE__*/React.createElement(CreateIndexPatternPrompt, {
    onClose: function onClose() {
      return setShowFlyout(false);
    }
  }), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false,
    className: "euiIEFlexWrapFix"
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("h2", null, title))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
    iconSize: "l",
    iconType: "questionInCircle",
    onClick: function onClick() {
      return setShowFlyout(true);
    },
    "aria-label": "Help"
  })))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, createButton)), /*#__PURE__*/React.createElement(EuiSpacer, null), /*#__PURE__*/React.createElement(EuiInMemoryTable, {
    allowNeutralSort: false,
    itemId: "id",
    isSelectable: false,
    items: indexPatterns,
    columns: columns,
    pagination: pagination,
    sorting: sorting,
    search: search
  }));
};
export var IndexPatternTableWithRouter = withRouter(IndexPatternTable);