function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export function getIndexPatterns(_x, _x2, _x3) {
  return _getIndexPatterns.apply(this, arguments);
}

function _getIndexPatterns() {
  _getIndexPatterns = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(savedObjectsClient, defaultIndex, indexPatternManagementStart) {
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", savedObjectsClient.find({
              type: 'index-pattern',
              fields: ['title', 'type'],
              perPage: 10000
            }).then(function (response) {
              return response.savedObjects.map(function (pattern) {
                var id = pattern.id;
                var title = pattern.get('title');
                var isDefault = defaultIndex === id;
                var tags = indexPatternManagementStart.list.getIndexPatternTags(pattern, isDefault);
                return {
                  id: id,
                  title: title,
                  default: isDefault,
                  tags: tags,
                  // the prepending of 0 at the default pattern takes care of prioritization
                  // so the sorting will but the default index on top
                  // or on bottom of a the table
                  sort: "".concat(isDefault ? '0' : '1').concat(title)
                };
              }).sort(function (a, b) {
                if (a.sort < b.sort) {
                  return -1;
                } else if (a.sort > b.sort) {
                  return 1;
                } else {
                  return 0;
                }
              });
            }) || []);

          case 1:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _getIndexPatterns.apply(this, arguments);
}