function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PureComponent } from 'react';
import { FormattedMessage } from '@kbn/i18n/react';
import { EuiFormRow, EuiFieldNumber, EuiSwitch, EuiSelect } from '@elastic/eui';
import { IndexPatternSelectFormRow } from './index_pattern_select_form_row';
import { FieldSelect } from './field_select';

function filterField(field) {
  return Boolean(field.aggregatable) && ['number', 'boolean', 'date', 'ip', 'string'].includes(field.type);
}

export var ListControlEditor = /*#__PURE__*/function (_PureComponent) {
  _inherits(ListControlEditor, _PureComponent);

  var _super = _createSuper(ListControlEditor);

  function ListControlEditor() {
    var _this;

    _classCallCheck(this, ListControlEditor);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "isMounted", false);

    _defineProperty(_assertThisInitialized(_this), "state", {
      isLoadingFieldType: true,
      isStringField: false,
      prevFieldName: _this.props.controlParams.fieldName,
      IndexPatternSelect: null
    });

    _defineProperty(_assertThisInitialized(_this), "componentDidUpdate", function () {
      if (_this.state.isLoadingFieldType) {
        _this.loadIsStringField();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "loadIsStringField", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var indexPattern, field;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (!(!_this.props.controlParams.indexPattern || !_this.props.controlParams.fieldName)) {
                _context.next = 3;
                break;
              }

              _this.setState({
                isLoadingFieldType: false
              });

              return _context.abrupt("return");

            case 3:
              _context.prev = 3;
              _context.next = 6;
              return _this.props.getIndexPattern(_this.props.controlParams.indexPattern);

            case 6:
              indexPattern = _context.sent;
              _context.next = 12;
              break;

            case 9:
              _context.prev = 9;
              _context.t0 = _context["catch"](3);
              return _context.abrupt("return");

            case 12:
              if (_this.isMounted) {
                _context.next = 14;
                break;
              }

              return _context.abrupt("return");

            case 14:
              field = indexPattern.fields.find(function (_ref2) {
                var name = _ref2.name;
                return name === _this.props.controlParams.fieldName;
              });

              if (field) {
                _context.next = 17;
                break;
              }

              return _context.abrupt("return");

            case 17:
              _this.setState({
                isLoadingFieldType: false,
                isStringField: field.type === 'string'
              });

            case 18:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, null, [[3, 9]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "renderOptions", function () {
      var _this$props$controlPa, _this$props$controlPa2;

      if (_this.state.isLoadingFieldType || !_this.props.controlParams.fieldName) {
        return;
      }

      var options = [];

      if (_this.props.parentCandidates && _this.props.parentCandidates.length > 0) {
        var parentCandidatesOptions = [{
          value: '',
          text: ''
        }].concat(_toConsumableArray(_this.props.parentCandidates));
        options.push( /*#__PURE__*/React.createElement(EuiFormRow, {
          id: "parentSelect-".concat(_this.props.controlIndex),
          label: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "inputControl.editor.listControl.parentLabel",
            defaultMessage: "Parent control"
          }),
          helpText: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "inputControl.editor.listControl.parentDescription",
            defaultMessage: "Options are based on the value of parent control. Disabled if parent is not set."
          }),
          key: "parentSelect"
        }, /*#__PURE__*/React.createElement(EuiSelect, {
          options: parentCandidatesOptions,
          value: _this.props.controlParams.parent,
          onChange: function onChange(event) {
            _this.props.handleParentChange(_this.props.controlIndex, event.target.value);
          }
        })));
      }

      options.push( /*#__PURE__*/React.createElement(EuiFormRow, {
        id: "multiselect-".concat(_this.props.controlIndex),
        key: "multiselect",
        helpText: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inputControl.editor.listControl.multiselectDescription",
          defaultMessage: "Allow multiple selection"
        })
      }, /*#__PURE__*/React.createElement(EuiSwitch, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inputControl.editor.listControl.multiselectLabel",
          defaultMessage: "Multiselect"
        }),
        checked: (_this$props$controlPa = _this.props.controlParams.options.multiselect) !== null && _this$props$controlPa !== void 0 ? _this$props$controlPa : true,
        onChange: function onChange(event) {
          _this.props.handleOptionsChange(_this.props.controlIndex, 'multiselect', event.target.checked);
        },
        "data-test-subj": "listControlMultiselectInput"
      })));
      var dynamicOptionsHelpText = _this.state.isStringField ? /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inputControl.editor.listControl.dynamicOptions.updateDescription",
        defaultMessage: "Update options in response to user input"
      }) : /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inputControl.editor.listControl.dynamicOptions.stringFieldDescription",
        defaultMessage: "Only available for \"string\" fields"
      });
      options.push( /*#__PURE__*/React.createElement(EuiFormRow, {
        id: "dynamicOptions-".concat(_this.props.controlIndex),
        key: "dynamicOptions",
        helpText: dynamicOptionsHelpText
      }, /*#__PURE__*/React.createElement(EuiSwitch, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inputControl.editor.listControl.dynamicOptionsLabel",
          defaultMessage: "Dynamic Options"
        }),
        checked: (_this$props$controlPa2 = _this.props.controlParams.options.dynamicOptions) !== null && _this$props$controlPa2 !== void 0 ? _this$props$controlPa2 : false,
        onChange: function onChange(event) {
          _this.props.handleOptionsChange(_this.props.controlIndex, 'dynamicOptions', event.target.checked);
        },
        disabled: _this.state.isStringField ? false : true,
        "data-test-subj": "listControlDynamicOptionsSwitch"
      }))); // size is not used when dynamic options is set

      if (!_this.props.controlParams.options.dynamicOptions || !_this.state.isStringField) {
        options.push( /*#__PURE__*/React.createElement(EuiFormRow, {
          id: "size-".concat(_this.props.controlIndex),
          label: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "inputControl.editor.listControl.sizeLabel",
            defaultMessage: "Size"
          }),
          key: "size",
          helpText: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "inputControl.editor.listControl.sizeDescription",
            defaultMessage: "Number of options"
          })
        }, /*#__PURE__*/React.createElement(EuiFieldNumber, {
          min: 1,
          value: _this.props.controlParams.options.size,
          onChange: function onChange(event) {
            _this.props.handleOptionsChange(_this.props.controlIndex, 'size', event.target.valueAsNumber);
          },
          "data-test-subj": "listControlSizeInput"
        })));
      }

      return options;
    });

    return _this;
  }

  _createClass(ListControlEditor, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.isMounted = true;
      this.loadIsStringField();
      this.getIndexPatternSelect();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.isMounted = false;
    }
  }, {
    key: "getIndexPatternSelect",
    value: function () {
      var _getIndexPatternSelect = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
        var _yield$this$props$dep, _yield$this$props$dep2, data;

        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return this.props.deps.core.getStartServices();

              case 2:
                _yield$this$props$dep = _context2.sent;
                _yield$this$props$dep2 = _slicedToArray(_yield$this$props$dep, 2);
                data = _yield$this$props$dep2[1].data;
                this.setState({
                  IndexPatternSelect: data.ui.IndexPatternSelect
                });

              case 6:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function getIndexPatternSelect() {
        return _getIndexPatternSelect.apply(this, arguments);
      }

      return getIndexPatternSelect;
    }()
  }, {
    key: "render",
    value: function render() {
      if (this.state.IndexPatternSelect === null) {
        return null;
      }

      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(IndexPatternSelectFormRow, {
        indexPatternId: this.props.controlParams.indexPattern,
        onChange: this.props.handleIndexPatternChange,
        controlIndex: this.props.controlIndex,
        IndexPatternSelect: this.state.IndexPatternSelect
      }), /*#__PURE__*/React.createElement(FieldSelect, {
        fieldName: this.props.controlParams.fieldName,
        indexPatternId: this.props.controlParams.indexPattern,
        filterField: filterField,
        onChange: this.props.handleFieldNameChange,
        getIndexPattern: this.props.getIndexPattern,
        controlIndex: this.props.controlIndex
      }), this.renderOptions());
    }
  }]);

  return ListControlEditor;
}(PureComponent);

_defineProperty(ListControlEditor, "getDerivedStateFromProps", function (nextProps, prevState) {
  var isNewFieldName = prevState.prevFieldName !== nextProps.controlParams.fieldName;

  if (!prevState.isLoadingFieldType && isNewFieldName) {
    return {
      prevFieldName: nextProps.controlParams.fieldName,
      isLoadingFieldType: true
    };
  }

  return null;
});