function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* eslint-disable no-multi-str*/
import _ from 'lodash';
import { i18n } from '@kbn/i18n';
export function noValuesDisableMsg(fieldName, indexPatternName) {
  return i18n.translate('inputControl.control.noValuesDisableTooltip', {
    defaultMessage: 'Filtering occurs on the "{fieldName}" field, which doesn\'t exist on any documents in the "{indexPatternName}" \
index pattern. Choose a different field or index documents that contain values for this field.',
    values: {
      fieldName: fieldName,
      indexPatternName: indexPatternName
    }
  });
}
export function noIndexPatternMsg(indexPatternId) {
  return i18n.translate('inputControl.control.noIndexPatternTooltip', {
    defaultMessage: 'Could not locate index-pattern id: {indexPatternId}.',
    values: {
      indexPatternId: indexPatternId
    }
  });
}
export var Control = /*#__PURE__*/function () {
  function Control(controlParams, filterManager, useTimeFilter) {
    var _this = this;

    _classCallCheck(this, Control);

    this.controlParams = controlParams;
    this.filterManager = filterManager;
    this.useTimeFilter = useTimeFilter;

    _defineProperty(this, "kbnFilter", null);

    _defineProperty(this, "enable", false);

    _defineProperty(this, "disabledReason", '');

    _defineProperty(this, "value", void 0);

    _defineProperty(this, "id", void 0);

    _defineProperty(this, "options", void 0);

    _defineProperty(this, "type", void 0);

    _defineProperty(this, "label", void 0);

    _defineProperty(this, "ancestors", []);

    _defineProperty(this, "format", function (value) {
      var _field$format;

      var field = _this.filterManager.getField();

      if (field === null || field === void 0 ? void 0 : (_field$format = field.format) === null || _field$format === void 0 ? void 0 : _field$format.convert) {
        return field.format.convert(value);
      }

      return value;
    });

    this.id = controlParams.id;
    this.controlParams = controlParams;
    this.options = controlParams.options;
    this.type = controlParams.type;
    this.label = controlParams.label ? controlParams.label : controlParams.fieldName; // restore state from kibana filter context

    this.reset(); // disable until initialized

    this.disable(i18n.translate('inputControl.control.notInitializedTooltip', {
      defaultMessage: 'Control has not been initialized'
    }));
  }

  _createClass(Control, [{
    key: "setAncestors",
    value: function setAncestors(ancestors) {
      this.ancestors = ancestors;
    }
  }, {
    key: "hasAncestors",
    value: function hasAncestors() {
      return this.ancestors && this.ancestors.length > 0;
    }
  }, {
    key: "hasUnsetAncestor",
    value: function hasUnsetAncestor() {
      return this.ancestors.reduce(function (accumulator, ancestor) {
        return accumulator || !ancestor.hasValue();
      }, false);
    }
  }, {
    key: "getAncestorValues",
    value: function getAncestorValues() {
      return this.ancestors.map(function (ancestor) {
        return ancestor.value;
      });
    }
  }, {
    key: "getAncestorFilters",
    value: function getAncestorFilters() {
      return this.ancestors.map(function (ancestor) {
        return ancestor.filterManager.createFilter(ancestor.value);
      });
    }
  }, {
    key: "isEnabled",
    value: function isEnabled() {
      return this.enable;
    }
  }, {
    key: "disable",
    value: function disable(reason) {
      this.enable = false;
      this.disabledReason = reason;
    }
  }, {
    key: "set",
    value: function set(newValue) {
      this.value = newValue;

      if (this.hasValue()) {
        this.kbnFilter = this.filterManager.createFilter(this.value);
      } else {
        this.kbnFilter = null;
      }
    }
    /*
     * Remove any user changes to value by resetting value to that as provided by Kibana filter pills
     */

  }, {
    key: "reset",
    value: function reset() {
      this.kbnFilter = null;
      this.value = this.filterManager.getValueFromFilterBar();
    }
    /*
     * Clear any filter on the field by setting the control value to undefined.
     */

  }, {
    key: "clear",
    value: function clear() {
      this.value = undefined;
    }
  }, {
    key: "hasChanged",
    value: function hasChanged() {
      return !_.isEqual(this.value, this.filterManager.getValueFromFilterBar());
    }
  }, {
    key: "hasKbnFilter",
    value: function hasKbnFilter() {
      if (this.kbnFilter) {
        return true;
      }

      return false;
    }
  }, {
    key: "getKbnFilter",
    value: function getKbnFilter() {
      return this.kbnFilter;
    }
  }, {
    key: "hasValue",
    value: function hasValue() {
      return this.value !== undefined;
    }
  }]);

  return Control;
}();