function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export function createSearchSource(_x, _x2, _x3, _x4, _x5) {
  return _createSearchSource.apply(this, arguments);
}

function _createSearchSource() {
  _createSearchSource = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref, initialState, indexPattern, aggs, useTimeFilter) {
    var create,
        filters,
        timefilter,
        searchSource,
        _args = arguments;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            create = _ref.create;
            filters = _args.length > 5 && _args[5] !== undefined ? _args[5] : [];
            timefilter = _args.length > 6 ? _args[6] : undefined;
            _context.next = 5;
            return create(initialState || {});

          case 5:
            searchSource = _context.sent;
            // Do not not inherit from rootSearchSource to avoid picking up time and globals
            searchSource.setParent(undefined);
            searchSource.setField('filter', function () {
              var activeFilters = _toConsumableArray(filters);

              if (useTimeFilter) {
                var filter = timefilter.createFilter(indexPattern);

                if (filter) {
                  activeFilters.push(filter);
                }
              }

              return activeFilters;
            });
            searchSource.setField('size', 0);
            searchSource.setField('index', indexPattern);
            searchSource.setField('aggs', aggs);
            return _context.abrupt("return", searchSource);

          case 12:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _createSearchSource.apply(this, arguments);
}