/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { FormattedMessage } from '@kbn/i18n/react';
import { EuiHorizontalRule, EuiIcon, EuiPageContent, EuiSpacer, EuiText, EuiTitle } from '@elastic/eui';
export var ManagementLandingPage = function ManagementLandingPage(_ref) {
  var version = _ref.version,
      setBreadcrumbs = _ref.setBreadcrumbs;
  setBreadcrumbs();
  return /*#__PURE__*/React.createElement(EuiPageContent, {
    horizontalPosition: "center",
    "data-test-subj": "managementHome"
  }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
    className: "eui-textCenter"
  }, /*#__PURE__*/React.createElement(EuiIcon, {
    type: "managementApp",
    size: "xxl"
  }), /*#__PURE__*/React.createElement(EuiSpacer, null), /*#__PURE__*/React.createElement(EuiTitle, null, /*#__PURE__*/React.createElement("h1", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "management.landing.header",
    defaultMessage: "Welcome to Stack Management {version}",
    values: {
      version: version
    }
  }))), /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "management.landing.subhead",
    defaultMessage: "Manage your indices, index patterns, saved objects, Kibana settings, and more."
  }))), /*#__PURE__*/React.createElement(EuiHorizontalRule, null), /*#__PURE__*/React.createElement(EuiText, {
    color: "subdued",
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "management.landing.text",
    defaultMessage: "A complete list of apps is in the menu on the left."
  })))));
};