function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useMemo } from 'react';
import { EuiPanel, EuiSpacer, EuiTitle } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { SelectOption, SwitchOption } from '../../../charts/public';
import { WmsInternalOptions } from './wms_internal_options';

var mapLayerForOption = function mapLayerForOption(_ref) {
  var id = _ref.id;
  return {
    text: id,
    value: id
  };
};

function WmsOptions(_ref2) {
  var stateParams = _ref2.stateParams,
      setValue = _ref2.setValue,
      vis = _ref2.vis;
  var wms = stateParams.wms;
  var tmsLayers = vis.type.editorConfig.collections.tmsLayers;
  var tmsLayerOptions = useMemo(function () {
    return tmsLayers.map(mapLayerForOption);
  }, [tmsLayers]);

  var setWmsOption = function setWmsOption(paramName, value) {
    return setValue('wms', _objectSpread(_objectSpread({}, wms), {}, _defineProperty({}, paramName, value)));
  };

  var selectTmsLayer = function selectTmsLayer(id) {
    var layer = tmsLayers.find(function (l) {
      return l.id === id;
    });

    if (layer) {
      setWmsOption('selectedTmsLayer', layer);
    }
  };

  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "maps_legacy.wmsOptions.baseLayerSettingsTitle",
    defaultMessage: "Base layer settings"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('maps_legacy.wmsOptions.wmsMapServerLabel', {
      defaultMessage: 'WMS map server'
    }),
    tooltip: i18n.translate('maps_legacy.wmsOptions.useWMSCompliantMapTileServerTip', {
      defaultMessage: 'Use WMS compliant map tile server. For advanced users only.'
    }),
    paramName: "enabled",
    value: wms.enabled,
    setValue: setWmsOption
  }), !wms.enabled && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SelectOption, {
    id: "wmsOptionsSelectTmsLayer",
    label: i18n.translate('maps_legacy.wmsOptions.layersLabel', {
      defaultMessage: 'Layers'
    }),
    options: tmsLayerOptions,
    paramName: "selectedTmsLayer",
    value: wms.selectedTmsLayer && wms.selectedTmsLayer.id,
    setValue: function setValue(param, value) {
      return selectTmsLayer(value);
    }
  })), wms.enabled && /*#__PURE__*/React.createElement(WmsInternalOptions, {
    wms: wms,
    setValue: setWmsOption
  }));
}

export { WmsOptions };