function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function callResolveImportErrorsApi(_x, _x2, _x3) {
  return _callResolveImportErrorsApi.apply(this, arguments);
}

function _callResolveImportErrorsApi() {
  _callResolveImportErrorsApi = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(http, file, retries) {
    var formData;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            formData = new FormData();
            formData.append('file', file);
            formData.append('retries', JSON.stringify(retries));
            return _context.abrupt("return", http.post('/api/saved_objects/_resolve_import_errors', {
              headers: {
                // Important to be undefined, it forces proper headers to be set for FormData
                'Content-Type': undefined
              },
              body: formData
            }));

          case 4:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _callResolveImportErrorsApi.apply(this, arguments);
}

function mapImportFailureToRetryObject(_ref) {
  var failure = _ref.failure,
      overwriteDecisionCache = _ref.overwriteDecisionCache,
      replaceReferencesCache = _ref.replaceReferencesCache,
      state = _ref.state;
  var isOverwriteAllChecked = state.isOverwriteAllChecked,
      unmatchedReferences = state.unmatchedReferences;
  var isOverwriteGranted = isOverwriteAllChecked || overwriteDecisionCache.get("".concat(failure.obj.type, ":").concat(failure.obj.id)) === true; // Conflicts wihtout overwrite granted are skipped

  if (!isOverwriteGranted && failure.error.type === 'conflict') {
    return;
  } // Replace references if user chose a new reference


  if (failure.error.type === 'missing_references') {
    var objReplaceReferences = replaceReferencesCache.get("".concat(failure.obj.type, ":").concat(failure.obj.id)) || [];
    var indexPatternRefs = failure.error.references.filter(function (obj) {
      return obj.type === 'index-pattern';
    });

    var _iterator = _createForOfIteratorHelper(indexPatternRefs),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var reference = _step.value;

        var _iterator2 = _createForOfIteratorHelper(unmatchedReferences),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var unmatchedReference = _step2.value;
            var hasNewValue = !!unmatchedReference.newIndexPatternId;
            var matchesIndexPatternId = unmatchedReference.existingIndexPatternId === reference.id;

            if (!hasNewValue || !matchesIndexPatternId) {
              continue;
            }

            objReplaceReferences.push({
              type: 'index-pattern',
              from: unmatchedReference.existingIndexPatternId,
              to: unmatchedReference.newIndexPatternId
            });
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    replaceReferencesCache.set("".concat(failure.obj.type, ":").concat(failure.obj.id), objReplaceReferences); // Skip if nothing to replace, the UI option selected would be --Skip Import--

    if (objReplaceReferences.length === 0) {
      return;
    }
  }

  return {
    id: failure.obj.id,
    type: failure.obj.type,
    overwrite: isOverwriteAllChecked || overwriteDecisionCache.get("".concat(failure.obj.type, ":").concat(failure.obj.id)) === true,
    replaceReferences: replaceReferencesCache.get("".concat(failure.obj.type, ":").concat(failure.obj.id)) || []
  };
}

export function resolveImportErrors(_x4) {
  return _resolveImportErrors.apply(this, arguments);
}

function _resolveImportErrors() {
  _resolveImportErrors = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(_ref2) {
    var http, getConflictResolutions, state, overwriteDecisionCache, replaceReferencesCache, successImportCount, _state$failedImports, importFailures, file, isOverwriteAllChecked, doesntHaveOverwriteDecision, getOverwriteDecision, callMapImportFailure, isNotSkipped, result, _i, _Object$keys, key, retries, _iterator3, _step3, _loop, _ret, response, _iterator4, _step4, _ref8, error, obj;

    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            http = _ref2.http, getConflictResolutions = _ref2.getConflictResolutions, state = _ref2.state;
            overwriteDecisionCache = new Map();
            replaceReferencesCache = new Map();
            successImportCount = state.importCount, _state$failedImports = state.failedImports, importFailures = _state$failedImports === void 0 ? [] : _state$failedImports;
            file = state.file, isOverwriteAllChecked = state.isOverwriteAllChecked;

            doesntHaveOverwriteDecision = function doesntHaveOverwriteDecision(_ref3) {
              var obj = _ref3.obj;
              return !overwriteDecisionCache.has("".concat(obj.type, ":").concat(obj.id));
            };

            getOverwriteDecision = function getOverwriteDecision(_ref4) {
              var obj = _ref4.obj;
              return overwriteDecisionCache.get("".concat(obj.type, ":").concat(obj.id));
            };

            callMapImportFailure = function callMapImportFailure(failure) {
              return mapImportFailureToRetryObject({
                failure: failure,
                overwriteDecisionCache: overwriteDecisionCache,
                replaceReferencesCache: replaceReferencesCache,
                state: state
              });
            };

            isNotSkipped = function isNotSkipped(failure) {
              return failure.error.type !== 'conflict' && failure.error.type !== 'missing_references' || getOverwriteDecision(failure);
            }; // Loop until all issues are resolved


          case 9:
            if (!importFailures.some(function (failure) {
              return ['conflict', 'missing_references'].includes(failure.error.type);
            })) {
              _context2.next = 46;
              break;
            }

            if (isOverwriteAllChecked) {
              _context2.next = 15;
              break;
            }

            _context2.next = 13;
            return getConflictResolutions(importFailures.filter(function (_ref5) {
              var error = _ref5.error;
              return error.type === 'conflict';
            }).filter(doesntHaveOverwriteDecision).map(function (_ref6) {
              var obj = _ref6.obj;
              return obj;
            }));

          case 13:
            result = _context2.sent;

            for (_i = 0, _Object$keys = Object.keys(result); _i < _Object$keys.length; _i++) {
              key = _Object$keys[_i];
              overwriteDecisionCache.set(key, result[key]);
            }

          case 15:
            // Build retries array
            retries = importFailures.map(callMapImportFailure).filter(function (obj) {
              return !!obj;
            });
            _iterator3 = _createForOfIteratorHelper(importFailures);
            _context2.prev = 17;

            _loop = function _loop() {
              var _step3$value = _step3.value,
                  error = _step3$value.error,
                  obj = _step3$value.obj;

              if (error.type !== 'missing_references') {
                return "continue";
              }

              if (!retries.some(function (retryObj) {
                return retryObj.type === obj.type && retryObj.id === obj.id;
              })) {
                return "continue";
              }

              var _iterator5 = _createForOfIteratorHelper(error.blocking || []),
                  _step5;

              try {
                for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                  var _step5$value = _step5.value,
                      type = _step5$value.type,
                      id = _step5$value.id;
                  retries.push({
                    type: type,
                    id: id
                  });
                }
              } catch (err) {
                _iterator5.e(err);
              } finally {
                _iterator5.f();
              }
            };

            _iterator3.s();

          case 20:
            if ((_step3 = _iterator3.n()).done) {
              _context2.next = 26;
              break;
            }

            _ret = _loop();

            if (!(_ret === "continue")) {
              _context2.next = 24;
              break;
            }

            return _context2.abrupt("continue", 24);

          case 24:
            _context2.next = 20;
            break;

          case 26:
            _context2.next = 31;
            break;

          case 28:
            _context2.prev = 28;
            _context2.t0 = _context2["catch"](17);

            _iterator3.e(_context2.t0);

          case 31:
            _context2.prev = 31;

            _iterator3.f();

            return _context2.finish(31);

          case 34:
            if (!(retries.length === 0)) {
              _context2.next = 37;
              break;
            }

            // Cancelled overwrites aren't failures anymore
            importFailures = importFailures.filter(isNotSkipped);
            return _context2.abrupt("break", 46);

          case 37:
            _context2.next = 39;
            return callResolveImportErrorsApi(http, file, retries);

          case 39:
            response = _context2.sent;
            successImportCount += response.successCount;
            importFailures = [];
            _iterator4 = _createForOfIteratorHelper(response.errors || []);

            try {
              for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                _ref8 = _step4.value;
                error = _ref8.error, obj = _objectWithoutProperties(_ref8, ["error"]);
                importFailures.push({
                  error: error,
                  obj: obj
                });
              }
            } catch (err) {
              _iterator4.e(err);
            } finally {
              _iterator4.f();
            }

            _context2.next = 9;
            break;

          case 46:
            return _context2.abrupt("return", {
              status: 'success',
              importCount: successImportCount,
              failedImports: importFailures
            });

          case 47:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, null, [[17, 28, 31, 34]]);
  }));
  return _resolveImportErrors.apply(this, arguments);
}