function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { cloneDeep } from 'lodash';
import { injectSearchSourceReferences } from '../../../data/public';

function getSavedObject(_x, _x2) {
  return _getSavedObject.apply(this, arguments);
}

function _getSavedObject() {
  _getSavedObject = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(doc, services) {
    var service, obj;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            service = services.find(function (s) {
              return s.type === doc._type;
            });

            if (service) {
              _context.next = 3;
              break;
            }

            return _context.abrupt("return");

          case 3:
            _context.next = 5;
            return service.get();

          case 5:
            obj = _context.sent;
            obj.id = doc._id;
            obj.migrationVersion = doc._migrationVersion;
            return _context.abrupt("return", obj);

          case 9:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _getSavedObject.apply(this, arguments);
}

function addJsonFieldToIndexPattern(target, sourceString, fieldName, indexName) {
  if (sourceString) {
    try {
      target[fieldName] = JSON.parse(sourceString);
    } catch (error) {
      throw new Error(i18n.translate('savedObjectsManagement.parsingFieldErrorMessage', {
        defaultMessage: 'Error encountered parsing {fieldName} for index pattern {indexName}: {errorMessage}',
        values: {
          fieldName: fieldName,
          indexName: indexName,
          errorMessage: error.message
        }
      }));
    }
  }
}

function importIndexPattern(_x3, _x4, _x5, _x6) {
  return _importIndexPattern.apply(this, arguments);
}

function _importIndexPattern() {
  _importIndexPattern = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(doc, indexPatterns, overwriteAll, openConfirm) {
    var emptyPattern, _doc$_source, title, timeFieldName, fields, fieldFormatMap, sourceFilters, type, typeMeta, importedIndexPattern, newId, isConfirmed;

    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return indexPatterns.make();

          case 2:
            emptyPattern = _context2.sent;
            _doc$_source = doc._source, title = _doc$_source.title, timeFieldName = _doc$_source.timeFieldName, fields = _doc$_source.fields, fieldFormatMap = _doc$_source.fieldFormatMap, sourceFilters = _doc$_source.sourceFilters, type = _doc$_source.type, typeMeta = _doc$_source.typeMeta;
            importedIndexPattern = {
              id: doc._id,
              title: title,
              timeFieldName: timeFieldName
            };

            if (type) {
              importedIndexPattern.type = type;
            }

            addJsonFieldToIndexPattern(importedIndexPattern, fields, 'fields', title);
            addJsonFieldToIndexPattern(importedIndexPattern, fieldFormatMap, 'fieldFormatMap', title);
            addJsonFieldToIndexPattern(importedIndexPattern, sourceFilters, 'sourceFilters', title);
            addJsonFieldToIndexPattern(importedIndexPattern, typeMeta, 'typeMeta', title);
            Object.assign(emptyPattern, importedIndexPattern);
            _context2.next = 13;
            return emptyPattern.create(overwriteAll);

          case 13:
            newId = _context2.sent;

            if (newId) {
              _context2.next = 25;
              break;
            }

            _context2.next = 17;
            return openConfirm(i18n.translate('savedObjectsManagement.indexPattern.confirmOverwriteLabel', {
              values: {
                title: title
              },
              defaultMessage: "Are you sure you want to overwrite '{title}'?"
            }), {
              title: i18n.translate('savedObjectsManagement.indexPattern.confirmOverwriteTitle', {
                defaultMessage: 'Overwrite {type}?',
                values: {
                  type: type
                }
              }),
              confirmButtonText: i18n.translate('savedObjectsManagement.indexPattern.confirmOverwriteButton', {
                defaultMessage: 'Overwrite'
              })
            });

          case 17:
            isConfirmed = _context2.sent;

            if (!isConfirmed) {
              _context2.next = 24;
              break;
            }

            _context2.next = 21;
            return emptyPattern.create(true);

          case 21:
            newId = _context2.sent;
            _context2.next = 25;
            break;

          case 24:
            return _context2.abrupt("return");

          case 25:
            indexPatterns.clearCache(newId);
            return _context2.abrupt("return", newId);

          case 27:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _importIndexPattern.apply(this, arguments);
}

function importDocument(_x7, _x8, _x9) {
  return _importDocument.apply(this, arguments);
}

function _importDocument() {
  _importDocument = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(obj, doc, overwriteAll) {
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return obj.applyESResp(_objectSpread({
              references: doc._references || []
            }, cloneDeep(doc)));

          case 2:
            _context3.next = 4;
            return obj.save({
              confirmOverwrite: !overwriteAll
            });

          case 4:
            return _context3.abrupt("return", _context3.sent);

          case 5:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _importDocument.apply(this, arguments);
}

function groupByType(docs) {
  var defaultDocTypes = {
    searches: [],
    indexPatterns: [],
    other: []
  };
  return docs.reduce(function (types, doc) {
    switch (doc._type) {
      case 'search':
        types.searches.push(doc);
        break;

      case 'index-pattern':
        types.indexPatterns.push(doc);
        break;

      default:
        types.other.push(doc);
    }

    return types;
  }, defaultDocTypes);
}

function awaitEachItemInParallel(_x10, _x11) {
  return _awaitEachItemInParallel.apply(this, arguments);
}

function _awaitEachItemInParallel() {
  _awaitEachItemInParallel = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(list, op) {
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return Promise.all(list.map(function (item) {
              return op(item);
            }));

          case 2:
            return _context4.abrupt("return", _context4.sent);

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _awaitEachItemInParallel.apply(this, arguments);
}

export function resolveIndexPatternConflicts(_x12, _x13, _x14, _x15) {
  return _resolveIndexPatternConflicts.apply(this, arguments);
}

function _resolveIndexPatternConflicts() {
  _resolveIndexPatternConflicts = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(resolutions, conflictedIndexPatterns, overwriteAll, dependencies) {
    var importCount;
    return regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            importCount = 0;
            _context6.next = 3;
            return awaitEachItemInParallel(conflictedIndexPatterns, /*#__PURE__*/function () {
              var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(_ref) {
                var _doc$_source$kibanaSa;

                var obj, doc, serializedSearchSource, oldIndexId, allResolved, inlineResolution, filter, replacedReferences, serializedSearchSourceWithInjectedReferences;
                return regeneratorRuntime.wrap(function _callee5$(_context5) {
                  while (1) {
                    switch (_context5.prev = _context5.next) {
                      case 0:
                        obj = _ref.obj, doc = _ref.doc;
                        serializedSearchSource = JSON.parse(((_doc$_source$kibanaSa = doc._source.kibanaSavedObjectMeta) === null || _doc$_source$kibanaSa === void 0 ? void 0 : _doc$_source$kibanaSa.searchSourceJSON) || '{}');
                        oldIndexId = serializedSearchSource.index;
                        allResolved = true;
                        inlineResolution = resolutions.find(function (_ref3) {
                          var oldId = _ref3.oldId;
                          return oldId === oldIndexId;
                        });

                        if (inlineResolution) {
                          serializedSearchSource.index = inlineResolution.newId;
                        } else {
                          allResolved = false;
                        } // Resolve filter index reference:


                        filter = (serializedSearchSource.filter || []).map(function (f) {
                          if (!(f.meta && f.meta.index)) {
                            return f;
                          }

                          var resolution = resolutions.find(function (_ref4) {
                            var oldId = _ref4.oldId;
                            return oldId === f.meta.index;
                          });
                          return resolution ? _objectSpread(_objectSpread({}, f), {
                            meta: _objectSpread(_objectSpread({}, f.meta), {}, {
                              index: resolution.newId
                            })
                          }) : f;
                        });

                        if (filter.length > 0) {
                          serializedSearchSource.filter = filter;
                        }

                        replacedReferences = (doc._references || []).map(function (reference) {
                          var resolution = resolutions.find(function (_ref5) {
                            var oldId = _ref5.oldId;
                            return oldId === reference.id;
                          });

                          if (resolution) {
                            return _objectSpread(_objectSpread({}, reference), {}, {
                              id: resolution.newId
                            });
                          } else {
                            allResolved = false;
                          }

                          return reference;
                        });
                        serializedSearchSourceWithInjectedReferences = injectSearchSourceReferences(serializedSearchSource, replacedReferences);

                        if (allResolved) {
                          _context5.next = 12;
                          break;
                        }

                        return _context5.abrupt("return");

                      case 12:
                        _context5.next = 14;
                        return dependencies.search.searchSource.create(serializedSearchSourceWithInjectedReferences);

                      case 14:
                        obj.searchSource = _context5.sent;
                        _context5.next = 17;
                        return saveObject(obj, overwriteAll);

                      case 17:
                        if (!_context5.sent) {
                          _context5.next = 19;
                          break;
                        }

                        importCount++;

                      case 19:
                      case "end":
                        return _context5.stop();
                    }
                  }
                }, _callee5);
              }));

              return function (_x29) {
                return _ref2.apply(this, arguments);
              };
            }());

          case 3:
            return _context6.abrupt("return", importCount);

          case 4:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6);
  }));
  return _resolveIndexPatternConflicts.apply(this, arguments);
}

export function saveObjects(_x16, _x17) {
  return _saveObjects.apply(this, arguments);
}

function _saveObjects() {
  _saveObjects = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8(objs, overwriteAll) {
    var importCount;
    return regeneratorRuntime.wrap(function _callee8$(_context8) {
      while (1) {
        switch (_context8.prev = _context8.next) {
          case 0:
            importCount = 0;
            _context8.next = 3;
            return awaitEachItemInParallel(objs, /*#__PURE__*/function () {
              var _ref6 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7(obj) {
                return regeneratorRuntime.wrap(function _callee7$(_context7) {
                  while (1) {
                    switch (_context7.prev = _context7.next) {
                      case 0:
                        _context7.next = 2;
                        return saveObject(obj, overwriteAll);

                      case 2:
                        if (!_context7.sent) {
                          _context7.next = 4;
                          break;
                        }

                        importCount++;

                      case 4:
                      case "end":
                        return _context7.stop();
                    }
                  }
                }, _callee7);
              }));

              return function (_x30) {
                return _ref6.apply(this, arguments);
              };
            }());

          case 3:
            return _context8.abrupt("return", importCount);

          case 4:
          case "end":
            return _context8.stop();
        }
      }
    }, _callee8);
  }));
  return _saveObjects.apply(this, arguments);
}

export function saveObject(_x18, _x19) {
  return _saveObject.apply(this, arguments);
}

function _saveObject() {
  _saveObject = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9(obj, overwriteAll) {
    return regeneratorRuntime.wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            _context9.next = 2;
            return obj.save({
              confirmOverwrite: !overwriteAll
            });

          case 2:
            return _context9.abrupt("return", _context9.sent);

          case 3:
          case "end":
            return _context9.stop();
        }
      }
    }, _callee9);
  }));
  return _saveObject.apply(this, arguments);
}

export function resolveSavedSearches(_x20, _x21, _x22, _x23) {
  return _resolveSavedSearches.apply(this, arguments);
}

function _resolveSavedSearches() {
  _resolveSavedSearches = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee11(savedSearches, services, indexPatterns, overwriteAll) {
    var importCount;
    return regeneratorRuntime.wrap(function _callee11$(_context11) {
      while (1) {
        switch (_context11.prev = _context11.next) {
          case 0:
            importCount = 0;
            _context11.next = 3;
            return awaitEachItemInParallel(savedSearches, /*#__PURE__*/function () {
              var _ref7 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10(searchDoc) {
                var obj;
                return regeneratorRuntime.wrap(function _callee10$(_context10) {
                  while (1) {
                    switch (_context10.prev = _context10.next) {
                      case 0:
                        _context10.next = 2;
                        return getSavedObject(searchDoc, services);

                      case 2:
                        obj = _context10.sent;

                        if (obj) {
                          _context10.next = 5;
                          break;
                        }

                        return _context10.abrupt("return");

                      case 5:
                        _context10.next = 7;
                        return importDocument(obj, searchDoc, overwriteAll);

                      case 7:
                        if (!_context10.sent) {
                          _context10.next = 9;
                          break;
                        }

                        importCount++;

                      case 9:
                      case "end":
                        return _context10.stop();
                    }
                  }
                }, _callee10);
              }));

              return function (_x31) {
                return _ref7.apply(this, arguments);
              };
            }());

          case 3:
            return _context11.abrupt("return", importCount);

          case 4:
          case "end":
            return _context11.stop();
        }
      }
    }, _callee11);
  }));
  return _resolveSavedSearches.apply(this, arguments);
}

export function resolveSavedObjects(_x24, _x25, _x26, _x27, _x28) {
  return _resolveSavedObjects.apply(this, arguments);
}

function _resolveSavedObjects() {
  _resolveSavedObjects = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee15(savedObjects, overwriteAll, services, indexPatterns, confirmModalPromise) {
    var docTypes, importedObjectCount, failedImports, conflictedSearchDocs, conflictedIndexPatterns, conflictedSavedObjectsLinkedToSavedSearches;
    return regeneratorRuntime.wrap(function _callee15$(_context15) {
      while (1) {
        switch (_context15.prev = _context15.next) {
          case 0:
            docTypes = groupByType(savedObjects); // Keep track of how many we actually import because the user
            // can cancel an override

            importedObjectCount = 0;
            failedImports = []; // Start with the index patterns since everything is dependent on them

            _context15.next = 5;
            return awaitEachItemInParallel(docTypes.indexPatterns, /*#__PURE__*/function () {
              var _ref8 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee12(indexPatternDoc) {
                var importedIndexPatternId;
                return regeneratorRuntime.wrap(function _callee12$(_context12) {
                  while (1) {
                    switch (_context12.prev = _context12.next) {
                      case 0:
                        _context12.prev = 0;
                        _context12.next = 3;
                        return importIndexPattern(indexPatternDoc, indexPatterns, overwriteAll, confirmModalPromise);

                      case 3:
                        importedIndexPatternId = _context12.sent;

                        if (importedIndexPatternId) {
                          importedObjectCount++;
                        }

                        _context12.next = 10;
                        break;

                      case 7:
                        _context12.prev = 7;
                        _context12.t0 = _context12["catch"](0);
                        failedImports.push({
                          obj: indexPatternDoc,
                          error: _context12.t0
                        });

                      case 10:
                      case "end":
                        return _context12.stop();
                    }
                  }
                }, _callee12, null, [[0, 7]]);
              }));

              return function (_x32) {
                return _ref8.apply(this, arguments);
              };
            }());

          case 5:
            // We want to do the same for saved searches, but we want to keep them separate because they need
            // to be applied _first_ because other saved objects can be dependent on those saved searches existing
            conflictedSearchDocs = []; // Keep a record of the index patterns assigned to our imported saved objects that do not
            // exist. We will provide a way for the user to manually select a new index pattern for those
            // saved objects.

            conflictedIndexPatterns = []; // Keep a record of any objects which fail to import for unknown reasons.
            // It's possible to have saved objects that link to saved searches which then link to index patterns
            // and those could error out, but the error comes as an index pattern not found error. We can't resolve
            // those the same as way as normal index pattern not found errors, but when those are fixed, it's very
            // likely that these saved objects will work once resaved so keep them around to resave them.

            conflictedSavedObjectsLinkedToSavedSearches = [];
            _context15.next = 10;
            return awaitEachItemInParallel(docTypes.searches, /*#__PURE__*/function () {
              var _ref9 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee13(searchDoc) {
                var obj;
                return regeneratorRuntime.wrap(function _callee13$(_context13) {
                  while (1) {
                    switch (_context13.prev = _context13.next) {
                      case 0:
                        _context13.next = 2;
                        return getSavedObject(searchDoc, services);

                      case 2:
                        obj = _context13.sent;
                        _context13.prev = 3;
                        _context13.next = 6;
                        return importDocument(obj, searchDoc, overwriteAll);

                      case 6:
                        if (!_context13.sent) {
                          _context13.next = 8;
                          break;
                        }

                        importedObjectCount++;

                      case 8:
                        _context13.next = 13;
                        break;

                      case 10:
                        _context13.prev = 10;
                        _context13.t0 = _context13["catch"](3);

                        if (_context13.t0.constructor.name === 'SavedObjectNotFound') {
                          if (_context13.t0.savedObjectType === 'index-pattern') {
                            conflictedIndexPatterns.push({
                              obj: obj,
                              doc: searchDoc
                            });
                          } else {
                            conflictedSearchDocs.push(searchDoc);
                          }
                        } else {
                          failedImports.push({
                            obj: obj,
                            error: _context13.t0
                          });
                        }

                      case 13:
                      case "end":
                        return _context13.stop();
                    }
                  }
                }, _callee13, null, [[3, 10]]);
              }));

              return function (_x33) {
                return _ref9.apply(this, arguments);
              };
            }());

          case 10:
            _context15.next = 12;
            return awaitEachItemInParallel(docTypes.other, /*#__PURE__*/function () {
              var _ref10 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee14(otherDoc) {
                var obj, isIndexPatternNotFound;
                return regeneratorRuntime.wrap(function _callee14$(_context14) {
                  while (1) {
                    switch (_context14.prev = _context14.next) {
                      case 0:
                        _context14.next = 2;
                        return getSavedObject(otherDoc, services);

                      case 2:
                        obj = _context14.sent;
                        _context14.prev = 3;
                        _context14.next = 6;
                        return importDocument(obj, otherDoc, overwriteAll);

                      case 6:
                        if (!_context14.sent) {
                          _context14.next = 8;
                          break;
                        }

                        importedObjectCount++;

                      case 8:
                        _context14.next = 14;
                        break;

                      case 10:
                        _context14.prev = 10;
                        _context14.t0 = _context14["catch"](3);
                        isIndexPatternNotFound = _context14.t0.constructor.name === 'SavedObjectNotFound' && _context14.t0.savedObjectType === 'index-pattern';

                        if (isIndexPatternNotFound && obj.savedSearchId) {
                          conflictedSavedObjectsLinkedToSavedSearches.push(obj);
                        } else if (isIndexPatternNotFound) {
                          conflictedIndexPatterns.push({
                            obj: obj,
                            doc: otherDoc
                          });
                        } else {
                          failedImports.push({
                            obj: obj,
                            error: _context14.t0
                          });
                        }

                      case 14:
                      case "end":
                        return _context14.stop();
                    }
                  }
                }, _callee14, null, [[3, 10]]);
              }));

              return function (_x34) {
                return _ref10.apply(this, arguments);
              };
            }());

          case 12:
            return _context15.abrupt("return", {
              conflictedIndexPatterns: conflictedIndexPatterns,
              conflictedSavedObjectsLinkedToSavedSearches: conflictedSavedObjectsLinkedToSavedSearches,
              conflictedSearchDocs: conflictedSearchDocs,
              importedObjectCount: importedObjectCount,
              failedImports: failedImports
            });

          case 13:
          case "end":
            return _context15.stop();
        }
      }
    }, _callee15);
  }));
  return _resolveSavedObjects.apply(this, arguments);
}