/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect } from 'react';
import { useParams, useLocation } from 'react-router-dom';
import { parse } from 'query-string';
import { i18n } from '@kbn/i18n';
import { SavedObjectEdition } from './object_view';

var SavedObjectsEditionPage = function SavedObjectsEditionPage(_ref) {
  var coreStart = _ref.coreStart,
      serviceRegistry = _ref.serviceRegistry,
      setBreadcrumbs = _ref.setBreadcrumbs,
      history = _ref.history;

  var _useParams = useParams(),
      serviceName = _useParams.service,
      id = _useParams.id;

  var capabilities = coreStart.application.capabilities;

  var _useLocation = useLocation(),
      search = _useLocation.search;

  var query = parse(search);
  var service = serviceRegistry.get(serviceName);
  useEffect(function () {
    var _service$service$type;

    setBreadcrumbs([{
      text: i18n.translate('savedObjectsManagement.breadcrumb.index', {
        defaultMessage: 'Saved objects'
      }),
      href: '/'
    }, {
      text: i18n.translate('savedObjectsManagement.breadcrumb.edit', {
        defaultMessage: 'Edit {savedObjectType}',
        values: {
          savedObjectType: (_service$service$type = service === null || service === void 0 ? void 0 : service.service.type) !== null && _service$service$type !== void 0 ? _service$service$type : 'object'
        }
      })
    }]);
  }, [setBreadcrumbs, service]);
  return /*#__PURE__*/React.createElement(SavedObjectEdition, {
    id: id,
    serviceName: serviceName,
    serviceRegistry: serviceRegistry,
    savedObjectsClient: coreStart.savedObjects.client,
    overlays: coreStart.overlays,
    notifications: coreStart.notifications,
    capabilities: capabilities,
    notFoundType: query.notFound,
    history: history
  });
}; // eslint-disable-next-line import/no-default-export


export { SavedObjectsEditionPage as default };