function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useEffect, useCallback } from 'react';
import { EuiAccordion, EuiToolTip, EuiButtonIcon, EuiSpacer, EuiIconTip } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { DefaultEditorAggParams } from './agg_params';
import { AGGS_ACTION_KEYS } from './agg_group_state';
import { RowsOrColumnsControl } from './controls/rows_or_columns';
import { RadiusRatioOptionControl } from './controls/radius_ratio_option';
import { getSchemaByName } from '../schemas';
import { buildAggDescription } from './agg_params_helper';

function DefaultEditorAgg(_ref) {
  var _agg$type;

  var agg = _ref.agg,
      aggIndex = _ref.aggIndex,
      aggIsTooLow = _ref.aggIsTooLow,
      dragHandleProps = _ref.dragHandleProps,
      formIsTouched = _ref.formIsTouched,
      groupName = _ref.groupName,
      isDisabled = _ref.isDisabled,
      isDraggable = _ref.isDraggable,
      isLastBucket = _ref.isLastBucket,
      isRemovable = _ref.isRemovable,
      metricAggs = _ref.metricAggs,
      lastParentPipelineAggTitle = _ref.lastParentPipelineAggTitle,
      state = _ref.state,
      setAggParamValue = _ref.setAggParamValue,
      setStateParamValue = _ref.setStateParamValue,
      onAggTypeChange = _ref.onAggTypeChange,
      onToggleEnableAgg = _ref.onToggleEnableAgg,
      removeAgg = _ref.removeAgg,
      setAggsState = _ref.setAggsState,
      schemas = _ref.schemas,
      timeRange = _ref.timeRange;

  var _useState = useState(agg.brandNew),
      _useState2 = _slicedToArray(_useState, 2),
      isEditorOpen = _useState2[0],
      setIsEditorOpen = _useState2[1];

  var _useState3 = useState(true),
      _useState4 = _slicedToArray(_useState3, 2),
      validState = _useState4[0],
      setValidState = _useState4[1];

  var showDescription = !isEditorOpen && validState;
  var showError = !isEditorOpen && !validState;
  var aggName = (_agg$type = agg.type) === null || _agg$type === void 0 ? void 0 : _agg$type.name;
  var disabledParams;
  var aggError; // When a Parent Pipeline agg is selected and this agg is the last bucket.

  var isLastBucketAgg = isLastBucket && lastParentPipelineAggTitle && agg.type;
  var SchemaComponent;

  if (agg.schema === 'split') {
    SchemaComponent = RowsOrColumnsControl;
  }

  if (agg.schema === 'radius') {
    SchemaComponent = RadiusRatioOptionControl;
  }

  if (isLastBucketAgg) {
    if (['date_histogram', 'histogram'].includes(aggName)) {
      disabledParams = ['min_doc_count'];
    } else {
      aggError = i18n.translate('visDefaultEditor.metrics.wrongLastBucketTypeErrorMessage', {
        defaultMessage: 'Last bucket aggregation must be "Date Histogram" or "Histogram" when using "{type}" metric aggregation.',
        values: {
          type: lastParentPipelineAggTitle
        },
        description: 'Date Histogram and Histogram should not be translated'
      });
    }
  }

  var _useState5 = useState(buildAggDescription(agg)),
      _useState6 = _slicedToArray(_useState5, 2),
      aggDescription = _useState6[0],
      setAggDescription = _useState6[1]; // This useEffect is required to update the timeRange value and initiate rerender to keep labels up to date (Issue #57822).


  useEffect(function () {
    if (timeRange && aggName === 'date_histogram') {
      agg.aggConfigs.setTimeRange(timeRange);
    }

    setAggDescription(buildAggDescription(agg));
  }, [agg, aggName, timeRange]);
  useEffect(function () {
    if (isLastBucketAgg && ['date_histogram', 'histogram'].includes(aggName)) {
      setAggParamValue(agg.id, 'min_doc_count', // "histogram" agg has an editor for "min_doc_count" param, which accepts boolean
      // "date_histogram" agg doesn't have an editor for "min_doc_count" param, it should be set as a numeric value
      aggName === 'histogram' ? true : 0);
    }
  }, [aggName, isLastBucketAgg, agg.id, setAggParamValue]);
  var setTouched = useCallback(function (touched) {
    setAggsState({
      type: AGGS_ACTION_KEYS.TOUCHED,
      payload: touched,
      aggId: agg.id
    });
  }, [agg.id, setAggsState]);
  var setValidity = useCallback(function (isValid) {
    setAggsState({
      type: AGGS_ACTION_KEYS.VALID,
      payload: isValid,
      aggId: agg.id
    });
    setValidState(isValid);
  }, [agg.id, setAggsState]);
  var onToggle = useCallback(function (isOpen) {
    setIsEditorOpen(isOpen);

    if (!isOpen) {
      setTouched(true);
    }
  }, [setTouched]);

  var renderAggButtons = function renderAggButtons() {
    var actionIcons = [];

    if (showError) {
      actionIcons.push({
        id: 'hasErrors',
        color: 'danger',
        type: 'alert',
        tooltip: i18n.translate('visDefaultEditor.agg.errorsAriaLabel', {
          defaultMessage: 'Aggregation has errors'
        }),
        dataTestSubj: 'hasErrorsAggregationIcon'
      });
    }

    if (agg.enabled && isRemovable) {
      actionIcons.push({
        id: 'disableAggregation',
        color: 'text',
        disabled: isDisabled,
        type: 'eye',
        onClick: function onClick() {
          return onToggleEnableAgg(agg.id, false);
        },
        tooltip: i18n.translate('visDefaultEditor.agg.disableAggButtonTooltip', {
          defaultMessage: 'Disable aggregation'
        }),
        dataTestSubj: 'toggleDisableAggregationBtn disable'
      });
    }

    if (!agg.enabled) {
      actionIcons.push({
        id: 'enableAggregation',
        color: 'text',
        type: 'eyeClosed',
        onClick: function onClick() {
          return onToggleEnableAgg(agg.id, true);
        },
        tooltip: i18n.translate('visDefaultEditor.agg.enableAggButtonTooltip', {
          defaultMessage: 'Enable aggregation'
        }),
        dataTestSubj: 'toggleDisableAggregationBtn enable'
      });
    }

    if (isDraggable) {
      actionIcons.push({
        id: 'dragHandle',
        type: 'grab',
        tooltip: i18n.translate('visDefaultEditor.agg.modifyPriorityButtonTooltip', {
          defaultMessage: 'Modify priority by dragging'
        }),
        dataTestSubj: 'dragHandleBtn'
      });
    }

    if (isRemovable) {
      actionIcons.push({
        id: 'removeDimension',
        color: 'danger',
        type: 'cross',
        onClick: function onClick() {
          return removeAgg(agg.id);
        },
        tooltip: i18n.translate('visDefaultEditor.agg.removeDimensionButtonTooltip', {
          defaultMessage: 'Remove dimension'
        }),
        dataTestSubj: 'removeDimensionBtn'
      });
    }

    return /*#__PURE__*/React.createElement("div", dragHandleProps, actionIcons.map(function (icon) {
      if (icon.id === 'dragHandle') {
        var _ref2;

        return /*#__PURE__*/React.createElement(EuiIconTip, {
          key: icon.id,
          type: icon.type,
          content: icon.tooltip,
          iconProps: (_ref2 = {}, _defineProperty(_ref2, 'aria-label', icon.tooltip), _defineProperty(_ref2, 'data-test-subj', icon.dataTestSubj), _ref2),
          position: "bottom"
        });
      }

      return /*#__PURE__*/React.createElement(EuiToolTip, {
        key: icon.id,
        position: "bottom",
        content: icon.tooltip
      }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
        disabled: icon.disabled,
        iconType: icon.type,
        color: icon.color,
        onClick: icon.onClick,
        "aria-label": icon.tooltip,
        "data-test-subj": icon.dataTestSubj
      }));
    }));
  };

  var schemaTitle = getSchemaByName(schemas, agg.schema).title;
  var buttonContent = /*#__PURE__*/React.createElement(React.Fragment, null, schemaTitle || agg.schema, " ", showDescription && /*#__PURE__*/React.createElement("span", null, aggDescription));
  return /*#__PURE__*/React.createElement(EuiAccordion, {
    id: "visEditorAggAccordion".concat(agg.id),
    initialIsOpen: isEditorOpen,
    buttonContent: buttonContent,
    buttonClassName: "eui-textTruncate",
    buttonContentClassName: "visEditorSidebar__aggGroupAccordionButtonContent eui-textTruncate",
    className: "visEditorSidebar__section visEditorSidebar__collapsible visEditorSidebar__collapsible--marginBottom",
    "aria-label": i18n.translate('visDefaultEditor.agg.toggleEditorButtonAriaLabel', {
      defaultMessage: 'Toggle {schema} editor',
      values: {
        schema: schemaTitle || agg.schema
      }
    }),
    "data-test-subj": "visEditorAggAccordion".concat(agg.id),
    extraAction: renderAggButtons(),
    onToggle: onToggle
  }, /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), SchemaComponent && /*#__PURE__*/React.createElement(SchemaComponent, {
    agg: agg,
    editorStateParams: state.params,
    setAggParamValue: setAggParamValue,
    setStateParamValue: setStateParamValue
  }), /*#__PURE__*/React.createElement(DefaultEditorAggParams, {
    agg: agg,
    aggError: aggError,
    aggIndex: aggIndex,
    aggIsTooLow: aggIsTooLow,
    disabledParams: disabledParams,
    formIsTouched: formIsTouched,
    groupName: groupName,
    indexPattern: agg.getIndexPattern(),
    metricAggs: metricAggs,
    state: state,
    setAggParamValue: setAggParamValue,
    onAggTypeChange: onAggTypeChange,
    setTouched: setTouched,
    setValidity: setValidity,
    schemas: schemas
  })));
}

export { DefaultEditorAgg };